/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nrtg.commander.internal;

import java.util.TreeSet;
import java.util.logging.Level;
import org.opennms.nrtg.api.model.CollectionJob;
import org.opennms.nrtg.api.model.CollectionTask;
import org.opennms.nrtg.api.model.DefaultCollectionJob;
import org.opennms.nrtg.commander.internal.CollectionCommanderStarter;
import org.opennms.nrtg.commander.internal.JobPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;

public class PooledJobPublisher
implements JobPublisher,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PooledJobPublisher.class);
    private final JmsTemplate jmsTemplate = (JmsTemplate)CollectionCommanderStarter.getContext().getBean("JmsTemplate");
    private final CollectionTask task;
    private CollectionJob job = null;

    public PooledJobPublisher(CollectionTask task) {
        this.task = task;
    }

    @Override
    public void publishJob(CollectionJob job, String site) {
        this.jmsTemplate.convertAndSend(site, (Object)job);
    }

    @Override
    public void run() {
        for (int i = 0; i < this.task.getCount(); ++i) {
            CollectionJob job = this.createTestJob();
            logger.info("publishJob '{}' start", (Object)(i + " " + Thread.currentThread()));
            Long startTime = System.currentTimeMillis();
            this.publishJob(job, "NrtCollectMe");
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException ex) {
                java.util.logging.Logger.getLogger(PooledJobPublisher.class.getName()).log(Level.SEVERE, null, ex);
            }
            logger.info("publishJob '{}' done after'{}'", (Object)(i + " " + Thread.currentThread()), (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private CollectionJob createTestJob() {
        if (this.job == null) {
            TreeSet<String> destinationSet = new TreeSet<String>();
            destinationSet.add("NrtResults");
            DefaultCollectionJob snmpJob = new DefaultCollectionJob();
            snmpJob.addMetric(".1.3.6.1.4.1.2021.9.1.9.1", destinationSet, "DummyName");
            snmpJob.setNetInterface("127.0.0.1");
            snmpJob.setService("SNMP");
            this.job = snmpJob;
        }
        return this.job;
    }
}

