/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nrtg.jar.nrtcollector;

import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.opennms.netmgt.snmp.SnmpStrategy;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JStrategy;
import org.opennms.nrtg.nrtcollector.api.NrtCollector;
import org.opennms.nrtg.nrtcollector.internal.ProtocolCollectorRegistry;
import org.opennms.nrtg.nrtcollector.internal.ProtocolCollectorRegistryImpl;
import org.opennms.nrtg.nrtcollector.internal.jms.CollectionJobListener;
import org.opennms.nrtg.nrtcollector.internal.jms.JmsExceptionListener;
import org.opennms.nrtg.nrtcollector.internal.jms.NrtCollectorJMSDLMC;
import org.opennms.nrtg.protocolcollector.snmp.internal.SnmpProtocolCollector;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

@Configuration
public class AppConfig {
    @Bean(name={"connectionFactory"})
    public CachingConnectionFactory connectionFactory() {
        CachingConnectionFactory cachingConnectionFactory = new CachingConnectionFactory();
        cachingConnectionFactory.setTargetConnectionFactory(this.amqConnectionFactory());
        cachingConnectionFactory.setSessionCacheSize(16);
        cachingConnectionFactory.setExceptionListener(this.jmsExceptionListener());
        return cachingConnectionFactory;
    }

    @Bean(name={"jmsExceptionListener"})
    public ExceptionListener jmsExceptionListener() {
        return new JmsExceptionListener();
    }

    @Bean(name={"amqConnectionFactory"})
    public ConnectionFactory amqConnectionFactory() {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(ActiveMQConnectionFactory.DEFAULT_BROKER_URL);
        return connectionFactory;
    }

    @Bean(name={"JmsTemplate"})
    public JmsTemplate jmsTemplate() {
        return new JmsTemplate((ConnectionFactory)this.connectionFactory());
    }

    @Bean(name={"listenerContainer"})
    public AbstractMessageListenerContainer listenerContainer() {
        CollectionJobListener collectionJobListener = new CollectionJobListener(this.jmsTemplate());
        collectionJobListener.setProtocolCollectorRegistry(this.protocolCollectorRegistry());
        DefaultMessageListenerContainer listenerContainer = new DefaultMessageListenerContainer();
        listenerContainer.setConnectionFactory((ConnectionFactory)this.connectionFactory());
        listenerContainer.setConcurrentConsumers(16);
        listenerContainer.setMaxConcurrentConsumers(16);
        listenerContainer.setDestinationName("NrtCollectMe");
        listenerContainer.setMessageListener((Object)collectionJobListener);
        return listenerContainer;
    }

    @Bean(name={"nrtCollector"})
    public NrtCollector collectorJmsDLMC() {
        NrtCollectorJMSDLMC collector = new NrtCollectorJMSDLMC();
        collector.setListenerContainer(this.listenerContainer());
        return collector;
    }

    @Bean(name={"snmpStrategy"})
    public SnmpStrategy snmpStrategy() {
        return new Snmp4JStrategy();
    }

    @Bean(name={"snmpCollector"})
    public SnmpProtocolCollector snmpCollector() {
        SnmpProtocolCollector snmpCollector = new SnmpProtocolCollector();
        snmpCollector.setSnmpStrategy(this.snmpStrategy());
        return snmpCollector;
    }

    @Bean(name={"protocolCollectorRegistry"})
    public ProtocolCollectorRegistry protocolCollectorRegistry() {
        ProtocolCollectorRegistryImpl registry = new ProtocolCollectorRegistryImpl();
        registry.getProtocolCollectors().add(this.snmpCollector());
        return registry;
    }
}

