/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nrtg.api.model;

import java.util.ArrayList;
import java.util.List;
import org.opennms.nrtg.api.model.Measurement;
import org.opennms.nrtg.api.model.MeasurementSet;

public class DefaultMeasurementSet
implements MeasurementSet {
    private static final long serialVersionUID = 7536809905120941525L;
    private List<Measurement> m_measurements = new ArrayList<Measurement>();

    public void addMeasurement(Measurement measurement) {
        this.m_measurements.add(measurement);
    }

    @Override
    public String getJson() {
        StringBuilder buf = new StringBuilder("[");
        boolean first = true;
        for (Measurement m : this.getMeasurements()) {
            if (!first) {
                buf.append(",");
            } else {
                first = false;
            }
            buf.append("{");
            buf.append("\"metricId\"").append(":\"").append(m.getMetricId()).append("\"").append(",");
            buf.append("\"metricType\"").append(":\"").append(m.getMetricType()).append("\"").append(",");
            buf.append("\"netInterface\"").append(":\"").append(m.getNetInterface()).append("\"").append(",");
            buf.append("\"nodeId\"").append(":").append(m.getNodeId()).append(",");
            buf.append("\"service\"").append(":\"").append(m.getService()).append("\"").append(",");
            buf.append("\"timeStamp\"").append(":").append(m.getTimestamp().getTime()).append(",");
            buf.append("\"onmsLogicMetricId\"").append(":\"").append(m.getOnmsLogicMetricId()).append("\",");
            buf.append("\"value\"").append(":").append(m.getValue());
            buf.append("}");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public List<Measurement> getMeasurements() {
        return this.m_measurements;
    }

    public String toString() {
        return this.getJson();
    }
}

