/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opennms.netmgt.notifd.AbstractSlackCompatibleNotificationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MattermostNotificationStrategy
extends AbstractSlackCompatibleNotificationStrategy {
    protected static final Logger LOG = LoggerFactory.getLogger(MattermostNotificationStrategy.class);
    private static final String MM_URL_PROPERTY = "org.opennms.netmgt.notifd.mattermost.webhookURL";
    private static final String MM_USERNAME_PROPERTY = "org.opennms.netmgt.notifd.mattermost.username";
    private static final String MM_ICONURL_PROPERTY = "org.opennms.netmgt.notifd.mattermost.iconURL";
    private static final String MM_ICONEMOJI_PROPERTY = "org.opennms.netmgt.notifd.mattermost.iconEmoji";
    private static final String MM_CHANNEL_PROPERTY = "org.opennms.netmgt.notifd.mattermost.channel";

    @Override
    protected String formatWebhookErrorResponse(int statusCode, String contents) {
        StringBuilder bldr = new StringBuilder("Response code: ");
        bldr.append(statusCode);
        JSONObject errorJson = new JSONObject();
        JSONParser jp = new JSONParser();
        try {
            Object parsedError = jp.parse(contents);
            if (parsedError instanceof JSONObject) {
                LOG.debug("Got back some JSON. Parsing for dissection.");
                errorJson = (JSONObject)parsedError;
            }
        }
        catch (ParseException e) {
            LOG.warn("Got some non-JSON error.", (Throwable)e);
            bldr.append(" Contents:").append(contents);
            return bldr.toString();
        }
        bldr.append("; Message: ").append(errorJson.get((Object)"message"));
        bldr.append("; Detailed error: ").append(errorJson.get((Object)"detailed_error"));
        bldr.append("; Request ID: ").append(errorJson.get((Object)"request_id"));
        bldr.append("; Status code: ").append(errorJson.get((Object)"status_code"));
        bldr.append("; Is OAUTH?: ").append(errorJson.get((Object)"is_oauth"));
        return bldr.toString();
    }

    @Override
    protected String decorateMessageSubject(String subject) {
        if ("".equals(subject)) {
            return "";
        }
        StringBuilder bldr = new StringBuilder("**");
        bldr.append(subject).append("**").append("\n");
        return bldr.toString();
    }

    @Override
    protected String decorateMessageBody(String body) {
        return body;
    }

    @Override
    protected String getUrlPropertyName() {
        return MM_URL_PROPERTY;
    }

    @Override
    protected String getUsernamePropertyName() {
        return MM_USERNAME_PROPERTY;
    }

    @Override
    protected String getIconUrlPropertyName() {
        return MM_ICONURL_PROPERTY;
    }

    @Override
    protected String getIconEmojiPropertyName() {
        LOG.warn("Icon emoji may not work with all versions of Mattermost.");
        return MM_ICONEMOJI_PROPERTY;
    }

    @Override
    protected String getChannelPropertyName() {
        return MM_CHANNEL_PROPERTY;
    }
}

