/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.model.notifd.NotificationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSlackCompatibleNotificationStrategy
implements NotificationStrategy {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractSlackCompatibleNotificationStrategy.class);
    private List<Argument> m_arguments;

    protected abstract String getChannelPropertyName();

    protected abstract String getIconEmojiPropertyName();

    protected abstract String getIconUrlPropertyName();

    protected abstract String getUsernamePropertyName();

    protected abstract String getUrlPropertyName();

    protected abstract String decorateMessageBody(String var1);

    protected abstract String decorateMessageSubject(String var1);

    protected abstract String formatWebhookErrorResponse(int var1, String var2);

    public int send(List<Argument> arguments) {
        this.m_arguments = arguments;
        String url = this.getUrl();
        if (url == null) {
            LOG.error("send: url must not be null");
            return 1;
        }
        String iconUrl = this.getIconUrl();
        String iconEmoji = this.getIconEmoji();
        String channel = this.getChannel();
        String message = this.buildMessage(arguments);
        HttpClientWrapper clientWrapper = HttpClientWrapper.create().setConnectionTimeout(Integer.valueOf(3000)).setSocketTimeout(Integer.valueOf(3000)).useSystemProxySettings();
        HttpPost postMethod = new HttpPost(url);
        JSONObject jsonData = new JSONObject();
        jsonData.put((Object)"username", (Object)this.getUsername());
        if (iconUrl != null) {
            jsonData.put((Object)"icon_url", (Object)iconUrl);
        }
        if (iconEmoji != null) {
            jsonData.put((Object)"icon_emoji", (Object)iconEmoji);
        }
        if (channel != null) {
            jsonData.put((Object)"channel", (Object)channel);
        }
        jsonData.put((Object)"text", (Object)message);
        if (jsonData.containsKey((Object)"icon_url") && jsonData.containsKey((Object)"icon_emoji")) {
            LOG.warn("Both URL and emoji specified for icon. Sending both; behavior is undefined.");
        }
        LOG.debug("Prepared JSON POST data for webhook is: {}", (Object)jsonData.toJSONString());
        StringEntity entity = new StringEntity(jsonData.toJSONString(), ContentType.APPLICATION_JSON);
        postMethod.setEntity((HttpEntity)entity);
        postMethod.setHeader("Content-Type", "application/json");
        String contents = null;
        int statusCode = -1;
        try {
            CloseableHttpResponse response = clientWrapper.getClient().execute((HttpUriRequest)postMethod);
            statusCode = response.getStatusLine().getStatusCode();
            contents = EntityUtils.toString((HttpEntity)response.getEntity());
            LOG.debug("send: Contents is: {}", (Object)contents);
        }
        catch (IOException e) {
            LOG.error("send: I/O problem with webhook post/response", (Throwable)e);
            throw new RuntimeException("Problem with webhook post: " + e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Closeable)clientWrapper);
        }
        if ("ok".equals(contents)) {
            LOG.debug("Got 'ok' back from webhook, indicating success.");
            statusCode = 0;
        } else {
            LOG.info("Got a non-ok response from webhook, attempting to dissect response.");
            LOG.error("Webhook returned non-OK response to notification post: {}", (Object)this.formatWebhookErrorResponse(statusCode, contents));
            statusCode = 1;
        }
        return statusCode;
    }

    protected String getUrl() {
        String url = this.getValueFromSwitchOrProp("Webhook URL", "url", this.getUrlPropertyName());
        if (url == null) {
            LOG.error("No webhook URL specified as a notification command switch or via system property {}. Cannot continue.", (Object)this.getUrlPropertyName());
        }
        return url;
    }

    protected String getUsername() {
        String username = this.getValueFromSwitchOrProp("Bot username", "username", this.getUsernamePropertyName());
        if (username == null) {
            LOG.warn("No bot username specified as a notification command switch or via system property {}. Using default value opennms.", (Object)this.getUsernamePropertyName());
            return "opennms";
        }
        return username;
    }

    protected String getIconUrl() {
        String iconurl = this.getValueFromSwitchOrProp("Icon URL", "iconurl", this.getIconUrlPropertyName());
        if (iconurl == null) {
            LOG.info("No icon URL specified as a notification command switch or via system property {}. Not setting one.", (Object)this.getIconUrlPropertyName());
        }
        return iconurl;
    }

    protected String getIconEmoji() {
        String iconemoji = this.getValueFromSwitchOrProp("Icon Emoji", "iconemoji", this.getIconEmojiPropertyName());
        if (iconemoji == null) {
            LOG.info("No icon emoji specified as a notification command switch or via system property {}. Not setting one.", (Object)this.getIconEmojiPropertyName());
        }
        if (iconemoji != null && !iconemoji.startsWith(":") && !iconemoji.endsWith(":")) {
            LOG.warn("Specified icon emoji '{}' is not colon-enclosed. Did you mean to do this?", (Object)iconemoji);
        }
        return iconemoji;
    }

    protected String getChannel() {
        String channel = this.getValueFromSwitchOrProp("Channel name", "channel", this.getChannelPropertyName());
        if (channel == null) {
            LOG.info("No channel specified as a notification command switch or via system property {}. Not setting one.", (Object)this.getChannelPropertyName());
        }
        return channel;
    }

    protected String getValueFromSwitchOrProp(String what, String switchName, String propName) {
        LOG.debug("Trying to get {} from notification switch {}", (Object)what, (Object)switchName);
        String val = this.getSwitchValue(switchName);
        if (val != null) {
            LOG.info("Using {} value {} from notification switch {}", new Object[]{what, val, switchName});
            return val;
        }
        LOG.debug("Trying to get {} from system property {}", (Object)what, (Object)propName);
        val = System.getProperty(propName);
        if (val != null) {
            LOG.info("Using {} value {} from system property {}", new Object[]{what, val, propName});
            return val;
        }
        LOG.warn("Could not determine value for {} from notification command switch {} or system property {}", new Object[]{what, switchName, propName});
        return null;
    }

    private String getSwitchValue(String argSwitch) {
        String value = null;
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().equals(argSwitch)) continue;
            if (!"".equals(arg.getValue())) {
                value = arg.getValue();
                continue;
            }
            if ("".equals(arg.getSubstitution())) continue;
            value = arg.getSubstitution();
        }
        if (value != null && value.equals("")) {
            value = null;
        }
        return value;
    }

    protected String buildMessage(List<Argument> args) {
        String subject = null;
        String body = null;
        for (Argument arg : args) {
            if ("-subject".equals(arg.getSwitch())) {
                subject = arg.getValue();
                continue;
            }
            if (!"-tm".equals(arg.getSwitch())) continue;
            body = arg.getValue();
        }
        StringBuilder bldr = new StringBuilder();
        if ("".equals(subject) || "RESOLVED: ".equals(subject)) {
            subject = null;
        } else {
            bldr.append(this.decorateMessageSubject(subject));
        }
        if ("".equals(body) || "RESOLVED: ".equals(body)) {
            body = null;
        } else {
            bldr.append(this.decorateMessageBody(body));
        }
        return bldr.toString();
    }
}

