/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.lang.management.ManagementFactory;
import java.util.List;
import org.opennms.core.soa.support.DefaultServiceRegistry;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.model.notifd.NotificationStrategy;
import org.opennms.netmgt.notifd.ExecutorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistryExecutor
implements ExecutorStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceRegistryExecutor.class);
    private static final DefaultServiceRegistry s_registry = DefaultServiceRegistry.INSTANCE;
    private static final String GRACE_PERIOD_MS_SYS_PROP = "org.opennms.netmgt.notifd.notificationStrategyGracePeriodMs";
    private static final int GRACE_PERIOD_MS = Integer.getInteger("org.opennms.netmgt.notifd.notificationStrategyGracePeriodMs", 180000);
    private static final int LOOKUP_DELAY_MS = 5000;

    @Override
    public int execute(String filter, List<Argument> arguments) {
        LOG.debug("Searching for notification strategy matching filter: {}", (Object)filter);
        NotificationStrategy ns = this.getNotificationStrategy(filter);
        if (ns == null) {
            LOG.error("No notification strategy found matching filter: {}", (Object)filter);
            return 1;
        }
        LOG.debug("Found notification strategy: {}", (Object)ns);
        return ns.send(arguments);
    }

    private NotificationStrategy getNotificationStrategy(String filter) {
        NotificationStrategy ns = (NotificationStrategy)s_registry.findProvider(NotificationStrategy.class, filter);
        if (ns != null) {
            return ns;
        }
        while (ManagementFactory.getRuntimeMXBean().getUptime() < (long)GRACE_PERIOD_MS) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while waiting for notification strategy to become available in the service registry. Aborting.");
                return null;
            }
            ns = (NotificationStrategy)s_registry.findProvider(NotificationStrategy.class, filter);
            if (ns == null) continue;
            return ns;
        }
        return null;
    }
}

