/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.config.NotificationManager;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.notificationCommands.Argument;
import org.opennms.netmgt.config.notificationCommands.Command;
import org.opennms.netmgt.config.users.User;
import org.opennms.netmgt.notifd.ClassExecutor;
import org.opennms.netmgt.notifd.CommandExecutor;
import org.opennms.netmgt.notifd.ExecutorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationTask
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationTask.class);
    private volatile User m_user;
    private volatile String m_autoNotify;
    private volatile int m_notifyId;
    private volatile Command[] m_commands;
    private final Map<String, String> m_params;
    private final long m_sendTime;
    private volatile boolean m_started = false;
    private final NotificationManager m_notificationManager;
    private final UserManager m_userManager;

    public NotificationTask(NotificationManager notificationManager, UserManager userManager, long sendTime, Map<String, String> someParams, List<NotificationTask> siblings, String autoNotify) {
        this.m_notificationManager = notificationManager;
        this.m_userManager = userManager;
        this.m_sendTime = sendTime;
        this.m_params = new HashMap<String, String>(someParams);
        this.m_autoNotify = autoNotify;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer("Send ");
        if (this.m_commands == null) {
            buffer.append("Null Commands");
        } else {
            for (Command command : this.m_commands) {
                buffer.append(command == null ? "null" : command.getName());
                buffer.append("/");
                buffer.append("[#" + this.m_notifyId + "]");
            }
        }
        buffer.append(" to " + this.m_user.getUserId() + " at " + new Date(this.m_sendTime));
        return buffer.toString();
    }

    public long getSendTime() {
        return this.m_sendTime;
    }

    public int getNotifyId() {
        return this.m_notifyId;
    }

    public void setUser(User aUser) {
        this.m_user = aUser;
    }

    public User getUser() {
        return this.m_user;
    }

    public void setAutoNotify(String autoNotify) {
        this.m_autoNotify = autoNotify;
    }

    public void setNoticeId(int anId) {
        this.m_notifyId = anId;
    }

    public void setCommands(Command[] commands) {
        this.m_commands = Arrays.copyOf(commands, commands.length);
    }

    public Command[] getCommands() {
        return (Command[])this.m_commands.clone();
    }

    @Override
    public void run() {
        block13: {
            boolean outstanding = false;
            try {
                outstanding = this.getNotificationManager().noticeOutstanding(this.m_notifyId);
            }
            catch (Throwable e) {
                LOG.error("Unable to get response status on notice #{}", (Object)this.m_notifyId, (Object)e);
            }
            if (outstanding) {
                try {
                    if (this.getUserManager().isUserOnDuty(this.m_user.getUserId(), Calendar.getInstance())) {
                        ExecutorStrategy strategy = null;
                        String cntct = "";
                        for (Command command : this.m_commands) {
                            try {
                                cntct = this.getContactInfo(command.getName());
                                try {
                                    this.getNotificationManager().updateNoticeWithUserInfo(this.m_user.getUserId(), this.m_notifyId, command.getName(), cntct, this.m_autoNotify);
                                }
                                catch (Throwable e) {
                                    LOG.error("Could not insert notice info into database, aborting send notice", e);
                                    continue;
                                }
                                Boolean binaryCommand = command.getBinary();
                                strategy = binaryCommand != false ? new CommandExecutor() : new ClassExecutor();
                                LOG.debug("Class created is: {}", command.getClass());
                                this.getNotificationManager().incrementAttempted(strategy instanceof CommandExecutor);
                                int returnCode = strategy.execute(command.getExecute(), this.getArgumentList(command));
                                LOG.debug("command {} return code = {}", (Object)command.getName(), (Object)returnCode);
                                if (returnCode == 0) {
                                    this.getNotificationManager().incrementSucceeded(strategy instanceof CommandExecutor);
                                    continue;
                                }
                                this.getNotificationManager().incrementFailed(strategy instanceof CommandExecutor);
                            }
                            catch (Throwable e) {
                                LOG.warn("Notification command failed: {}", (Object)command.getName(), (Object)e);
                                if (strategy == null) {
                                    this.getNotificationManager().incrementUnknownInterrupted();
                                    continue;
                                }
                                this.getNotificationManager().incrementInterrupted(strategy instanceof CommandExecutor);
                            }
                        }
                        break block13;
                    }
                    LOG.debug("User {} is not on duty, skipping", (Object)this.m_user.getUserId());
                }
                catch (IOException e) {
                    LOG.warn("Could not get user duty schedule information: ", (Throwable)e);
                }
            }
        }
    }

    private NotificationManager getNotificationManager() {
        return this.m_notificationManager;
    }

    private UserManager getUserManager() {
        return this.m_userManager;
    }

    private String getContactInfo(String cmdName) throws IOException {
        return this.getUserManager().getContactInfo(this.m_user, cmdName);
    }

    private List<org.opennms.netmgt.model.notifd.Argument> getArgumentList(Command command) {
        List<Argument> notifArgs = this.getArgumentsForCommand(command);
        ArrayList<org.opennms.netmgt.model.notifd.Argument> commandArgs = new ArrayList<org.opennms.netmgt.model.notifd.Argument>();
        for (Argument curArg : notifArgs) {
            LOG.debug("argument: {} {} '{}' {}", new Object[]{curArg.getSwitch().orElse(null), curArg.getSubstitution().orElse(null), this.getArgumentValue(curArg.getSwitch().orElse(null)), curArg.getStreamed()});
            commandArgs.add(new org.opennms.netmgt.model.notifd.Argument((String)curArg.getSwitch().orElse(null), (String)curArg.getSubstitution().orElse(null), this.getArgumentValue(curArg.getSwitch().orElse(null)), curArg.getStreamed().booleanValue()));
        }
        return commandArgs;
    }

    private List<Argument> getArgumentsForCommand(Command command) {
        return command.getArguments();
    }

    private String getArgumentValue(String aSwitch) {
        String value = "";
        try {
            if ("-d".equals(aSwitch)) {
                value = this.m_user.getUserId();
            } else if ("-email".equals(aSwitch)) {
                value = this.getEmail();
            } else if ("-tuipin".equals(aSwitch)) {
                value = this.getTuiPin();
            } else if ("-pemail".equals(aSwitch)) {
                value = this.getUserManager().getPagerEmail(this.m_user.getUserId());
            } else if ("-xmpp".equals(aSwitch)) {
                value = this.getUserManager().getXMPPAddress(this.m_user.getUserId());
            } else if ("-tp".equals(aSwitch)) {
                value = this.getUserManager().getTextPin(this.m_user.getUserId());
            } else if ("-np".equals(aSwitch)) {
                value = this.getUserManager().getNumericPin(this.m_user.getUserId());
            } else if ("-wphone".equals(aSwitch)) {
                value = this.getUserManager().getWorkPhone(this.m_user.getUserId());
            } else if ("-mphone".equals(aSwitch)) {
                value = this.getUserManager().getMobilePhone(this.m_user.getUserId());
            } else if ("-hphone".equals(aSwitch)) {
                value = this.getUserManager().getHomePhone(this.m_user.getUserId());
            } else if ("-ublog".equals(aSwitch)) {
                value = this.getUserManager().getMicroblogName(this.m_user.getUserId());
            } else if (this.m_params.containsKey(aSwitch)) {
                value = this.m_params.get(aSwitch);
            }
        }
        catch (Throwable e) {
            LOG.error("unable to get value for parameter {}", (Object)aSwitch);
        }
        return value;
    }

    public String getEmail() throws IOException {
        return this.getContactInfo("email");
    }

    public String getTuiPin() throws IOException {
        return this.getContactInfo("tuiPin");
    }

    @Override
    public synchronized void start() {
        this.m_started = true;
        super.start();
    }

    public boolean isStarted() {
        return this.m_started;
    }
}

