/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.ConfigFileConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMPPNotificationManager {
    private static final Logger LOG = LoggerFactory.getLogger(XMPPNotificationManager.class);
    private final Properties props = new Properties();
    private static final String LOG4J_CATEGORY = "notifd";
    private static final String XMPP_RESOURCE = "notifd";
    private static final String XMPP_PORT = "5222";
    private final XMPPTCPConnection xmpp;
    private final String xmppServer;
    private final String xmppUser;
    private final String xmppPassword;
    private final int xmppPort;
    private final Map<String, MultiUserChat> rooms = new HashMap<String, MultiUserChat>();
    private static XMPPNotificationManager instance = null;
    private ConnectionListener conlistener = new ConnectionListener(){

        public void connectionClosed() {
            LOG.debug("XMPP connection closed");
        }

        public void connectionClosedOnError(Exception e) {
            LOG.warn("XMPP connection closed", (Throwable)e);
        }

        public void reconnectingIn(int seconds) {
            LOG.debug("XMPP reconnecting in {} seconds", (Object)seconds);
        }

        public void reconnectionFailed(Exception e) {
            LOG.warn("XMPP reconnection failed", (Throwable)e);
            try {
                XMPPNotificationManager.this.xmpp.disconnect();
            }
            catch (SmackException.NotConnectedException ex) {
                LOG.error("XMPP disconnect failed", (Throwable)ex);
            }
            instance = null;
        }

        public void reconnectionSuccessful() {
            LOG.debug("XMPP reconnection succeeded");
        }

        public void authenticated(XMPPConnection conn) {
            LOG.debug("XMPP authenticated");
        }

        public void connected(XMPPConnection conn) {
            LOG.debug("XMPP connected");
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected XMPPNotificationManager() {
        Map mdc = Logging.getCopyOfContextMap();
        try {
            block22: {
                FileInputStream fis;
                if (mdc != null) {
                    mdc.put("prefix", "notifd");
                }
                File config = null;
                try {
                    config = ConfigFileConstants.getFile((int)ConfigFileConstants.XMPP_CONFIG_FILE_NAME);
                }
                catch (IOException e) {
                    LOG.warn("{} not readable", (Object)ConfigFileConstants.XMPP_CONFIG_FILE_NAME, (Object)e);
                }
                if (Boolean.getBoolean("useSystemXMPPConfig") || !config.canRead()) {
                    this.props.putAll((Map<?, ?>)System.getProperties());
                } else {
                    fis = null;
                    fis = new FileInputStream(config);
                    this.props.load(fis);
                    IOUtils.closeQuietly((InputStream)fis);
                }
                break block22;
                catch (FileNotFoundException e) {
                    LOG.warn("unable to load {}", (Object)config, (Object)e);
                    IOUtils.closeQuietly((InputStream)fis);
                }
                catch (IOException e2) {
                    LOG.warn("unable to load {}", (Object)config, (Object)e2);
                    {
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(fis);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)fis);
                }
            }
            this.xmppServer = this.props.getProperty("xmpp.server");
            String xmppServiceName = this.props.getProperty("xmpp.servicename", this.xmppServer);
            this.xmppUser = this.props.getProperty("xmpp.user");
            this.xmppPassword = this.props.getProperty("xmpp.pass");
            this.xmppPort = Integer.valueOf(this.props.getProperty("xmpp.port", XMPP_PORT));
            ConnectionConfiguration xmppConfig = new ConnectionConfiguration(this.xmppServer, this.xmppPort, xmppServiceName);
            boolean debuggerEnabled = Boolean.parseBoolean(this.props.getProperty("xmpp.debuggerEnabled"));
            xmppConfig.setDebuggerEnabled(debuggerEnabled);
            if (Boolean.parseBoolean(this.props.getProperty("xmpp.TLSEnabled"))) {
                xmppConfig.setSecurityMode(ConnectionConfiguration.SecurityMode.enabled);
            } else {
                xmppConfig.setSecurityMode(ConnectionConfiguration.SecurityMode.disabled);
            }
            if (Boolean.parseBoolean(this.props.getProperty("xmpp.selfSignedCertificateEnabled"))) {
                try {
                    SSLContext ctx = SSLContext.getInstance("TLS");
                    ctx.init(null, new TrustManager[]{new LocalSSLTrustManager()}, null);
                    xmppConfig.setCustomSSLContext(ctx);
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    LOG.error("Failed to create a custom SSL context", (Throwable)e);
                }
            }
            if (!Boolean.parseBoolean(this.props.getProperty("xmpp.SASLEnabled", "true"))) {
                LOG.info("Removing all SALS mechanisms from Smack.");
                SmackConfiguration.removeSaslMechs((Collection)SmackConfiguration.getSaslMechs());
            }
            LOG.debug("XMPP Manager connection config: {}", (Object)xmppConfig);
            this.xmpp = new XMPPTCPConnection(xmppConfig);
            this.connectToServer();
        }
        finally {
            if (mdc != null) {
                Logging.setContextMap((Map)mdc);
            }
        }
    }

    private void connectToServer() {
        try {
            LOG.debug("Attempting vanilla XMPP Connection to {}:{}", (Object)this.xmppServer, (Object)this.xmppPort);
            this.xmpp.connect();
            if (this.xmpp.isConnected()) {
                LOG.debug("XMPP Manager successfully connected");
                if (this.xmpp.isSecureConnection()) {
                    LOG.debug("XMPP Manager successfully negotiated a secure connection");
                }
                if (this.xmpp.isUsingTLS()) {
                    LOG.debug("XMPP Manager successfully negotiated a TLS connection");
                }
                LOG.debug("XMPP Manager Connected");
                this.login();
                this.xmpp.addConnectionListener(this.conlistener);
            } else {
                LOG.debug("XMPP Manager Not Connected");
            }
        }
        catch (Throwable e) {
            LOG.error("XMPP Manager unable to connect", e);
        }
    }

    private void login() {
        try {
            if (this.xmpp.isConnected()) {
                LOG.debug("XMPP Manager logging in");
                this.xmpp.login(this.xmppUser, this.xmppPassword, "notifd");
                this.rooms.clear();
            } else {
                LOG.debug("XMPP Manager unable to login: Not connected to XMPP server");
            }
        }
        catch (Throwable e) {
            LOG.error("XMPP Manager unable to login: ", e);
        }
    }

    public static synchronized XMPPNotificationManager getInstance() {
        if (instance == null) {
            instance = new XMPPNotificationManager();
        }
        return instance;
    }

    public boolean isLoggedIn() {
        return this.xmpp.isAuthenticated();
    }

    public boolean sendMessage(String xmppTo, String xmppMessage) {
        if (!this.isLoggedIn()) {
            this.connectToServer();
        }
        try {
            ChatManager cm = ChatManager.getInstanceFor((XMPPConnection)this.xmpp);
            cm.createChat(xmppTo, (MessageListener)new NullMessageListener()).sendMessage(xmppMessage);
            LOG.debug("XMPP Manager sent message to: {}", (Object)xmppTo);
        }
        catch (SmackException.NotConnectedException | XMPPException e) {
            LOG.error("XMPP Exception Sending message ", e);
            return false;
        }
        return true;
    }

    public boolean sendGroupChat(String xmppChatRoom, String xmppMessage) {
        MultiUserChat groupChat;
        if (this.rooms.containsKey(xmppChatRoom)) {
            groupChat = this.rooms.get(xmppChatRoom);
        } else {
            LOG.debug("Adding room: {}", (Object)xmppChatRoom);
            groupChat = new MultiUserChat((XMPPConnection)this.xmpp, xmppChatRoom);
            this.rooms.put(xmppChatRoom, groupChat);
        }
        if (!groupChat.isJoined()) {
            LOG.debug("Joining room: {}", (Object)xmppChatRoom);
            try {
                groupChat.join(this.xmppUser);
            }
            catch (SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException e) {
                LOG.error("XMPP Exception joining chat room ", e);
                return false;
            }
        }
        try {
            groupChat.sendMessage(xmppMessage);
            LOG.debug("XMPP Manager sent message to: {}", (Object)xmppChatRoom);
        }
        catch (SmackException.NotConnectedException | XMPPException e) {
            LOG.error("XMPP Exception sending message to Chat room", e);
            return false;
        }
        return true;
    }

    private static class LocalSSLTrustManager
    implements X509TrustManager {
        private LocalSSLTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class NullMessageListener
    implements MessageListener {
        private NullMessageListener() {
        }

        public void processMessage(Chat chat, Message message) {
        }
    }
}

