/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.RowProcessor;
import org.opennms.core.utils.TimeConverter;
import org.opennms.netmgt.config.DestinationPathManager;
import org.opennms.netmgt.config.GroupManager;
import org.opennms.netmgt.config.NotifdConfigManager;
import org.opennms.netmgt.config.NotificationCommandManager;
import org.opennms.netmgt.config.NotificationManager;
import org.opennms.netmgt.config.PollOutagesConfigManager;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.config.destinationPaths.Escalate;
import org.opennms.netmgt.config.destinationPaths.Path;
import org.opennms.netmgt.config.destinationPaths.Target;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.config.notifd.AutoAcknowledge;
import org.opennms.netmgt.config.notifd.AutoAcknowledgeAlarm;
import org.opennms.netmgt.config.notificationCommands.Command;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.config.users.Contact;
import org.opennms.netmgt.config.users.User;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.notifd.NoticeQueue;
import org.opennms.netmgt.notifd.NotificationTask;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.eventconf.Decode;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Varbindsdecode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class BroadcastEventProcessor
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(BroadcastEventProcessor.class);
    private volatile Map<String, NoticeQueue> m_noticeQueues;
    private volatile PollOutagesConfigManager m_pollOutagesConfigManager;
    private volatile NotificationManager m_notificationManager;
    private volatile NotifdConfigManager m_notifdConfigManager;
    private volatile DestinationPathManager m_destinationPathManager;
    private volatile UserManager m_userManager;
    private volatile GroupManager m_groupManager;
    private volatile NotificationCommandManager m_notificationCommandManager;
    private volatile EventConfDao m_eventConfDao;
    @Autowired
    private volatile EventIpcManager m_eventManager;
    @Autowired
    private volatile EventUtil m_eventUtil;

    protected void init() {
        this.assertPropertiesSet();
        this.getEventManager().addEventListener((EventListener)this);
    }

    private void assertPropertiesSet() {
        if (this.m_noticeQueues == null) {
            throw new IllegalStateException("property noticeQueues not set");
        }
        if (this.m_eventManager == null) {
            throw new IllegalStateException("property eventManager not set");
        }
        if (this.m_pollOutagesConfigManager == null) {
            throw new IllegalStateException("property pollOutagesConfigManager not set");
        }
        if (this.m_notificationManager == null) {
            throw new IllegalStateException("property notificationManager not set");
        }
        if (this.m_notifdConfigManager == null) {
            throw new IllegalStateException("property notifdConfigManager not set");
        }
        if (this.m_destinationPathManager == null) {
            throw new IllegalStateException("property destinationPathManager not set");
        }
        if (this.m_userManager == null) {
            throw new IllegalStateException("property userManager not set");
        }
        if (this.m_groupManager == null) {
            throw new IllegalStateException("property groupManager not set");
        }
        if (this.m_notificationCommandManager == null) {
            throw new IllegalStateException("property notificationCommandManager not set");
        }
        if (this.m_eventUtil == null) {
            throw new IllegalStateException("property eventUtil not set");
        }
    }

    public void close() {
        this.getEventManager().removeEventListener((EventListener)this);
    }

    public void onEvent(org.opennms.netmgt.xml.event.Event event) {
        if (event == null) {
            return;
        }
        if (this.isReloadConfigEvent(event)) {
            LOG.info("onEvent: handling reload configuration event...");
            EventBuilder ebldr = null;
            try {
                this.m_userManager.update();
                this.m_groupManager.update();
                this.m_notificationManager.update();
                this.m_destinationPathManager.update();
                this.m_notificationCommandManager.update();
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", this.getName());
                ebldr.addParam("daemonName", "Notifd");
            }
            catch (Throwable e) {
                LOG.debug("onEvent: could not reload notifd configuration", e);
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
                ebldr.addParam("daemonName", "Notifd");
                ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
            }
            this.m_eventManager.sendNow(ebldr.getEvent());
            LOG.info("onEvent: reload configuration event handled.");
            return;
        }
        if (event.getLogmsg() != null && event.getLogmsg().getDest().equalsIgnoreCase("donotpersist")) {
            LOG.debug("discarding event {}, the event has been configured as 'doNotPersist'.", (Object)event.getUei());
            return;
        }
        if (event.getAlarmData() != null && event.getAlarmData().isAutoClean().booleanValue()) {
            LOG.debug("discarding event {}, the event has been configured with autoClean=true on its alarmData.", (Object)event.getUei());
            return;
        }
        boolean notifsOn = this.computeNullSafeStatus();
        if (notifsOn && this.checkCriticalPath(event, notifsOn)) {
            this.scheduleNoticesForEvent(event);
        } else if (!notifsOn) {
            LOG.debug("discarding event {}, notifd status on = {}", (Object)event.getUei(), (Object)notifsOn);
        }
        this.automaticAcknowledge(event, notifsOn);
    }

    private boolean isReloadConfigEvent(org.opennms.netmgt.xml.event.Event event) {
        boolean isTarget = false;
        if ("uei.opennms.org/internal/reloadDaemonConfig".equals(event.getUei())) {
            List parmCollection = event.getParmCollection();
            for (Parm parm : parmCollection) {
                if (!"daemonName".equals(parm.getParmName()) || !"Notifd".equalsIgnoreCase(parm.getValue().getContent())) continue;
                isTarget = true;
                break;
            }
            LOG.debug("isReloadConfigEventTarget: Notifd was target of reload event: {}", (Object)isTarget);
        }
        return isTarget;
    }

    public boolean computeNullSafeStatus() {
        String notificationStatus = null;
        try {
            notificationStatus = this.getNotifdConfigManager().getNotificationStatus();
        }
        catch (MarshalException e) {
            LOG.error("onEvent: problem marshalling configuration", (Throwable)e);
        }
        catch (ValidationException e) {
            LOG.error("onEvent: problem validating marsharled configuraion", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("onEvent: IO problem marshalling configuration", (Throwable)e);
        }
        return "on".equalsIgnoreCase(notificationStatus);
    }

    private boolean checkCriticalPath(org.opennms.netmgt.xml.event.Event event, boolean notifsOn) {
        boolean isPathOk = true;
        Long nodeid = event.getNodeid();
        try {
            String reason;
            if (event.getUei().equals("uei.opennms.org/nodes/nodeDown") && (reason = EventUtils.getParm((org.opennms.netmgt.xml.event.Event)event, (String)"eventReason")) != null && reason.equals("pathOutage")) {
                isPathOk = false;
                String cip = EventUtils.getParm((org.opennms.netmgt.xml.event.Event)event, (String)"criticalPathIp");
                String csvc = EventUtils.getParm((org.opennms.netmgt.xml.event.Event)event, (String)"criticalPathServiceName");
                LOG.debug("Critical Path {} {} for nodeId {} did not respond. Checking to see if notice would have been sent...", new Object[]{cip, csvc, nodeid});
                boolean mapsToNotice = false;
                boolean noticeSupressed = false;
                Notification[] notifications = null;
                mapsToNotice = this.getNotificationManager().hasUei(event.getUei());
                notifications = this.getNotificationManager().getNotifForEvent(event);
                if (notifsOn && mapsToNotice && this.continueWithNotice(event) && notifications != null) {
                    noticeSupressed = true;
                }
                this.createPathOutageEvent(nodeid.intValue(), EventUtils.getParm((org.opennms.netmgt.xml.event.Event)event, (String)"nodelabel"), cip, csvc, noticeSupressed);
            }
        }
        catch (MarshalException e) {
            LOG.error("onEvent: problem marshalling configuration", (Throwable)e);
        }
        catch (ValidationException e) {
            LOG.error("onEvent: problem validating marshalled configuration", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("onEvent: IO problem marshalling configuration", (Throwable)e);
        }
        return isPathOk;
    }

    private void automaticAcknowledge(org.opennms.netmgt.xml.event.Event event, boolean notifsOn) {
        try {
            Collection autoAcks = this.getNotifdConfigManager().getAutoAcknowledges();
            boolean processed = false;
            for (AutoAcknowledge curAck : autoAcks) {
                if (!curAck.getUei().equals(event.getUei())) continue;
                try {
                    LOG.debug("Acknowledging event {} {}:{}:{}", new Object[]{curAck.getAcknowledge(), event.getNodeid(), event.getInterface(), event.getService()});
                    Collection notifIDs = this.getNotificationManager().acknowledgeNotice(event, curAck.getAcknowledge(), curAck.getMatch());
                    processed = true;
                    try {
                        if (!curAck.getNotify() || !notifsOn) continue;
                        this.sendResolvedNotifications(notifIDs, event, curAck.getResolutionPrefix(), this.getNotifdConfigManager().getConfiguration().isNumericSkipResolutionPrefix());
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to send resolution notifications.", e);
                    }
                }
                catch (SQLException e) {
                    LOG.error("Failed to auto acknowledge notice.", (Throwable)e);
                }
            }
            if (processed) {
                return;
            }
            AutoAcknowledgeAlarm autoAck = this.getNotifdConfigManager().getConfiguration().getAutoAcknowledgeAlarm();
            if (autoAck == null) {
                return;
            }
            if (!autoAck.getUeiCollection().isEmpty() && !autoAck.getUeiCollection().contains(event.getUei())) {
                return;
            }
            Collection notifIDs = this.getNotificationManager().acknowledgeNoticeBasedOnAlarms(event);
            try {
                if (autoAck.getNotify() && !notifIDs.isEmpty() && notifsOn) {
                    this.sendResolvedNotifications(notifIDs, event, autoAck.getResolutionPrefix(), this.getNotifdConfigManager().getConfiguration().isNumericSkipResolutionPrefix());
                }
            }
            catch (Throwable e) {
                LOG.error("Failed to send resolution notifications.", e);
            }
        }
        catch (Throwable e) {
            LOG.error("Unable to auto acknowledge notice due to exception.", e);
        }
    }

    private void sendResolvedNotifications(Collection<Integer> notifIDs, org.opennms.netmgt.xml.event.Event event, String resolutionPrefix, boolean skipNumericPrefix) throws Exception {
        for (int notifId : notifIDs) {
            boolean wa = false;
            if (notifId < 0) {
                wa = true;
                LOG.debug("Conditional autoNotify for notifId {}", (Object)(notifId *= -1));
            }
            final boolean wasAcked = wa;
            Map<String, String> parmMap = this.rebuildParameterMap(notifId, resolutionPrefix, skipNumericPrefix);
            this.m_eventUtil.expandMapValues(parmMap, this.getNotificationManager().getEvent(Integer.parseInt(parmMap.get("eventID"))));
            String queueID = this.getNotificationManager().getQueueForNotification(notifId);
            final HashMap userNotifications = new HashMap();
            RowProcessor ackNotifProcessor = new RowProcessor(){

                public void processRow(ResultSet rs) throws SQLException {
                    String userID = rs.getString("userID");
                    String contactInfo = rs.getString("contactinfo");
                    String autoNotifyChar = rs.getString("autonotify");
                    if (userID.equals("email-address")) {
                        userID = contactInfo;
                    }
                    String cmd = rs.getString("media");
                    if (autoNotifyChar == null) {
                        autoNotifyChar = "C";
                    }
                    if (autoNotifyChar.equals("Y") || autoNotifyChar.equals("C") && !wasAcked) {
                        ArrayList<String> cmdList = (ArrayList<String>)userNotifications.get(userID);
                        if (cmdList == null) {
                            cmdList = new ArrayList<String>();
                            userNotifications.put(userID, cmdList);
                        }
                        cmdList.add(cmd);
                    }
                }
            };
            this.getNotificationManager().forEachUserNotification(notifId, ackNotifProcessor);
            for (Map.Entry entry : userNotifications.entrySet()) {
                String userID = (String)entry.getKey();
                List cmdList = (List)entry.getValue();
                String[] cmds = cmdList.toArray(new String[cmdList.size()]);
                LOG.debug("Sending {} notification to userID = {} for notice ID {}", new Object[]{resolutionPrefix, userID, notifId});
                this.sendResolvedNotificationsToUser(queueID, userID, cmds, parmMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResolvedNotificationsToUser(String queueID, String targetName, String[] commands, Map<String, String> params) throws Exception {
        int noticeId = -1;
        NoticeQueue noticeQueue = null;
        if (this.m_noticeQueues != null) {
            Map<String, NoticeQueue> map = this.m_noticeQueues;
            synchronized (map) {
                noticeQueue = this.m_noticeQueues.get(queueID);
            }
        }
        long now = System.currentTimeMillis();
        if (this.getUserManager().hasUser(targetName)) {
            NotificationTask newTask = this.makeUserTask(now, params, noticeId, targetName, commands, null, null);
            if (newTask != null) {
                noticeQueue.putItem(now, newTask);
            }
        } else if (targetName.indexOf(64) > -1) {
            NotificationTask newTask = this.makeEmailTask(now, params, noticeId, targetName, commands, null, null);
            if (newTask != null) {
                NoticeQueue noticeQueue2 = noticeQueue;
                synchronized (noticeQueue2) {
                    noticeQueue.putItem(now, newTask);
                }
            }
        } else {
            LOG.warn("Unrecognized target '{}' contained in destinationPaths.xml. Please check the configuration.", (Object)targetName);
        }
    }

    private boolean continueWithNotice(org.opennms.netmgt.xml.event.Event event) {
        String nodeID = event.hasNodeid() ? String.valueOf(event.getNodeid()) : null;
        String ipAddr = event.getInterface();
        String service = event.getService();
        boolean continueNotice = false;
        if (nodeID == null || ipAddr == null || service == null || ipAddr.equals("0.0.0.0")) {
            LOG.debug("nodeID={} ipAddr={} service={}. Not checking DB, continuing...", new Object[]{nodeID, ipAddr, service});
            return true;
        }
        try {
            String notify = this.getNotificationManager().getServiceNoticeStatus(nodeID, ipAddr, service);
            if ("Y".equals(notify)) {
                continueNotice = true;
                LOG.debug("notify status for service {} on interface/node {}/{} is 'Y', continuing...", new Object[]{service, ipAddr, nodeID});
            } else {
                LOG.debug("notify status for service {} on interface/node {}/{} is {}, not continuing...", new Object[]{service, ipAddr, nodeID, notify});
            }
        }
        catch (Throwable e) {
            continueNotice = true;
            LOG.error("Not able to get notify status for service {} on interface/node {}/{}. Continuing notice... {}", new Object[]{service, ipAddr, nodeID, e.getMessage()});
        }
        return continueNotice;
    }

    private boolean autoAckExistsForEvent(String eventUei) {
        try {
            Collection autoAcks = this.getNotifdConfigManager().getAutoAcknowledges();
            for (AutoAcknowledge curAck : autoAcks) {
                if (!curAck.getAcknowledge().equals(eventUei)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            LOG.error("Unable to find if an auto acknowledge exists for event {} due to exception.", (Object)eventUei, (Object)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNoticesForEvent(org.opennms.netmgt.xml.event.Event event) {
        boolean mapsToNotice = false;
        try {
            mapsToNotice = this.getNotificationManager().hasUei(event.getUei());
        }
        catch (Throwable e) {
            LOG.error("Couldn't map uei {} to a notification entry, not scheduling notice.", (Object)event.getUei(), (Object)e);
            return;
        }
        if (mapsToNotice) {
            if (this.continueWithNotice(event)) {
                Notification[] notifications = null;
                try {
                    notifications = this.getNotificationManager().getNotifForEvent(event);
                }
                catch (Throwable e) {
                    LOG.error("Couldn't get notification mapping for event {}, not scheduling notice.", (Object)event.getUei(), (Object)e);
                    return;
                }
                long nodeid = event.getNodeid();
                String ipaddr = event.getInterface();
                if (notifications != null) {
                    for (Notification notification : notifications) {
                        String queueID;
                        int noticeId = 0;
                        try {
                            noticeId = this.getNotificationManager().getNoticeId();
                        }
                        catch (Throwable e) {
                            LOG.error("Failed to get a unique id # for notification, exiting this notification", e);
                            continue;
                        }
                        Map<String, String> paramMap = this.buildParameterMap(notification, event, noticeId);
                        String string = queueID = notification.getNoticeQueue() != null ? notification.getNoticeQueue() : "default";
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("destination : {}", (Object)notification.getDestinationPath());
                            LOG.debug("text message: {}", (Object)paramMap.get("-tm"));
                            LOG.debug("num message : {}", (Object)paramMap.get("-nm"));
                            LOG.debug("subject     : {}", (Object)paramMap.get("-subject"));
                            LOG.debug("node        : {}", (Object)paramMap.get("-nodeid"));
                            LOG.debug("interface   : {}", (Object)paramMap.get("-interface"));
                            LOG.debug("service     : {}", (Object)paramMap.get("-service"));
                        }
                        Path path = null;
                        try {
                            path = this.getDestinationPathManager().getPath(notification.getDestinationPath());
                            if (path == null) {
                                LOG.warn("Unknown destination path {}. Please check the <destinationPath> tag for the notification {} in the notifications.xml file.", (Object)notification.getDestinationPath(), (Object)notification.getName());
                                continue;
                            }
                        }
                        catch (Throwable e) {
                            LOG.error("Could not get destination path for {}, please check the destinationPath.xml for errors.", (Object)notification.getDestinationPath(), (Object)e);
                            return;
                        }
                        String initialDelay = path.getInitialDelay() == null ? "0s" : path.getInitialDelay();
                        Target[] targets = path.getTarget();
                        Escalate[] escalations = path.getEscalate();
                        try {
                            if (this.getUserCount(targets, escalations) == 0) {
                                LOG.warn("The path {} assigned to notification {} has no targets or escalations specified, not sending notice.", (Object)notification.getDestinationPath(), (Object)notification.getName());
                                this.sendNotifEvent("uei.opennms.org/internal/notificationWithoutUsers", "The path " + notification.getDestinationPath() + " assigned to notification " + notification.getName() + " has no targets or escalations specified.", "The message of the notification is as follows: " + paramMap.get("-tm"));
                                return;
                            }
                        }
                        catch (Throwable e) {
                            LOG.error("Failed to get count of users in destination path {}, exiting notification.", (Object)notification.getDestinationPath(), (Object)e);
                            return;
                        }
                        try {
                            LOG.info("Inserting notification #{} into database: {}", (Object)noticeId, (Object)paramMap.get("-subject"));
                            this.getNotificationManager().insertNotice(noticeId, paramMap, queueID, notification);
                        }
                        catch (SQLException e) {
                            LOG.error("Failed to enter notification into database, exiting this notification", (Throwable)e);
                            return;
                        }
                        long startTime = System.currentTimeMillis() + TimeConverter.convertToMillis((String)initialDelay);
                        String scheduledOutageName = this.scheduledOutage(nodeid, ipaddr);
                        if (scheduledOutageName != null) {
                            if (!this.autoAckExistsForEvent(event.getUei())) continue;
                            Calendar endOfOutage = this.getPollOutagesConfigManager().getEndOfOutage(scheduledOutageName);
                            startTime = endOfOutage.getTime().getTime();
                        }
                        ArrayList<NotificationTask> targetSiblings = new ArrayList<NotificationTask>();
                        try {
                            Map<String, NoticeQueue> map = this.m_noticeQueues;
                            synchronized (map) {
                                NoticeQueue noticeQueue = this.m_noticeQueues.get(queueID);
                                this.processTargets(targets, targetSiblings, noticeQueue, startTime, paramMap, noticeId);
                                this.processEscalations(escalations, targetSiblings, noticeQueue, startTime, paramMap, noticeId);
                            }
                        }
                        catch (Throwable e) {
                            LOG.error("notice not scheduled due to error: ", e);
                        }
                    }
                } else {
                    LOG.debug("Event doesn't match a notice: {} : {} : {} : {}", new Object[]{event.getUei(), nodeid, ipaddr, event.getService()});
                }
            }
        } else {
            LOG.debug("No notice match for uei: {}", (Object)event.getUei());
        }
    }

    private int getUserCount(Target[] targets, Escalate[] escalations) throws IOException, MarshalException, ValidationException {
        int totalUsers = 0;
        for (int i = 0; i < targets.length; ++i) {
            totalUsers += this.getUsersInTarget(targets[i]);
        }
        for (int j = 0; j < escalations.length; ++j) {
            Target[] escalationTargets = escalations[j].getTarget();
            for (int k = 0; k < escalationTargets.length; ++k) {
                totalUsers += this.getUsersInTarget(escalationTargets[k]);
            }
        }
        return totalUsers;
    }

    private int getUsersInTarget(Target target) throws IOException, MarshalException, ValidationException {
        int count = 0;
        String targetName = target.getName();
        if (this.getGroupManager().hasGroup(targetName)) {
            count = this.getGroupManager().getGroup(targetName).getUserCount();
        } else if (this.getUserManager().hasOnCallRole(targetName)) {
            count = this.getUserManager().countUsersWithRole(targetName);
        } else if (this.getUserManager().hasUser(targetName)) {
            count = 1;
        } else if (targetName.indexOf(64) > -1) {
            count = 1;
        }
        return count;
    }

    private void sendNotifEvent(String uei, String logMessage, String description) {
        try {
            EventBuilder bldr = new EventBuilder(uei, "notifd");
            bldr.setLogMessage(logMessage);
            bldr.setDescription(description);
            this.getEventManager().sendNow(bldr.getEvent());
        }
        catch (Throwable t) {
            LOG.error("Could not send event {}", (Object)uei, (Object)t);
        }
    }

    protected Map<String, String> buildParameterMap(Notification notification, org.opennms.netmgt.xml.event.Event event, int noticeId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        NotificationManager.addNotificationParams(paramMap, (Notification)notification);
        paramMap.put("noticeid", Integer.toString(noticeId));
        String textMessage = NotificationManager.expandNotifParms((String)BroadcastEventProcessor.nullSafeTextMsg(notification), paramMap);
        String numericMessage = NotificationManager.expandNotifParms((String)BroadcastEventProcessor.nullSafeNumerMsg(notification, noticeId), paramMap);
        String subjectLine = NotificationManager.expandNotifParms((String)BroadcastEventProcessor.nullSafeSubj(notification, noticeId), paramMap);
        Map<String, Map<String, String>> decodeMap = this.getVarbindsDecodeMap(event.getUei());
        this.nullSafeExpandedPut("-tm", textMessage, event, paramMap, decodeMap);
        this.nullSafeExpandedPut("-nm", numericMessage, event, paramMap, decodeMap);
        this.nullSafeExpandedPut("-subject", subjectLine, event, paramMap, decodeMap);
        paramMap.put("-nodeid", event.hasNodeid() ? String.valueOf(event.getNodeid()) : "");
        paramMap.put("-interface", event.getInterface());
        paramMap.put("-service", event.getService());
        paramMap.put("eventID", String.valueOf(event.getDbid()));
        paramMap.put("eventUEI", event.getUei());
        this.m_eventUtil.expandMapValues(paramMap, event);
        return Collections.unmodifiableMap(paramMap);
    }

    protected Map<String, Map<String, String>> getVarbindsDecodeMap(String eventUei) {
        if (this.m_eventConfDao == null) {
            return null;
        }
        Event event = this.m_eventConfDao.findByUei(eventUei);
        if (event == null) {
            return null;
        }
        if (event.getVarbindsdecodeCollection().isEmpty()) {
            return null;
        }
        HashMap<String, Map<String, String>> decodeMap = new HashMap<String, Map<String, String>>();
        for (Varbindsdecode vb : event.getVarbindsdecodeCollection()) {
            String paramId = vb.getParmid();
            if (decodeMap.get(paramId) == null) {
                decodeMap.put(paramId, new HashMap());
            }
            for (Decode d : vb.getDecodeCollection()) {
                ((Map)decodeMap.get(paramId)).put(d.getVarbindvalue(), d.getVarbinddecodedstring());
            }
        }
        return decodeMap;
    }

    private void nullSafeExpandedPut(String key, String value, org.opennms.netmgt.xml.event.Event event, Map<String, String> paramMap, Map<String, Map<String, String>> decodeMap) {
        String result = this.m_eventUtil.expandParms(value, event, decodeMap);
        paramMap.put(key, result == null ? value : result);
    }

    private static String nullSafeSubj(Notification notification, int noticeId) {
        return notification.getSubject() != null ? notification.getSubject() : "Notice #" + noticeId;
    }

    private static String nullSafeNumerMsg(Notification notification, int noticeId) {
        return notification.getNumericMessage() != null ? notification.getNumericMessage() : "111-" + noticeId;
    }

    private static String nullSafeTextMsg(Notification notification) {
        return notification.getTextMessage() != null ? notification.getTextMessage() : "No text message supplied.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTargets(Target[] targets, List<NotificationTask> targetSiblings, NoticeQueue noticeQueue, long startTime, Map<String, String> params, int noticeId) throws IOException, MarshalException, ValidationException {
        for (int i = 0; i < targets.length; ++i) {
            String interval = targets[i].getInterval() == null ? "0s" : targets[i].getInterval();
            String targetName = targets[i].getName();
            String autoNotify = targets[i].getAutoNotify();
            autoNotify = autoNotify != null ? (autoNotify.equalsIgnoreCase("on") ? "Y" : (autoNotify.equalsIgnoreCase("off") ? "N" : "C")) : "C";
            LOG.debug("Processing target {}:{}", (Object)targetName, (Object)interval);
            NotificationTask[] tasks = null;
            if (this.getGroupManager().hasGroup(targetName)) {
                tasks = this.makeGroupTasks(startTime, params, noticeId, targetName, targets[i].getCommand(), targetSiblings, autoNotify, TimeConverter.convertToMillis((String)interval));
            } else if (this.getUserManager().hasOnCallRole(targetName)) {
                tasks = this.makeRoleTasks(startTime, params, noticeId, targetName, targets[i].getCommand(), targetSiblings, autoNotify, TimeConverter.convertToMillis((String)interval));
            } else if (this.getUserManager().hasUser(targetName)) {
                NotificationTask[] userTasks = new NotificationTask[]{this.makeUserTask(startTime, params, noticeId, targetName, targets[i].getCommand(), targetSiblings, autoNotify)};
                tasks = userTasks;
            } else if (targetName.indexOf(64) > -1) {
                String[] emailCommands = new String[]{this.getNotifdConfigManager().getConfiguration().getEmailAddressCommand()};
                NotificationTask[] emailTasks = new NotificationTask[]{this.makeEmailTask(startTime, params, noticeId, targetName, emailCommands, targetSiblings, autoNotify)};
                tasks = emailTasks;
            }
            if (tasks != null) {
                for (int index = 0; index < tasks.length; ++index) {
                    NotificationTask task = tasks[index];
                    if (task == null) continue;
                    NoticeQueue noticeQueue2 = noticeQueue;
                    synchronized (noticeQueue2) {
                        noticeQueue.putItem(task.getSendTime(), task);
                    }
                    this.getNotificationManager().incrementTasksQueued();
                    targetSiblings.add(task);
                }
                continue;
            }
            LOG.warn("Unrecognized target '{}' contained in destinationPaths.xml. Please check the configuration.", (Object)targetName);
        }
    }

    NotificationTask[] makeGroupTasks(long startTime, Map<String, String> params, int noticeId, String targetName, String[] command, List<NotificationTask> targetSiblings, String autoNotify, long interval) throws IOException, MarshalException, ValidationException {
        Group group = this.getGroupManager().getGroup(targetName);
        Calendar startCal = Calendar.getInstance();
        startCal.setTimeInMillis(startTime);
        long next = this.getGroupManager().groupNextOnDuty(group.getName(), startCal);
        if (next < 0L) {
            LOG.debug("The group {} is not scheduled to come back on duty. No notification will be sent to this group.", (Object)group.getName());
            return null;
        }
        LOG.debug("The group {} is on duty in {} millisec.", (Object)group.getName(), (Object)next);
        String[] users = group.getUser();
        if (users == null || users.length == 0) {
            LOG.debug("Not sending notice, no users specified for group {}", (Object)group.getName());
            return null;
        }
        return this.constructTasksFromUserList(users, startTime, next, params, noticeId, command, targetSiblings, autoNotify, interval);
    }

    private NotificationTask[] constructTasksFromUserList(String[] users, long startTime, long offset, Map<String, String> params, int noticeId, String[] command, List<NotificationTask> targetSiblings, String autoNotify, long interval) throws IOException, MarshalException, ValidationException {
        ArrayList<NotificationTask> taskList = new ArrayList<NotificationTask>(users.length);
        long curSendTime = 0L;
        for (int j = 0; j < users.length; ++j) {
            NotificationTask newTask = this.makeUserTask(offset + startTime + curSendTime, params, noticeId, users[j], command, targetSiblings, autoNotify);
            if (newTask == null) continue;
            taskList.add(newTask);
            curSendTime += interval;
        }
        return taskList.toArray(new NotificationTask[taskList.size()]);
    }

    NotificationTask[] makeRoleTasks(long startTime, Map<String, String> params, int noticeId, String targetName, String[] command, List<NotificationTask> targetSiblings, String autoNotify, long interval) throws MarshalException, ValidationException, IOException {
        String[] users = this.getUserManager().getUsersScheduledForRole(targetName, new Date(startTime));
        if (users == null || users.length == 0) {
            LOG.debug("Not sending notice, no users scheduled for role {}", (Object)targetName);
            return null;
        }
        return this.constructTasksFromUserList(users, startTime, 0L, params, noticeId, command, targetSiblings, autoNotify, interval);
    }

    private void processEscalations(Escalate[] escalations, List<NotificationTask> targetSiblings, NoticeQueue noticeQueue, long startTime, Map<String, String> params, int noticeId) throws IOException, MarshalException, ValidationException {
        for (int i = 0; i < escalations.length; ++i) {
            Target[] targets = escalations[i].getTarget();
            this.processTargets(targets, targetSiblings, noticeQueue, startTime += TimeConverter.convertToMillis((String)escalations[i].getDelay()), params, noticeId);
        }
    }

    NotificationTask makeUserTask(long sendTime, Map<String, String> parameters, int noticeId, String targetName, String[] commandList, List<NotificationTask> siblings, String autoNotify) throws IOException, MarshalException, ValidationException {
        NotificationTask task = null;
        task = new NotificationTask(this.getNotificationManager(), this.getUserManager(), sendTime, parameters, siblings, autoNotify);
        User user = this.getUserManager().getUser(targetName);
        Command[] commands = new Command[commandList.length];
        for (int i = 0; i < commandList.length; ++i) {
            commands[i] = this.getNotificationCommandManager().getCommand(commandList[i]);
            if (commands[i] == null || commands[i].getContactType() == null || this.userHasContactType(user, commands[i].getContactType())) continue;
            LOG.warn("User {} lacks contact of type {} which is required for notification command {} on notice #{}. Scheduling task anyway.", new Object[]{user.getUserId(), commands[i].getContactType(), commands[i].getName(), noticeId});
        }
        if (user == null) {
            LOG.error("user {} is not a valid user, not adding this user to escalation thread", (Object)targetName);
            return null;
        }
        task.setUser(user);
        task.setCommands(commands);
        task.setNoticeId(noticeId);
        task.setAutoNotify(autoNotify);
        return task;
    }

    NotificationTask makeEmailTask(long sendTime, Map<String, String> parameters, int noticeId, String address, String[] commandList, List<NotificationTask> siblings, String autoNotify) throws IOException, MarshalException, ValidationException {
        NotificationTask task = null;
        task = new NotificationTask(this.getNotificationManager(), this.getUserManager(), sendTime, parameters, siblings, autoNotify);
        User user = new User();
        user.setUserId(address);
        Contact contact = new Contact();
        contact.setType("email");
        LOG.debug("email address = {}, using contact type {}", (Object)address, (Object)contact.getType());
        contact.setInfo(address);
        user.addContact(contact);
        Command[] commands = new Command[commandList.length];
        for (int i = 0; i < commandList.length; ++i) {
            commands[i] = this.getNotificationCommandManager().getCommand(commandList[i]);
        }
        task.setUser(user);
        task.setCommands(commands);
        task.setNoticeId(noticeId);
        task.setAutoNotify(autoNotify);
        return task;
    }

    boolean userHasContactType(User user, String contactType) {
        return this.userHasContactType(user, contactType, false);
    }

    boolean userHasContactType(User user, String contactType, boolean allowEmpty) {
        boolean retVal = false;
        for (Contact c : user.getContacts()) {
            if (!contactType.equalsIgnoreCase(c.getType()) || !allowEmpty && "".equals(c.getInfo())) continue;
            retVal = true;
        }
        return retVal;
    }

    public String getName() {
        return "Notifd:BroadcastEventProcessor";
    }

    public Map<String, String> rebuildParameterMap(int notifId, String resolutionPrefix, boolean skipNumericPrefix) throws Exception {
        return this.getNotificationManager().rebuildParameterMap(notifId, resolutionPrefix, skipNumericPrefix);
    }

    public String scheduledOutage(long nodeId, String theInterface) {
        try {
            PollOutagesConfigManager outageFactory = this.getPollOutagesConfigManager();
            Collection outageCalendarNames = this.getNotifdConfigManager().getOutageCalendarNames();
            for (String outageName : outageCalendarNames) {
                if (!outageFactory.isCurTimeInOutage(outageName) || !outageFactory.isNodeIdInOutage(nodeId, outageName) && !outageFactory.isInterfaceInOutage(theInterface, outageName) && !outageFactory.isInterfaceInOutage("match-any", outageName)) continue;
                LOG.debug("scheduledOutage: configured outage '{}' applies, notification for interface {} on node {} will not be sent", new Object[]{outageName, theInterface, nodeId});
                return outageName;
            }
        }
        catch (Throwable e) {
            LOG.error("Error determining current outages", e);
        }
        return null;
    }

    private void createPathOutageEvent(int nodeid, String nodeLabel, String intfc, String svc, boolean noticeSupressed) {
        LOG.debug("nodeid = {}, nodeLabel = {}, noticeSupressed = {}", new Object[]{nodeid, nodeLabel, noticeSupressed});
        EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/pathOutage", "OpenNMS.notifd");
        bldr.setNodeid((long)nodeid);
        bldr.addParam("nodelabel", nodeLabel == null ? "" : nodeLabel);
        bldr.addParam("criticalPathIp", intfc);
        bldr.addParam("criticalPathServiceName", svc);
        bldr.addParam("noticeSupressed", noticeSupressed);
        LOG.debug("Creating pathOutageEvent for nodeid: {}", (Object)nodeid);
        try {
            EventIpcManagerFactory.getIpcManager().sendNow(bldr.getEvent());
        }
        catch (Throwable t) {
            LOG.warn("run: unexpected throwable exception caught during event send", t);
        }
    }

    public DestinationPathManager getDestinationPathManager() {
        return this.m_destinationPathManager;
    }

    public void setDestinationPathManager(DestinationPathManager destinationPathManager) {
        this.m_destinationPathManager = destinationPathManager;
    }

    public EventIpcManager getEventManager() {
        return this.m_eventManager;
    }

    public void setEventManager(EventIpcManager eventManager) {
        this.m_eventManager = eventManager;
    }

    public GroupManager getGroupManager() {
        return this.m_groupManager;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.m_groupManager = groupManager;
    }

    public NotifdConfigManager getNotifdConfigManager() {
        return this.m_notifdConfigManager;
    }

    public void setNotifdConfigManager(NotifdConfigManager notifdConfigManager) {
        this.m_notifdConfigManager = notifdConfigManager;
    }

    public NotificationCommandManager getNotificationCommandManager() {
        return this.m_notificationCommandManager;
    }

    public void setNotificationCommandManager(NotificationCommandManager notificationCommandManager) {
        this.m_notificationCommandManager = notificationCommandManager;
    }

    public NotificationManager getNotificationManager() {
        return this.m_notificationManager;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.m_notificationManager = notificationManager;
    }

    public PollOutagesConfigManager getPollOutagesConfigManager() {
        return this.m_pollOutagesConfigManager;
    }

    public void setPollOutagesConfigManager(PollOutagesConfigManager pollOutagesConfigManager) {
        this.m_pollOutagesConfigManager = pollOutagesConfigManager;
    }

    public UserManager getUserManager() {
        return this.m_userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.m_userManager = userManager;
    }

    public synchronized Map<String, NoticeQueue> getNoticeQueues() {
        return this.m_noticeQueues;
    }

    public void setNoticeQueues(Map<String, NoticeQueue> noticeQueues) {
        this.m_noticeQueues = noticeQueues;
    }

    public void setEventUtil(EventUtil eventUtil) {
        this.m_eventUtil = eventUtil;
    }

    public EventUtil getEventUtil() {
        return this.m_eventUtil;
    }

    public void setEventConfDao(EventConfDao eventConfDao) {
        this.m_eventConfDao = eventConfDao;
    }
}

