/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.Argument;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DefaultEventConfDao;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.model.notifd.NotificationStrategy;
import org.opennms.netmgt.xml.eventconf.AlarmData;
import org.opennms.netmgt.xml.eventconf.Event;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public class TicketNotificationStrategy
implements NotificationStrategy {
    private EventIpcManager m_eventManager = EventIpcManagerFactory.getIpcManager();
    private List<Argument> m_arguments;
    private DefaultEventConfDao m_eventConfDao;

    public int send(List<Argument> arguments) {
        String eventID = null;
        String eventUEI = null;
        String noticeID = null;
        this.m_arguments = arguments;
        for (Argument arg : this.m_arguments) {
            this.log().debug("arguments: " + arg.getSwitch() + " = " + arg.getValue());
            if ("eventID".equalsIgnoreCase(arg.getSwitch())) {
                eventID = arg.getValue();
                continue;
            }
            if ("eventUEI".equalsIgnoreCase(arg.getSwitch())) {
                eventUEI = arg.getValue();
                continue;
            }
            if (!"noticeid".equalsIgnoreCase(arg.getSwitch())) continue;
            noticeID = arg.getValue();
        }
        if (StringUtils.isBlank(eventID)) {
            this.log().error("There is no event-id associated with the notice-id='" + noticeID + "'. Cannot create ticket.");
            return 1;
        }
        if (StringUtils.isBlank(eventUEI)) {
            this.log().error("There is no event-uei associated with the notice-id='" + noticeID + "'. Cannot create ticket.");
            return 1;
        }
        AlarmType alarmType = this.getAlarmTypeFromUEI(eventUEI);
        if (alarmType == AlarmType.NOT_AN_ALARM) {
            this.log().warn("The event type associated with the notice-id='" + noticeID + "' is not an alarm. Will not create ticket.");
            return 0;
        }
        AlarmState alarmState = this.getAlarmStateFromEvent(Integer.parseInt(eventID));
        if (alarmState.getAlarmID() == 0) {
            this.log().error("There is no alarm-id associated with the event-id='" + eventID + "'. Will not create ticket.");
            return 1;
        }
        this.log().info("Got event-uei='" + eventUEI + "' with event-id='" + eventID + "', notice-id='" + noticeID + "', alarm-type='" + (Object)((Object)alarmType) + "', alarm-id='" + alarmState.getAlarmID() + "', tticket-id='" + alarmState.getTticketID() + "'and tticket-state='" + alarmState.getTticketState() + "'");
        this.sendCreateTicketEvent(alarmState.getAlarmID(), eventUEI);
        return 0;
    }

    protected AlarmState getAlarmStateFromEvent(int eventID) {
        AlarmStateRowCallbackHandler callbackHandler = new AlarmStateRowCallbackHandler();
        JdbcTemplate template = new JdbcTemplate(DataSourceFactory.getInstance());
        template.query("SELECT a.alarmid, a.tticketid, a.tticketstate FROM events AS e LEFT JOIN alarms AS a ON a.alarmid = e.alarmid WHERE e.eventid = ?", new Object[]{eventID}, (RowCallbackHandler)callbackHandler);
        return callbackHandler.getAlarmState();
    }

    protected AlarmType getAlarmTypeFromUEI(String eventUEI) {
        Event event = this.m_eventConfDao.findByUei(eventUEI);
        if (event == null) {
            return AlarmType.NOT_AN_ALARM;
        }
        AlarmData alarmData = event.getAlarmData();
        if (alarmData != null && alarmData.hasAlarmType()) {
            if (alarmData.getAlarmType() == 2) {
                return AlarmType.RESULTION;
            }
            return AlarmType.PROBLEM;
        }
        return AlarmType.NOT_AN_ALARM;
    }

    public void sendCreateTicketEvent(int alarmID, String alarmUEI) {
        if (this.log().isDebugEnabled()) {
            this.log().debug("Sending create ticket for alarm '" + alarmUEI + "' with id=" + alarmID);
        }
        EventBuilder ebldr = new EventBuilder("uei.opennms.org/troubleTicket/create", this.getName());
        ebldr.addParam("alarmId", alarmID);
        ebldr.addParam("alarmUei", alarmUEI);
        ebldr.addParam("user", "admin");
        this.m_eventManager.sendNow(ebldr.getEvent());
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public String getName() {
        return "Notifd:TicketNotificationStrategy";
    }

    protected class AlarmStateRowCallbackHandler
    implements RowCallbackHandler {
        AlarmState m_alarmState = null;

        public void processRow(ResultSet rs) throws SQLException {
            this.m_alarmState = new AlarmState(rs.getInt(1), rs.getString(2), rs.getInt(3));
        }

        public AlarmState getAlarmState() {
            return this.m_alarmState;
        }
    }

    public static class AlarmState {
        int m_alarmID;
        String m_tticketID;
        int m_tticketState;

        AlarmState(int alarmID) {
            this.m_alarmID = alarmID;
            this.m_tticketID = "";
            this.m_tticketState = 0;
        }

        AlarmState(int alarmID, String tticketID, int tticketState) {
            this.m_alarmID = alarmID;
            this.m_tticketID = tticketID;
            this.m_tticketState = tticketState;
        }

        public int getAlarmID() {
            return this.m_alarmID;
        }

        public String getTticketID() {
            return this.m_tticketID;
        }

        public int getTticketState() {
            return this.m_tticketState;
        }
    }

    static enum AlarmType {
        NOT_AN_ALARM,
        PROBLEM,
        RESULTION;

    }
}

