/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.newts.converter;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.sql.DataSource;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.features.newts.converter.NewtsConverterError;
import org.opennms.features.newts.converter.SimpleDataSource;
import org.opennms.netmgt.config.opennmsDataSources.DataSourceConfiguration;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;

public abstract class OnmsProperties {
    private static void registerProperties(Properties properties) {
        for (Object o : properties.keySet()) {
            String key = (String)o;
            if (System.getProperty(key) != null) continue;
            System.setProperty(key, properties.getProperty(key));
        }
    }

    private static void loadProperties(Properties properties, String fileName) throws Exception {
        File propertiesFile = ConfigFileConstants.getConfigFileByName((String)fileName);
        properties.load(new FileInputStream(propertiesFile));
    }

    public static void initialize() {
        try {
            Properties mainProperties = new Properties();
            OnmsProperties.loadProperties(mainProperties, "opennms.properties");
            OnmsProperties.registerProperties(mainProperties);
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.OPENNMS_DATASOURCE_CONFIG_FILE_NAME);
            DataSourceConfiguration dsc = (DataSourceConfiguration)JaxbUtils.unmarshal(DataSourceConfiguration.class, (File)cfgFile);
            boolean found = false;
            for (JdbcDataSource jds : dsc.getJdbcDataSourceCollection()) {
                if (!jds.getName().equals("opennms")) continue;
                SimpleDataSource ds = new SimpleDataSource(jds);
                DataSourceFactory.setInstance((DataSource)ds);
                found = true;
            }
            if (!found) {
                throw NewtsConverterError.create("Can't find OpenNMS database configuration", new Object[0]);
            }
        }
        catch (Exception e) {
            throw NewtsConverterError.create(e, "Can't initialize OpenNMS database connection factory: {}", e.getMessage());
        }
    }
}

