/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ncs.northbounder;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.opennms.core.utils.EmptyKeyRelaxedTrustProvider;
import org.opennms.core.utils.HttpResponseRange;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.api.support.AbstractNorthbounder;
import org.opennms.netmgt.ncs.northbounder.NCSNorthbounderConfig;
import org.opennms.netmgt.ncs.northbounder.transfer.ServiceAlarm;
import org.opennms.netmgt.ncs.northbounder.transfer.ServiceAlarmNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NCSNorthbounder
extends AbstractNorthbounder {
    private static final Logger LOG = LoggerFactory.getLogger(NCSNorthbounder.class);
    private static final String COMPONENT_NAME = "componentName";
    private static final String COMPONENT_FOREIGN_ID = "componentForeignId";
    private static final String COMPONENT_FOREIGN_SOURCE = "componentForeignSource";
    private static final String COMPONENT_TYPE = "componentType";
    private NCSNorthbounderConfig m_config;

    public NCSNorthbounder(NCSNorthbounderConfig config) {
        super("NCSNorthbounder");
        this.m_config = config;
        this.setNaglesDelay(this.m_config.getNaglesDelay());
    }

    public boolean accepts(NorthboundAlarm alarm) {
        if (!this.m_config.isEnabled()) {
            return false;
        }
        if (alarm.getAlarmType() == null) {
            return false;
        }
        if (alarm.getAlarmType() == NorthboundAlarm.AlarmType.NOTIFICATION) {
            return false;
        }
        if (this.m_config.getAcceptableUeis() != null && this.m_config.getAcceptableUeis().size() != 0 && !this.m_config.getAcceptableUeis().contains(alarm.getUei())) {
            return false;
        }
        Map alarmParms = alarm.getParameters();
        if (!alarmParms.containsKey(COMPONENT_TYPE)) {
            return false;
        }
        if (!alarmParms.containsKey(COMPONENT_FOREIGN_SOURCE)) {
            return false;
        }
        if (!alarmParms.containsKey(COMPONENT_FOREIGN_ID)) {
            return false;
        }
        if (!alarmParms.containsKey(COMPONENT_NAME)) {
            return false;
        }
        return "Service".equals(alarmParms.get(COMPONENT_TYPE));
    }

    private ServiceAlarmNotification toServiceAlarms(List<NorthboundAlarm> alarms) {
        ArrayList<ServiceAlarm> serviceAlarms = new ArrayList<ServiceAlarm>(alarms.size());
        for (NorthboundAlarm alarm : alarms) {
            serviceAlarms.add(this.toServiceAlarm(alarm));
        }
        return new ServiceAlarmNotification(serviceAlarms);
    }

    private ServiceAlarm toServiceAlarm(NorthboundAlarm alarm) {
        NorthboundAlarm.AlarmType alarmType = alarm.getAlarmType();
        Map alarmParms = alarm.getParameters();
        String id = (String)alarmParms.get(COMPONENT_FOREIGN_SOURCE) + ":" + (String)alarmParms.get(COMPONENT_FOREIGN_ID);
        String name = (String)alarmParms.get(COMPONENT_NAME);
        return new ServiceAlarm(id, name, alarmType == NorthboundAlarm.AlarmType.PROBLEM ? "Down" : "Up");
    }

    public void forwardAlarms(List<NorthboundAlarm> alarms) throws NorthbounderException {
        if (!this.m_config.isEnabled()) {
            return;
        }
        LOG.info("Forwarding {} alarms", (Object)alarms.size());
        HttpEntity entity = this.createEntity(alarms);
        this.postAlarms(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postAlarms(HttpEntity entity) {
        int connectionTimeout = 3000;
        int socketTimeout = 3000;
        Integer retryCount = 3;
        HttpVersion httpVersion = NCSNorthbounder.determineHttpVersion(this.m_config.getHttpVersion());
        URI uri = this.m_config.getURI();
        System.err.println("uri = " + uri);
        HttpClientWrapper clientWrapper = HttpClientWrapper.create().setSocketTimeout(Integer.valueOf(socketTimeout)).setConnectionTimeout(Integer.valueOf(connectionTimeout)).setRetries(retryCount).useBrowserCompatibleCookies().dontReuseConnections();
        if ("https".equals(uri.getScheme())) {
            try {
                clientWrapper.useRelaxedSSL("https");
            }
            catch (GeneralSecurityException e) {
                throw new NorthbounderException("Failed to configure Relaxed SSL handling.", (Throwable)e);
            }
        }
        HttpEntityEnclosingRequestBase method = this.m_config.getMethod().getRequestMethod(uri);
        if (this.m_config.getVirtualHost() != null && !this.m_config.getVirtualHost().trim().isEmpty()) {
            method.setHeader("Host", this.m_config.getVirtualHost());
        }
        if (this.m_config.getUserAgent() != null && !this.m_config.getUserAgent().trim().isEmpty()) {
            method.setHeader("User-Agent", this.m_config.getUserAgent());
        }
        method.setProtocolVersion((ProtocolVersion)httpVersion);
        method.setEntity(entity);
        CloseableHttpResponse response = null;
        try {
            System.err.println("execute: " + method);
            response = clientWrapper.execute((HttpUriRequest)method);
        }
        catch (ClientProtocolException e) {
            throw new NorthbounderException((Throwable)e);
        }
        catch (IOException e) {
            throw new NorthbounderException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)clientWrapper);
        }
        if (response != null) {
            try {
                int code = response.getStatusLine().getStatusCode();
                HttpResponseRange range = new HttpResponseRange("200-399");
                if (!range.contains(code)) {
                    LOG.warn("response code out of range for uri: {}.  Expected {} but received {}", new Object[]{uri, range, code});
                    throw new NorthbounderException("response code out of range for uri:" + uri + ".  Expected " + range + " but received " + code);
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)clientWrapper);
            }
        }
        LOG.debug(response != null ? response.getStatusLine().getReasonPhrase() : "Response was null");
    }

    private HttpEntity createEntity(List<NorthboundAlarm> alarms) {
        ByteArrayEntity byteArrayEntity;
        ByteArrayOutputStream out = null;
        OutputStreamWriter writer = null;
        try {
            out = new ByteArrayOutputStream();
            writer = new OutputStreamWriter(out);
            JaxbUtils.marshal((Object)this.toServiceAlarms(alarms), (Writer)writer);
            byte[] utf8 = out.toByteArray();
            ByteArrayEntity entity = new ByteArrayEntity(utf8);
            entity.setContentType("application/xml");
            byteArrayEntity = entity;
        }
        catch (Exception e) {
            try {
                throw new NorthbounderException("failed to convert alarms to xml", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                IOUtils.closeQuietly((OutputStream)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        IOUtils.closeQuietly((OutputStream)out);
        return byteArrayEntity;
    }

    private static HttpVersion determineHttpVersion(String version) {
        HttpVersion httpVersion = null;
        httpVersion = "1.0".equals(version) ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
        return httpVersion;
    }

    public NCSNorthbounderConfig getConfig() {
        return this.m_config;
    }

    public void setConfig(NCSNorthbounderConfig config) {
        this.m_config = config;
    }

    static {
        Security.addProvider((Provider)new EmptyKeyRelaxedTrustProvider());
    }
}

