/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.ncs;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.MapKeyColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.model.ncs.JAXBMapAdapter;
import org.opennms.netmgt.model.ncs.NCSComponentVisitor;

@Entity
@Table(name="ncscomponent")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@XmlRootElement(name="component")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NCSComponent {
    @XmlElement(name="id")
    private Long m_id;
    @XmlTransient
    private Integer m_version;
    @XmlAttribute(name="foreignSource", required=true)
    private String m_foreignSource;
    @XmlAttribute(name="foreignId", required=true)
    private String m_foreignId;
    @XmlAttribute(name="type", required=true)
    private String m_type;
    @XmlElement(name="name")
    private String m_name;
    @XmlElement(name="node")
    private NodeIdentification m_nodeIdentification;
    @XmlElement(name="upEventUei")
    private String m_upEventUei;
    @XmlElement(name="downEventUei")
    private String m_downEventUei;
    @XmlElement(name="dependenciesRequired", required=false, defaultValue="ALL")
    private DependencyRequirements m_dependenciesRequired;
    @XmlElement(name="attributes", required=false)
    @XmlJavaTypeAdapter(value=JAXBMapAdapter.class)
    private Map<String, String> m_attributes = new LinkedHashMap<String, String>();
    @XmlElement(name="component")
    private Set<NCSComponent> m_subcomponents = new LinkedHashSet<NCSComponent>();
    @XmlTransient
    private Set<NCSComponent> m_parents = new LinkedHashSet<NCSComponent>();

    public NCSComponent(String type, String foreignSource, String foreignId) {
        this();
        this.m_type = type;
        this.m_foreignSource = foreignSource;
        this.m_foreignId = foreignId;
    }

    public NCSComponent() {
    }

    @Id
    @Column(name="id", nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Long getId() {
        return this.m_id;
    }

    public void setId(Long id) {
        this.m_id = id;
    }

    @Version
    public Integer getVersion() {
        return this.m_version;
    }

    public void setVersion(Integer version) {
        this.m_version = version;
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }

    public void setForeignSource(String foreignSource) {
        this.m_foreignSource = foreignSource;
    }

    public String getForeignId() {
        return this.m_foreignId;
    }

    public void setForeignId(String foreignId) {
        this.m_foreignId = foreignId;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public NodeIdentification getNodeIdentification() {
        return this.m_nodeIdentification;
    }

    public void setNodeIdentification(NodeIdentification nodeIdentification) {
        this.m_nodeIdentification = nodeIdentification;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getUpEventUei() {
        return this.m_upEventUei;
    }

    public void setUpEventUei(String upEventUei) {
        this.m_upEventUei = upEventUei;
    }

    public String getDownEventUei() {
        return this.m_downEventUei;
    }

    public void setDownEventUei(String downEventUei) {
        this.m_downEventUei = downEventUei;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="depsRequired")
    public DependencyRequirements getDependenciesRequired() {
        return this.m_dependenciesRequired;
    }

    public void setDependenciesRequired(DependencyRequirements dependenciesRequired) {
        this.m_dependenciesRequired = dependenciesRequired;
    }

    @ManyToMany
    @JoinTable(name="subcomponents", joinColumns={@JoinColumn(name="subcomponent_id")}, inverseJoinColumns={@JoinColumn(name="component_id")})
    public Set<NCSComponent> getParentComponents() {
        return this.m_parents;
    }

    public void setParentComponents(Set<NCSComponent> parents) {
        this.m_parents = parents;
    }

    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="subcomponents", joinColumns={@JoinColumn(name="component_id")}, inverseJoinColumns={@JoinColumn(name="subcomponent_id")})
    public Set<NCSComponent> getSubcomponents() {
        return this.m_subcomponents;
    }

    public void setSubcomponents(Set<NCSComponent> subComponents) {
        this.m_subcomponents = subComponents;
    }

    public void addSubcomponent(NCSComponent subComponent) {
        this.getSubcomponents().add(subComponent);
    }

    public void removeSubcomponent(NCSComponent subComponent) {
        this.getSubcomponents().remove(subComponent);
    }

    public NCSComponent getSubcomponent(String foreignSource, String foreignId) {
        for (NCSComponent subcomponent : this.getSubcomponents()) {
            if (!subcomponent.hasIdentity(foreignSource, foreignId)) continue;
            return subcomponent;
        }
        return null;
    }

    public boolean hasIdentity(String foreignSource, String foreignId) {
        return this.m_foreignSource.equals(foreignSource) && this.m_foreignId.equals(foreignId);
    }

    @ElementCollection
    @JoinTable(name="ncs_attributes")
    @MapKeyColumn(name="key")
    @Column(name="value", nullable=false)
    public Map<String, String> getAttributes() {
        return this.m_attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.m_attributes = attributes;
    }

    public void setAttribute(String key, String value) {
        this.m_attributes.put(key, value);
    }

    public String removeAttribute(String key) {
        return this.m_attributes.remove(key);
    }

    public void visit(NCSComponentVisitor visitor) {
        visitor.visitComponent(this);
        for (NCSComponent subcomponent : this.getSubcomponents()) {
            subcomponent.visit(visitor);
        }
        visitor.completeComponent(this);
    }

    @XmlRootElement(name="node")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @Embeddable
    public static class NodeIdentification {
        @XmlAttribute(name="foreignSource", required=true)
        private String m_foreignSource;
        @XmlAttribute(name="foreignId", required=true)
        private String m_foreignId;

        public NodeIdentification() {
        }

        public NodeIdentification(String nodeForeignSource, String nodeForeignId) {
            this.m_foreignSource = nodeForeignSource;
            this.m_foreignId = nodeForeignId;
        }

        @Column(name="nodeForeignSource")
        public String getForeignSource() {
            return this.m_foreignSource;
        }

        public void setForeignSource(String foreignSource) {
            this.m_foreignSource = foreignSource;
        }

        @Column(name="nodeForeignId")
        public String getForeignId() {
            return this.m_foreignId;
        }

        public void setForeignId(String foreignId) {
            this.m_foreignId = foreignId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_foreignId == null ? 0 : this.m_foreignId.hashCode());
            result = 31 * result + (this.m_foreignSource == null ? 0 : this.m_foreignSource.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeIdentification other = (NodeIdentification)obj;
            if (this.m_foreignId == null ? other.m_foreignId != null : !this.m_foreignId.equals(other.m_foreignId)) {
                return false;
            }
            return !(this.m_foreignSource == null ? other.m_foreignSource != null : !this.m_foreignSource.equals(other.m_foreignSource));
        }
    }

    public static enum DependencyRequirements {
        ANY,
        ALL;

    }
}

