/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.ncs;

import org.opennms.netmgt.model.ncs.NCSComponent;

public class NCSBuilder {
    private final NCSBuilder m_parent;
    private final NCSComponent m_component;

    public NCSBuilder(String type, String foreignSource, String foreignId) {
        this(null, new NCSComponent(type, foreignSource, foreignId));
    }

    public NCSBuilder(NCSBuilder parent, NCSComponent component) {
        this.m_parent = parent;
        this.m_component = component;
    }

    public NCSBuilder setForeignSource(String foreignSource) {
        this.m_component.setForeignSource(foreignSource);
        return this;
    }

    public NCSBuilder setForeignId(String foreignId) {
        this.m_component.setForeignId(foreignId);
        return this;
    }

    public NCSBuilder setNodeIdentity(String nodeForeignSource, String nodeForeignId) {
        this.m_component.setNodeIdentification(new NCSComponent.NodeIdentification(nodeForeignSource, nodeForeignId));
        return this;
    }

    public NCSBuilder setType(String type) {
        this.m_component.setType(type);
        return this;
    }

    public NCSBuilder setName(String name) {
        this.m_component.setName(name);
        return this;
    }

    public NCSBuilder setUpEventUei(String upEventUei) {
        this.m_component.setUpEventUei(upEventUei);
        return this;
    }

    public NCSBuilder setDownEventUei(String downEventUei) {
        this.m_component.setDownEventUei(downEventUei);
        return this;
    }

    public NCSBuilder setAttribute(String key, String value) {
        this.m_component.setAttribute(key, value);
        return this;
    }

    public NCSBuilder setDependenciesRequired(NCSComponent.DependencyRequirements requirements) {
        this.m_component.setDependenciesRequired(requirements);
        return this;
    }

    public NCSBuilder pushComponent(String type, String foreignSource, String foreignId) {
        NCSComponent sub = new NCSComponent(type, foreignSource, foreignId);
        this.m_component.addSubcomponent(sub);
        return new NCSBuilder(this, sub);
    }

    public NCSBuilder popComponent() {
        return this.m_parent;
    }

    public NCSComponent get() {
        return this.m_component;
    }
}

