/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ncs.northbounder;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.opennms.netmgt.alarmd.api.NorthbounderException;

@XmlRootElement(name="ncs-northbounder-config")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NCSNorthbounderConfig
implements Serializable,
Comparable<NCSNorthbounderConfig> {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="enabled", required=true)
    private boolean m_enabled = true;
    @XmlAttribute(name="nagles-delay", required=true)
    private long m_naglesDelay = 100L;
    @XmlAttribute(name="method", required=false)
    private HttpMethod m_method = HttpMethod.POST;
    @XmlAttribute(name="http-version", required=false)
    private String m_httpVersion = "1.1";
    @XmlAttribute(name="user-agent", required=false)
    private String m_userAgent = "OpenNMS Http Northbound Interface";
    @XmlAttribute(name="virtual-host", required=false)
    private String m_virtualHost;
    @XmlAttribute(name="scheme", required=false)
    private String m_scheme = "http";
    @XmlAttribute(name="user-info", required=false)
    private String m_userInfo;
    @XmlAttribute(name="host", required=true)
    private String m_host;
    @XmlAttribute(name="port", required=false)
    private Integer m_port = 80;
    @XmlAttribute(name="path", required=false)
    private String m_path = "/";
    @XmlAttribute(name="query", required=false)
    private String m_query;
    @XmlAttribute(name="fragment", required=false)
    private String m_fragment;
    @XmlElement(name="uei")
    private List<String> m_acceptableUeis;

    @Override
    public int compareTo(NCSNorthbounderConfig o) {
        int c = 0;
        try {
            c = this.getURI().compareTo(o.getURI());
        }
        catch (NorthbounderException northbounderException) {
            // empty catch block
        }
        return c;
    }

    public boolean equals(Object o) {
        boolean eq = false;
        if (o instanceof NCSNorthbounderConfig) {
            NCSNorthbounderConfig other = (NCSNorthbounderConfig)o;
            try {
                eq = this.getURI().equals(other.getURI());
            }
            catch (NorthbounderException e) {
                eq = false;
            }
        }
        return eq;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public HttpMethod getMethod() {
        return this.m_method;
    }

    public void setMethod(HttpMethod method) {
        this.m_method = method;
    }

    public String getHttpVersion() {
        return this.m_httpVersion;
    }

    public void setHttpVersion(String httpVersion) {
        this.m_httpVersion = httpVersion;
    }

    public String getUserAgent() {
        return this.m_userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.m_userAgent = userAgent;
    }

    public String getVirtualHost() {
        return this.m_virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.m_virtualHost = virtualHost;
    }

    public String getScheme() {
        return this.m_scheme;
    }

    public void setScheme(String scheme) {
        this.m_scheme = scheme;
    }

    public String getUserInfo() {
        return this.m_userInfo;
    }

    public void setUserInfo(String userInfo) {
        this.m_userInfo = userInfo;
    }

    public String getHost() {
        return this.m_host;
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    public Integer getPort() {
        return this.m_port;
    }

    public void setPort(Integer port) {
        this.m_port = port;
    }

    public String getPath() {
        return this.m_path;
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public String getQuery() {
        return this.m_query;
    }

    public void setQuery(String query) {
        this.m_query = query;
    }

    public String getFragment() {
        return this.m_fragment;
    }

    public void setFragment(String fragment) {
        this.m_fragment = fragment;
    }

    public long getNaglesDelay() {
        return this.m_naglesDelay;
    }

    public void setNaglesDelay(long naglesDelay) {
        this.m_naglesDelay = naglesDelay;
    }

    public List<String> getAcceptableUeis() {
        return this.m_acceptableUeis;
    }

    public void setAcceptableUeis(List<String> acceptableUeis) {
        this.m_acceptableUeis = acceptableUeis;
    }

    public URI getURI() {
        try {
            return new URI(this.getScheme(), this.getUserInfo(), this.getHost(), this.getPort(), this.getPath(), this.getQuery(), this.getFragment());
        }
        catch (URISyntaxException e) {
            throw new NorthbounderException((Throwable)e);
        }
    }

    public static enum HttpMethod {
        POST{

            @Override
            HttpEntityEnclosingRequestBase getRequestMethod(URI uri) {
                return new HttpPost(uri);
            }
        }
        ,
        PUT{

            @Override
            HttpEntityEnclosingRequestBase getRequestMethod(URI uri) {
                return new HttpPut(uri);
            }
        };


        abstract HttpEntityEnclosingRequestBase getRequestMethod(URI var1);
    }
}

