/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation.ncs;

import java.util.List;
import org.opennms.netmgt.model.ncs.NCSComponent;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;

public interface NCSCorrelationService {
    public List<NCSComponent> findComponentsThatDependOn(Long var1);

    public List<NCSComponent> findSubComponents(Long var1);

    public List<NCSComponent> findComponentsByNodeIdAndAttrParmMaps(Event var1, AttrParmMap ... var2);

    public List<NCSComponent> findComponentsByNodeIdAndEventParameters(Event var1, String ... var2);

    public static class AttrParmMap {
        String m_attributeName;
        int m_paramterIndex;

        public AttrParmMap(String attributeName, int parameterIndex) {
            this.m_attributeName = attributeName;
            this.m_paramterIndex = parameterIndex;
        }

        public boolean matches(NCSComponent component, Event e) {
            if (!component.getAttributes().containsKey(this.m_attributeName)) {
                return false;
            }
            List parms = e.getParmCollection();
            if (this.m_paramterIndex > parms.size()) {
                return false;
            }
            Parm parm = (Parm)parms.get(this.m_paramterIndex - 1);
            Value val = parm.getValue();
            if (val == null) {
                return false;
            }
            String attrVal = (String)component.getAttributes().get(this.m_attributeName);
            String eventVal = val.getContent();
            return attrVal == null ? eventVal == null : attrVal.equals(eventVal);
        }
    }
}

