/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import io.netty.buffer.ByteBuf;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramVisitor;

public class IpV4 {
    public final Inet4Address ip_v4;

    public IpV4(ByteBuf buffer) {
        try {
            this.ip_v4 = (Inet4Address)Inet4Address.getByAddress(BufferUtils.bytes((ByteBuf)buffer, (int)4));
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ip_v4", (Object)this.ip_v4).toString();
    }

    public Inet4Address getAddress() {
        return this.ip_v4;
    }

    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeString("address", this.ip_v4.getHostAddress());
        enr.getHostnameFor(this.ip_v4).ifPresent(hostname -> bsonWriter.writeString("hostname", hostname));
        bsonWriter.writeEndDocument();
    }

    public void visit(SampleDatagramVisitor visitor) {
        visitor.accept(this);
    }
}

