/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.prometheus;

import java.io.InputStream;
import org.hawkular.agent.prometheus.PrometheusMetricDataParser;
import org.hawkular.agent.prometheus.types.Counter;
import org.hawkular.agent.prometheus.types.Gauge;
import org.hawkular.agent.prometheus.types.Histogram;
import org.hawkular.agent.prometheus.types.Metric;
import org.hawkular.agent.prometheus.types.MetricFamily;
import org.hawkular.agent.prometheus.types.Summary;
import org.hawkular.agent.prometheus.walkers.PrometheusMetricsWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PrometheusMetricsProcessor<T> {
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricsProcessor.class);
    private final InputStream inputStream;
    private final PrometheusMetricsWalker walker;

    public PrometheusMetricsProcessor(InputStream inputStream, PrometheusMetricsWalker theWalker) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Stream must not be null");
        }
        this.inputStream = inputStream;
        if (theWalker == null) {
            throw new IllegalArgumentException("Walker must not be null");
        }
        this.walker = theWalker;
    }

    public void walk() {
        this.walker.walkStart();
        int totalMetrics = 0;
        int familyIndex = 0;
        try {
            PrometheusMetricDataParser<T> parser = this.createPrometheusMetricDataParser();
            T metricFamily = parser.parse();
            while (metricFamily != null) {
                MetricFamily convertedMetricFamily = this.convert(metricFamily);
                this.walker.walkMetricFamily(convertedMetricFamily, familyIndex++);
                int metricIndex = 0;
                for (Metric metric : convertedMetricFamily.getMetrics()) {
                    switch (convertedMetricFamily.getType()) {
                        case COUNTER: {
                            this.walker.walkCounterMetric(convertedMetricFamily, (Counter)metric, metricIndex);
                            break;
                        }
                        case GAUGE: {
                            this.walker.walkGaugeMetric(convertedMetricFamily, (Gauge)metric, metricIndex);
                            break;
                        }
                        case SUMMARY: {
                            this.walker.walkSummaryMetric(convertedMetricFamily, (Summary)metric, metricIndex);
                            break;
                        }
                        case HISTOGRAM: {
                            this.walker.walkHistogramMetric(convertedMetricFamily, (Histogram)metric, metricIndex);
                        }
                    }
                    ++metricIndex;
                }
                totalMetrics += convertedMetricFamily.getMetrics().size();
                metricFamily = parser.parse();
            }
        }
        catch (Exception e) {
            log.debug("Error while processing binary data", (Throwable)e);
        }
        this.walker.walkFinish(familyIndex, totalMetrics);
    }

    protected InputStream getInputStream() {
        return this.inputStream;
    }

    protected PrometheusMetricsWalker getWalker() {
        return this.walker;
    }

    protected abstract PrometheusMetricDataParser<T> createPrometheusMetricDataParser();

    protected abstract MetricFamily convert(T var1);
}

