/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.Header;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerAccessor;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerHeader;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.InitiationPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.PeerDownPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.PeerUpPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.RouteMirroringPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.RouteMonitoringPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.StatisticsReportPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.TerminationPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.UnknownPacket;

public interface Packet {
    public void accept(Visitor var1);

    public <R> R map(Mapper<R> var1);

    default public Optional<PeerHeader> getPeerHeader() {
        return this.map(new Mapper<Optional<PeerHeader>>(){

            @Override
            public Optional<PeerHeader> map(InitiationPacket packet) {
                return Optional.empty();
            }

            @Override
            public Optional<PeerHeader> map(TerminationPacket packet) {
                return Optional.empty();
            }

            @Override
            public Optional<PeerHeader> map(PeerUpPacket packet) {
                return Optional.of(packet.peerHeader);
            }

            @Override
            public Optional<PeerHeader> map(PeerDownPacket packet) {
                return Optional.of(packet.peerHeader);
            }

            @Override
            public Optional<PeerHeader> map(StatisticsReportPacket packet) {
                return Optional.of(packet.peerHeader);
            }

            @Override
            public Optional<PeerHeader> map(RouteMonitoringPacket packet) {
                return Optional.of(packet.peerHeader);
            }

            @Override
            public Optional<PeerHeader> map(RouteMirroringPacket packet) {
                return Optional.of(packet.peerHeader);
            }

            @Override
            public Optional<PeerHeader> map(UnknownPacket packet) {
                return Optional.empty();
            }
        });
    }

    public static interface Mapper<R> {
        public R map(InitiationPacket var1);

        public R map(TerminationPacket var1);

        public R map(PeerUpPacket var1);

        public R map(PeerDownPacket var1);

        public R map(StatisticsReportPacket var1);

        public R map(RouteMonitoringPacket var1);

        public R map(RouteMirroringPacket var1);

        public R map(UnknownPacket var1);

        public static class Adapter<R>
        implements Mapper<R> {
            private final R defaultValue;

            public Adapter(R defaultValue) {
                this.defaultValue = Objects.requireNonNull(defaultValue);
            }

            @Override
            public R map(InitiationPacket packet) {
                return this.defaultValue;
            }

            @Override
            public R map(TerminationPacket packet) {
                return this.defaultValue;
            }

            @Override
            public R map(PeerUpPacket packet) {
                return this.defaultValue;
            }

            @Override
            public R map(PeerDownPacket packet) {
                return this.defaultValue;
            }

            @Override
            public R map(StatisticsReportPacket packet) {
                return this.defaultValue;
            }

            @Override
            public R map(RouteMonitoringPacket packet) {
                return this.defaultValue;
            }

            @Override
            public R map(RouteMirroringPacket packet) {
                return this.defaultValue;
            }

            @Override
            public R map(UnknownPacket packet) {
                return this.defaultValue;
            }
        }
    }

    public static interface Visitor {
        public void visit(InitiationPacket var1);

        public void visit(TerminationPacket var1);

        public void visit(PeerUpPacket var1);

        public void visit(PeerDownPacket var1);

        public void visit(StatisticsReportPacket var1);

        public void visit(RouteMonitoringPacket var1);

        public void visit(RouteMirroringPacket var1);

        public void visit(UnknownPacket var1);

        public static class Adapter
        implements Visitor {
            @Override
            public void visit(RouteMonitoringPacket packet) {
            }

            @Override
            public void visit(StatisticsReportPacket packet) {
            }

            @Override
            public void visit(PeerDownPacket packet) {
            }

            @Override
            public void visit(PeerUpPacket packet) {
            }

            @Override
            public void visit(InitiationPacket packet) {
            }

            @Override
            public void visit(TerminationPacket packet) {
            }

            @Override
            public void visit(RouteMirroringPacket packet) {
            }

            @Override
            public void visit(UnknownPacket packet) {
            }
        }
    }

    public static interface Parser {
        public Packet parse(Header var1, ByteBuf var2, PeerAccessor var3) throws InvalidPacketException;
    }
}

