/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.BmpParser;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.Header;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.Packet;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Aggregator;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.AsPath;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.AsPathLimit;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.AtomicAggregate;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.AttrSet;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Attribute;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.ClusterList;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Community;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Connector;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.ExtendedCommunities;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.ExtendedV6Communities;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.LargeCommunities;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.LocalPref;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.MultiExistDisc;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.MultiprotocolReachableNlri;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.MultiprotocolUnreachableNlri;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.NextHop;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Origin;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.OriginatorId;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Unknown;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerFlags;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerInfo;

public class UpdatePacket
implements Packet {
    public final Header header;
    public final List<Prefix> withdrawRoutes;
    public final List<PathAttribute> pathAttributes;
    public final List<Prefix> reachableRoutes;

    public UpdatePacket(Header header, ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
        this.header = Objects.requireNonNull(header);
        this.withdrawRoutes = BufferUtils.repeatRemaining((ByteBuf)BufferUtils.slice((ByteBuf)buffer, (int)BufferUtils.uint16((ByteBuf)buffer)), prefixBuffer -> new Prefix(prefixBuffer, flags, peerInfo));
        this.pathAttributes = BufferUtils.repeatRemaining((ByteBuf)BufferUtils.slice((ByteBuf)buffer, (int)BufferUtils.uint16((ByteBuf)buffer)), pathAttributeBuffer -> new PathAttribute(pathAttributeBuffer, flags, peerInfo));
        this.reachableRoutes = BufferUtils.repeatRemaining((ByteBuf)buffer, prefixBuffer -> new Prefix(prefixBuffer, flags, peerInfo));
    }

    @Override
    public void accept(Packet.Visitor visitor) {
        visitor.visit(this);
    }

    public static Optional<UpdatePacket> parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
        Header header = new Header(buffer);
        if (header.type != Header.Type.UPDATE) {
            BmpParser.RATE_LIMITED_LOG.debug("Expected Update Message, got: {}", (Object)header.type);
            BufferUtils.skip((ByteBuf)buffer, (int)(header.length - 19));
            return Optional.empty();
        }
        return Optional.of(new UpdatePacket(header, BufferUtils.slice((ByteBuf)buffer, (int)(header.length - 19)), flags, peerInfo));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("withdrawRoutes", this.withdrawRoutes).add("pathAttributes", this.pathAttributes).add("reachableRoutes", this.reachableRoutes).toString();
    }

    public static class PathAttribute {
        public final boolean optional;
        public final boolean transitive;
        public final boolean partial;
        public final boolean extended;
        public final Type type;
        public final int length;
        public final Attribute attribute;

        public PathAttribute(ByteBuf buffer, PeerFlags peerFlags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
            int flags = BufferUtils.uint8((ByteBuf)buffer);
            this.optional = (flags >> 7 & 1) == 1;
            this.transitive = (flags >> 6 & 1) == 1;
            this.partial = (flags >> 5 & 1) == 1;
            this.extended = (flags >> 4 & 1) == 1;
            this.type = Type.from(BufferUtils.uint8((ByteBuf)buffer));
            this.length = this.extended ? BufferUtils.uint16((ByteBuf)buffer) : BufferUtils.uint8((ByteBuf)buffer);
            this.attribute = this.type.parse(BufferUtils.slice((ByteBuf)buffer, (int)this.length), peerFlags, peerInfo);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("optional", this.optional).add("transitive", this.transitive).add("partial", this.partial).add("extended", this.extended).add("type", (Object)this.type).add("length", this.length).add("attribute", (Object)this.attribute).toString();
        }

        public static enum Type {
            ORIGIN{

                @Override
                public Attribute parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new Origin(buffer, flags);
                }
            }
            ,
            AS_PATH{

                @Override
                public Attribute parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new AsPath(buffer, flags);
                }
            }
            ,
            NEXT_HOP{

                @Override
                public Attribute parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new NextHop(buffer, flags);
                }
            }
            ,
            MULTI_EXIT_DISC{

                @Override
                public Attribute parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new MultiExistDisc(buffer, flags);
                }
            }
            ,
            LOCAL_PREF{

                @Override
                public Attribute parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new LocalPref(buffer, flags);
                }
            }
            ,
            ATOMIC_AGGREGATE{

                @Override
                public Attribute parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new AtomicAggregate(buffer, flags);
                }
            }
            ,
            AGGREGATOR{

                @Override
                public Attribute parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new Aggregator(buffer, flags);
                }
            }
            ,
            COMMUNITY{

                @Override
                public Attribute parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new Community(buffer, flags);
                }
            }
            ,
            ORIGINATOR_ID{

                @Override
                public Attribute parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new OriginatorId(buffer, flags);
                }
            }
            ,
            CLUSTER_LIST{

                @Override
                public Attribute parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new ClusterList(buffer, flags);
                }
            }
            ,
            EXTENDED_COMMUNITIES{

                @Override
                public Attribute parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new ExtendedCommunities(buffer, flags);
                }
            }
            ,
            CONNECTOR_ATTRIBUTE{

                @Override
                public Attribute parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new Connector(buffer, flags);
                }
            }
            ,
            AS_PATH_LIMIT{

                @Override
                public Attribute parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new AsPathLimit(buffer, flags);
                }
            }
            ,
            EXTENDED_V6_COMMUNITIES{

                @Override
                public Attribute parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new ExtendedV6Communities(buffer, flags);
                }
            }
            ,
            LARGE_COMMUNITIES{

                @Override
                public Attribute parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new LargeCommunities(buffer, flags);
                }
            }
            ,
            ATTR_SET{

                @Override
                public Attribute parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new AttrSet(buffer, flags, peerInfo);
                }
            }
            ,
            UNKNOWN{

                @Override
                public Attribute parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new Unknown(buffer, flags);
                }
            }
            ,
            MP_REACH_NLRI{

                @Override
                public Attribute parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new MultiprotocolReachableNlri(buffer, flags, peerInfo);
                }
            }
            ,
            MP_UNREACH_NLRI{

                @Override
                public Attribute parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new MultiprotocolUnreachableNlri(buffer, flags, peerInfo);
                }
            };


            public abstract Attribute parse(ByteBuf var1, PeerFlags var2, Optional<PeerInfo> var3) throws InvalidPacketException;

            private static Type from(int type) {
                switch (type) {
                    case 1: {
                        return ORIGIN;
                    }
                    case 2: {
                        return AS_PATH;
                    }
                    case 3: {
                        return NEXT_HOP;
                    }
                    case 4: {
                        return MULTI_EXIT_DISC;
                    }
                    case 5: {
                        return LOCAL_PREF;
                    }
                    case 6: {
                        return ATOMIC_AGGREGATE;
                    }
                    case 7: {
                        return AGGREGATOR;
                    }
                    case 8: {
                        return COMMUNITY;
                    }
                    case 9: {
                        return ORIGINATOR_ID;
                    }
                    case 10: {
                        return CLUSTER_LIST;
                    }
                    case 14: {
                        return MP_REACH_NLRI;
                    }
                    case 15: {
                        return MP_UNREACH_NLRI;
                    }
                    case 16: {
                        return EXTENDED_COMMUNITIES;
                    }
                    case 20: {
                        return CONNECTOR_ATTRIBUTE;
                    }
                    case 21: {
                        return AS_PATH_LIMIT;
                    }
                    case 25: {
                        return EXTENDED_V6_COMMUNITIES;
                    }
                    case 32: {
                        return LARGE_COMMUNITIES;
                    }
                    case 128: {
                        return ATTR_SET;
                    }
                }
                BmpParser.RATE_LIMITED_LOG.debug("Unknown Update Packet Type: {}", (Object)type);
                return UNKNOWN;
            }
        }
    }

    public static class Prefix {
        private static final int BGP_AFI_IPV4 = 1;
        private static final int BGP_SAFI_UNICAST = 1;
        public int length;
        public InetAddress prefix;
        public String labels = "";
        public long pathId = 0L;

        public Prefix(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) {
            boolean addPathCapabilityEnabled = peerInfo.map(info -> info.isAddPathEnabled(1, 1)).orElse(false);
            if (addPathCapabilityEnabled) {
                this.pathId = BufferUtils.uint32((ByteBuf)buffer);
            }
            this.length = BufferUtils.uint8((ByteBuf)buffer);
            byte[] prefix = new byte[flags.addressVersion.map(v -> {
                switch (v) {
                    case IP_V4: {
                        return 4;
                    }
                    case IP_V6: {
                        return 16;
                    }
                }
                throw new IllegalStateException();
            }).intValue()];
            buffer.readBytes(prefix, 0, (this.length + 7) / 8);
            this.prefix = InetAddressUtils.getInetAddress((byte[])prefix);
        }

        public Prefix() {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("length", this.length).add("prefix", (Object)this.prefix).add("pathId", this.pathId).add("labels", (Object)this.labels).toString();
        }
    }
}

