/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.tape2;

import com.squareup.tape2.ObjectQueue;
import com.squareup.tape2.QueueFile;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

final class InMemoryObjectQueue<T>
extends ObjectQueue<T> {
    private final Deque<T> entries = new ArrayDeque<T>();
    int modCount = 0;
    boolean closed;

    InMemoryObjectQueue() {
    }

    @Override
    @Nullable
    public QueueFile file() {
        return null;
    }

    @Override
    public void add(T entry) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        ++this.modCount;
        this.entries.addLast(entry);
    }

    @Override
    @Nullable
    public T peek() {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        return this.entries.peekFirst();
    }

    @Override
    public List<T> asList() {
        return Collections.unmodifiableList(new ArrayList<T>(this.entries));
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public void remove() {
        this.remove(1);
    }

    @Override
    public void remove(int n) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        ++this.modCount;
        for (int i = 0; i < n; ++i) {
            this.entries.removeFirst();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new EntryIterator(this.entries.iterator());
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public String toString() {
        return "InMemoryObjectQueue{size=" + this.entries.size() + '}';
    }

    private final class EntryIterator
    implements Iterator<T> {
        private final Iterator<T> delegate;
        private int index = 0;
        private int expectedModCount;

        EntryIterator(Iterator<T> delegate) {
            this.expectedModCount = InMemoryObjectQueue.this.modCount;
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            this.checkForComodification();
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            if (InMemoryObjectQueue.this.closed) {
                throw new IllegalStateException("closed");
            }
            this.checkForComodification();
            Object next = this.delegate.next();
            ++this.index;
            return next;
        }

        @Override
        public void remove() {
            if (InMemoryObjectQueue.this.closed) {
                throw new IllegalStateException("closed");
            }
            this.checkForComodification();
            if (InMemoryObjectQueue.this.size() == 0) {
                throw new NoSuchElementException();
            }
            if (this.index != 1) {
                throw new UnsupportedOperationException("Removal is only permitted from the head.");
            }
            InMemoryObjectQueue.this.remove();
            this.expectedModCount = InMemoryObjectQueue.this.modCount;
            --this.index;
        }

        private void checkForComodification() {
            if (InMemoryObjectQueue.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

