/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.health.impl;

import com.google.common.base.Strings;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.bundle.core.BundleInfo;
import org.apache.karaf.bundle.core.BundleService;
import org.opennms.core.health.api.Context;
import org.opennms.core.health.api.Health;
import org.opennms.core.health.api.HealthCheck;
import org.opennms.core.health.api.Response;
import org.opennms.core.health.api.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleRevision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerIntegrityHealthCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerIntegrityHealthCheck.class);
    private final BundleService bundleService;
    private final BundleContext bundleContext;
    private final List<String> ignoreBundles;

    public ContainerIntegrityHealthCheck(BundleContext bundleContext, BundleService bundleService, String ignoreBundleList) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
        this.bundleService = Objects.requireNonNull(bundleService);
        this.ignoreBundles = this.parse(ignoreBundleList);
    }

    public String getDescription() {
        return "Verifying installed bundles";
    }

    public Response perform(Context context) {
        if (ManagementFactory.getRuntimeMXBean().getUptime() <= 10000L) {
            return new Response(Status.Starting, "Container is in spin up phase");
        }
        Health health = new Health();
        block8: for (Bundle b : this.bundleContext.getBundles()) {
            if (this.ignoreBundles.contains(b.getSymbolicName())) {
                LOG.debug("Bundle {} with symbolic name {} is ignored while performing health:check", (Object)b.getBundleId(), (Object)b.getSymbolicName());
                continue;
            }
            BundleInfo info = this.bundleService.getInfo(b);
            switch (info.getState()) {
                case Active: {
                    continue block8;
                }
                case Resolved: {
                    if ((((BundleRevision)b.adapt(BundleRevision.class)).getTypes() & 1) != 0) continue block8;
                    health.add(new Response(Status.Failure, "Bundle " + b.getBundleId() + " is resolved, but not active"));
                    continue block8;
                }
                case Waiting: 
                case GracePeriod: {
                    health.add(new Response(Status.Starting, "Bundle " + b.getBundleId() + " is waiting for dependencies"));
                    continue block8;
                }
                case Installed: {
                    health.add(new Response(Status.Starting, "Bundle " + b.getBundleId() + " is not yet started"));
                    continue block8;
                }
                case Starting: {
                    health.add(new Response(Status.Starting, "Bundle " + b.getBundleId() + " is starting"));
                    continue block8;
                }
                case Stopping: 
                case Failure: 
                case Unknown: {
                    health.add(new Response(Status.Failure, "Bundle " + b.getBundleId() + " is not started"));
                }
            }
        }
        return health.getWorst().orElse(new Response(Status.Success));
    }

    private List<String> parse(String bundlesToIgnore) {
        if (Strings.isNullOrEmpty((String)bundlesToIgnore)) {
            return Collections.emptyList();
        }
        Set symbolicBundleNamesToIgnore = Arrays.stream(bundlesToIgnore.split(",")).map(s -> s == null ? null : s.trim()).filter(s -> s != null && !s.isEmpty()).collect(Collectors.toSet());
        return new ArrayList<String>(symbolicBundleNamesToIgnore);
    }
}

