/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.translator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="value")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="translator-configuration.xsd")
public class Value
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="result", required=true)
    private String m_result;
    @XmlAttribute(name="matches")
    private String m_matches;
    @XmlAttribute(name="type", required=true)
    private String m_type;
    @XmlAttribute(name="name")
    private String m_name;
    @XmlElement(name="value")
    private List<Value> m_values = new ArrayList<Value>();

    public void addValue(Value value) {
        this.m_values.add(value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Value) {
            Value that = (Value)obj;
            return Objects.equals(this.m_result, that.m_result) && Objects.equals(this.m_matches, that.m_matches) && Objects.equals(this.m_type, that.m_type) && Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_values, that.m_values);
        }
        return false;
    }

    public Optional<String> getMatches() {
        return Optional.ofNullable(this.m_matches);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.m_name);
    }

    public String getResult() {
        return this.m_result;
    }

    public String getType() {
        return this.m_type;
    }

    public List<Value> getValues() {
        return this.m_values;
    }

    public int hashCode() {
        return Objects.hash(this.m_result, this.m_matches, this.m_type, this.m_name, this.m_values);
    }

    public boolean removeValue(Value value) {
        return this.m_values.remove(value);
    }

    public void setMatches(String matches) {
        this.m_matches = ConfigUtils.normalizeString(matches);
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.normalizeString(name);
    }

    public void setResult(String result) {
        this.m_result = ConfigUtils.assertNotEmpty(result, "result");
    }

    public void setType(String type) {
        this.m_type = ConfigUtils.assertNotEmpty(type, "type");
    }

    public void setValue(List<Value> values) {
        if (values == this.m_values) {
            return;
        }
        this.m_values.clear();
        if (values != null) {
            this.m_values.addAll(values);
        }
    }
}

