/*
 * Decompiled with CFR 0.152.
 */
package org.dhcp4java;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DHCPConstants {
    public static final byte BOOTREQUEST = 1;
    public static final byte BOOTREPLY = 2;
    public static final byte HTYPE_ETHER = 1;
    public static final byte HTYPE_IEEE802 = 6;
    public static final byte HTYPE_FDDI = 8;
    public static final byte HTYPE_IEEE1394 = 24;
    public static final byte DHCPDISCOVER = 1;
    public static final byte DHCPOFFER = 2;
    public static final byte DHCPREQUEST = 3;
    public static final byte DHCPDECLINE = 4;
    public static final byte DHCPACK = 5;
    public static final byte DHCPNAK = 6;
    public static final byte DHCPRELEASE = 7;
    public static final byte DHCPINFORM = 8;
    public static final byte DHCPFORCERENEW = 9;
    public static final byte DHCPLEASEQUERY = 10;
    public static final byte DHCPLEASEUNASSIGNED = 11;
    public static final byte DHCPLEASEUNKNOWN = 12;
    public static final byte DHCPLEASEACTIVE = 13;
    public static final byte DHO_PAD = 0;
    public static final byte DHO_SUBNET_MASK = 1;
    public static final byte DHO_TIME_OFFSET = 2;
    public static final byte DHO_ROUTERS = 3;
    public static final byte DHO_TIME_SERVERS = 4;
    public static final byte DHO_NAME_SERVERS = 5;
    public static final byte DHO_DOMAIN_NAME_SERVERS = 6;
    public static final byte DHO_LOG_SERVERS = 7;
    public static final byte DHO_COOKIE_SERVERS = 8;
    public static final byte DHO_LPR_SERVERS = 9;
    public static final byte DHO_IMPRESS_SERVERS = 10;
    public static final byte DHO_RESOURCE_LOCATION_SERVERS = 11;
    public static final byte DHO_HOST_NAME = 12;
    public static final byte DHO_BOOT_SIZE = 13;
    public static final byte DHO_MERIT_DUMP = 14;
    public static final byte DHO_DOMAIN_NAME = 15;
    public static final byte DHO_SWAP_SERVER = 16;
    public static final byte DHO_ROOT_PATH = 17;
    public static final byte DHO_EXTENSIONS_PATH = 18;
    public static final byte DHO_IP_FORWARDING = 19;
    public static final byte DHO_NON_LOCAL_SOURCE_ROUTING = 20;
    public static final byte DHO_POLICY_FILTER = 21;
    public static final byte DHO_MAX_DGRAM_REASSEMBLY = 22;
    public static final byte DHO_DEFAULT_IP_TTL = 23;
    public static final byte DHO_PATH_MTU_AGING_TIMEOUT = 24;
    public static final byte DHO_PATH_MTU_PLATEAU_TABLE = 25;
    public static final byte DHO_INTERFACE_MTU = 26;
    public static final byte DHO_ALL_SUBNETS_LOCAL = 27;
    public static final byte DHO_BROADCAST_ADDRESS = 28;
    public static final byte DHO_PERFORM_MASK_DISCOVERY = 29;
    public static final byte DHO_MASK_SUPPLIER = 30;
    public static final byte DHO_ROUTER_DISCOVERY = 31;
    public static final byte DHO_ROUTER_SOLICITATION_ADDRESS = 32;
    public static final byte DHO_STATIC_ROUTES = 33;
    public static final byte DHO_TRAILER_ENCAPSULATION = 34;
    public static final byte DHO_ARP_CACHE_TIMEOUT = 35;
    public static final byte DHO_IEEE802_3_ENCAPSULATION = 36;
    public static final byte DHO_DEFAULT_TCP_TTL = 37;
    public static final byte DHO_TCP_KEEPALIVE_INTERVAL = 38;
    public static final byte DHO_TCP_KEEPALIVE_GARBAGE = 39;
    public static final byte DHO_NIS_SERVERS = 41;
    public static final byte DHO_NTP_SERVERS = 42;
    public static final byte DHO_VENDOR_ENCAPSULATED_OPTIONS = 43;
    public static final byte DHO_NETBIOS_NAME_SERVERS = 44;
    public static final byte DHO_NETBIOS_DD_SERVER = 45;
    public static final byte DHO_NETBIOS_NODE_TYPE = 46;
    public static final byte DHO_NETBIOS_SCOPE = 47;
    public static final byte DHO_FONT_SERVERS = 48;
    public static final byte DHO_X_DISPLAY_MANAGER = 49;
    public static final byte DHO_DHCP_REQUESTED_ADDRESS = 50;
    public static final byte DHO_DHCP_LEASE_TIME = 51;
    public static final byte DHO_DHCP_OPTION_OVERLOAD = 52;
    public static final byte DHO_DHCP_MESSAGE_TYPE = 53;
    public static final byte DHO_DHCP_SERVER_IDENTIFIER = 54;
    public static final byte DHO_DHCP_PARAMETER_REQUEST_LIST = 55;
    public static final byte DHO_DHCP_MESSAGE = 56;
    public static final byte DHO_DHCP_MAX_MESSAGE_SIZE = 57;
    public static final byte DHO_DHCP_RENEWAL_TIME = 58;
    public static final byte DHO_DHCP_REBINDING_TIME = 59;
    public static final byte DHO_VENDOR_CLASS_IDENTIFIER = 60;
    public static final byte DHO_DHCP_CLIENT_IDENTIFIER = 61;
    public static final byte DHO_NWIP_DOMAIN_NAME = 62;
    public static final byte DHO_NWIP_SUBOPTIONS = 63;
    public static final byte DHO_NISPLUS_DOMAIN = 64;
    public static final byte DHO_NISPLUS_SERVER = 65;
    public static final byte DHO_TFTP_SERVER = 66;
    public static final byte DHO_BOOTFILE = 67;
    public static final byte DHO_MOBILE_IP_HOME_AGENT = 68;
    public static final byte DHO_SMTP_SERVER = 69;
    public static final byte DHO_POP3_SERVER = 70;
    public static final byte DHO_NNTP_SERVER = 71;
    public static final byte DHO_WWW_SERVER = 72;
    public static final byte DHO_FINGER_SERVER = 73;
    public static final byte DHO_IRC_SERVER = 74;
    public static final byte DHO_STREETTALK_SERVER = 75;
    public static final byte DHO_STDA_SERVER = 76;
    public static final byte DHO_USER_CLASS = 77;
    public static final byte DHO_FQDN = 81;
    public static final byte DHO_DHCP_AGENT_OPTIONS = 82;
    public static final byte DHO_NDS_SERVERS = 85;
    public static final byte DHO_NDS_TREE_NAME = 86;
    public static final byte DHO_NDS_CONTEXT = 87;
    public static final byte DHO_CLIENT_LAST_TRANSACTION_TIME = 91;
    public static final byte DHO_ASSOCIATED_IP = 92;
    public static final byte DHO_USER_AUTHENTICATION_PROTOCOL = 98;
    public static final byte DHO_AUTO_CONFIGURE = 116;
    public static final byte DHO_NAME_SERVICE_SEARCH = 117;
    public static final byte DHO_SUBNET_SELECTION = 118;
    public static final byte DHO_DOMAIN_SEARCH = 119;
    public static final byte DHO_CLASSLESS_ROUTE = 121;
    public static final byte DHO_END = -1;
    public static final InetAddress INADDR_ANY = DHCPConstants.getInaddrAny();
    public static final InetAddress INADDR_BROADCAST = DHCPConstants.getInaddrBroadcast();
    static final int _DHCP_MIN_LEN = 548;
    static final int _DHCP_DEFAULT_MAX_LEN = 576;
    static final int _BOOTP_ABSOLUTE_MIN_LEN = 236;
    static final int _DHCP_MAX_MTU = 1500;
    static final int _DHCP_UDP_OVERHEAD = 42;
    static final int _BOOTP_VEND_SIZE = 64;
    static final int _MAGIC_COOKIE = 1669485411;
    public static final int BOOTP_REQUEST_PORT = 67;
    public static final int BOOTP_REPLY_PORT = 68;
    static final Map<Byte, String> _BOOT_NAMES;
    static final Map<Byte, String> _HTYPE_NAMES;
    static final Map<Byte, String> _DHCP_CODES;
    static final Map<Byte, String> _DHO_NAMES;
    static final Map<String, Byte> _DHO_NAMES_REV;

    private DHCPConstants() {
    }

    private static final InetAddress getInaddrAny() {
        try {
            byte[] byArray = new byte[]{0, 0, 0, 0};
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalStateException("Unable to generate INADDR_ANY");
        }
    }

    private static final InetAddress getInaddrBroadcast() {
        try {
            byte[] byArray = new byte[]{-1, -1, -1, -1};
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalStateException("Unable to generate INADDR_BROADCAST");
        }
    }

    public static final Map<Byte, String> getBootNamesMap() {
        return _BOOT_NAMES;
    }

    public static final Map<Byte, String> getHtypesMap() {
        return _HTYPE_NAMES;
    }

    public static final Map<Byte, String> getDhcpCodesMap() {
        return _DHCP_CODES;
    }

    public static final Map<Byte, String> getDhoNamesMap() {
        return _DHO_NAMES;
    }

    public static final Map<String, Byte> getDhoNamesReverseMap() {
        return _DHO_NAMES_REV;
    }

    public static final Byte getDhoNamesReverse(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return _DHO_NAMES_REV.get(string);
    }

    public static final String getDhoName(byte by) {
        return _DHO_NAMES.get(by);
    }

    static {
        LinkedHashMap<Byte, String> linkedHashMap = new LinkedHashMap<Byte, String>();
        LinkedHashMap<Byte, String> linkedHashMap2 = new LinkedHashMap<Byte, String>();
        LinkedHashMap<Byte, String> linkedHashMap3 = new LinkedHashMap<Byte, String>();
        LinkedHashMap<Byte, String> linkedHashMap4 = new LinkedHashMap<Byte, String>();
        LinkedHashMap<String, Byte> linkedHashMap5 = new LinkedHashMap<String, Byte>();
        Field[] fieldArray = DHCPConstants.class.getDeclaredFields();
        try {
            for (Field field : fieldArray) {
                int n = field.getModifiers();
                String string = field.getName();
                if (!Modifier.isFinal(n) || !Modifier.isPublic(n) || !Modifier.isStatic(n) || !field.getType().equals(Byte.TYPE)) continue;
                Byte by = field.getByte(null);
                if (string.startsWith("BOOT")) {
                    linkedHashMap.put(by, string);
                    continue;
                }
                if (string.startsWith("HTYPE_")) {
                    linkedHashMap2.put(by, string);
                    continue;
                }
                if (string.startsWith("DHCP")) {
                    linkedHashMap3.put(by, string);
                    continue;
                }
                if (!string.startsWith("DHO_")) continue;
                linkedHashMap4.put(by, string);
                linkedHashMap5.put(string, by);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Fatal error while parsing internal fields");
        }
        _BOOT_NAMES = Collections.unmodifiableMap(linkedHashMap);
        _HTYPE_NAMES = Collections.unmodifiableMap(linkedHashMap2);
        _DHCP_CODES = Collections.unmodifiableMap(linkedHashMap3);
        _DHO_NAMES = Collections.unmodifiableMap(linkedHashMap4);
        _DHO_NAMES_REV = Collections.unmodifiableMap(linkedHashMap5);
    }
}

