/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.BmpParser;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.Header;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.Packet;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerAccessor;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerFlags;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerHeader;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerInfo;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.TLV;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.mirroring.BgpMessage;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.mirroring.Information;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.mirroring.Mirroring;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.mirroring.Unknown;

public class RouteMirroringPacket
implements Packet {
    public final Header header;
    public final PeerHeader peerHeader;
    public final TLV.List<Element, Element.Type, Mirroring> elements;

    public RouteMirroringPacket(Header header, ByteBuf buffer, PeerAccessor peerAccessor) throws InvalidPacketException {
        this.header = Objects.requireNonNull(header);
        this.peerHeader = new PeerHeader(buffer);
        this.elements = TLV.List.wrap(BufferUtils.repeatRemaining((ByteBuf)buffer, elementBuffer -> new Element(elementBuffer, this.peerHeader.flags, peerAccessor.getPeerInfo(this.peerHeader))));
    }

    @Override
    public void accept(Packet.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <R> R map(Packet.Mapper<R> mapper) {
        return mapper.map(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("peerHeader", (Object)this.peerHeader).add("elements", this.elements).toString();
    }

    public static class Element
    extends TLV<Type, Mirroring, PeerFlags> {
        public Element(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
            super(buffer, x$0 -> Type.from(x$0), flags, peerInfo);
        }

        public static enum Type implements TLV.Type<Mirroring, PeerFlags>
        {
            BGP_MESSAGE{

                @Override
                public Mirroring parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new BgpMessage(buffer, flags, peerInfo);
                }
            }
            ,
            INFORMATION{

                @Override
                public Mirroring parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new Information(buffer, flags, peerInfo);
                }
            }
            ,
            UNKNOWN{

                @Override
                public Mirroring parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new Unknown(buffer, flags, peerInfo);
                }
            };


            private static Type from(int type) {
                switch (type) {
                    case 0: {
                        return BGP_MESSAGE;
                    }
                    case 1: {
                        return INFORMATION;
                    }
                }
                BmpParser.RATE_LIMITED_LOG.debug("Unknown Route Mirroring Packet Type: {}", (Object)type);
                return UNKNOWN;
            }
        }
    }
}

