/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.BmpParser;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerInfo;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.TLV;

public class InformationElement
extends TLV<Type, String, Void> {
    public InformationElement(ByteBuf buffer, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
        super(buffer, x$0 -> Type.from(x$0), null, peerInfo);
    }

    public static enum Type implements TLV.Type<String, Void>
    {
        STRING{

            @Override
            public String parse(ByteBuf buffer, Void parameter, Optional<PeerInfo> peerInfo) {
                return new String(BufferUtils.bytes((ByteBuf)buffer, (int)buffer.readableBytes()), StandardCharsets.UTF_8);
            }
        }
        ,
        SYS_DESCR{

            @Override
            public String parse(ByteBuf buffer, Void parameter, Optional<PeerInfo> peerInfo) {
                return new String(BufferUtils.bytes((ByteBuf)buffer, (int)buffer.readableBytes()), StandardCharsets.US_ASCII);
            }
        }
        ,
        SYS_NAME{

            @Override
            public String parse(ByteBuf buffer, Void parameter, Optional<PeerInfo> peerInfo) {
                return new String(BufferUtils.bytes((ByteBuf)buffer, (int)buffer.readableBytes()), StandardCharsets.US_ASCII);
            }
        }
        ,
        VRF_TABLE_NAME{

            @Override
            public String parse(ByteBuf buffer, Void parameter, Optional<PeerInfo> peerInfo) {
                return new String(BufferUtils.bytes((ByteBuf)buffer, (int)buffer.readableBytes()), StandardCharsets.US_ASCII);
            }
        }
        ,
        ADMIN_LABEL{

            @Override
            public String parse(ByteBuf buffer, Void parameter, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                return new String(BufferUtils.bytes((ByteBuf)buffer, (int)buffer.readableBytes()), StandardCharsets.UTF_8);
            }
        }
        ,
        BGP_ID{

            @Override
            public String parse(ByteBuf buffer, Void parameter, Optional<PeerInfo> peerInfo) {
                return InetAddressUtils.toIpAddrString((byte[])BufferUtils.bytes((ByteBuf)buffer, (int)buffer.readableBytes()));
            }
        }
        ,
        UNKNOWN{

            @Override
            public String parse(ByteBuf buffer, Void parameter, Optional<PeerInfo> peerInfo) {
                return "Unknown";
            }
        };


        private static Type from(int type) {
            switch (type) {
                case 0: {
                    return STRING;
                }
                case 1: {
                    return SYS_DESCR;
                }
                case 2: {
                    return SYS_NAME;
                }
                case 3: {
                    return VRF_TABLE_NAME;
                }
                case 4: {
                    return ADMIN_LABEL;
                }
                case 65531: {
                    return BGP_ID;
                }
            }
            BmpParser.RATE_LIMITED_LOG.debug("Unknown Information Element Type: {}", (Object)type);
            return UNKNOWN;
        }
    }
}

