/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.registry.impl;

import com.codahale.metrics.MetricRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.netmgt.telemetry.api.adapter.Adapter;
import org.opennms.netmgt.telemetry.api.receiver.Listener;
import org.opennms.netmgt.telemetry.api.receiver.Parser;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.api.registry.TelemetryRegistry;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.config.api.ListenerDefinition;
import org.opennms.netmgt.telemetry.config.api.PackageDefinition;
import org.opennms.netmgt.telemetry.config.api.ParserDefinition;
import org.opennms.netmgt.telemetry.protocols.registry.api.TelemetryServiceRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class TelemetryRegistryImpl
implements TelemetryRegistry {
    @Autowired
    @Qualifier(value="adapterRegistry")
    private TelemetryServiceRegistry<AdapterDefinition, Adapter> adapterRegistryDelegate;
    @Autowired
    @Qualifier(value="listenerRegistry")
    private TelemetryServiceRegistry<ListenerDefinition, Listener> listenerRegistryDelegate;
    @Autowired
    @Qualifier(value="parserRegistry")
    private TelemetryServiceRegistry<ParserDefinition, Parser> parserRegistryDelegate;
    private MetricRegistry metricRegistry;
    private final Map<String, AsyncDispatcher<TelemetryMessage>> dispatchers = new HashMap<String, AsyncDispatcher<TelemetryMessage>>();

    public Adapter getAdapter(AdapterDefinition adapterDefinition) {
        return this.adapterRegistryDelegate.getService(MutableAdapterDefinition.wrap(adapterDefinition));
    }

    public Listener getListener(ListenerDefinition listenerDefinition) {
        return this.listenerRegistryDelegate.getService(MutableListenerDefinition.wrap(listenerDefinition));
    }

    public Parser getParser(ParserDefinition parserDefinition) {
        return this.parserRegistryDelegate.getService(MutableParserDefinition.wrap(parserDefinition));
    }

    public void registerDispatcher(String queueName, AsyncDispatcher<TelemetryMessage> dispatcher) {
        if (this.dispatchers.containsKey(queueName)) {
            throw new IllegalArgumentException("A queue with name '" + queueName + "' is already registered");
        }
        this.dispatchers.put(queueName, dispatcher);
    }

    public void clearDispatchers() {
        this.dispatchers.clear();
    }

    public Collection<AsyncDispatcher<TelemetryMessage>> getDispatchers() {
        return this.dispatchers.values();
    }

    public AsyncDispatcher<TelemetryMessage> getDispatcher(String queueName) {
        return this.dispatchers.get(queueName);
    }

    public void removeDispatcher(String queueName) {
        this.dispatchers.remove(queueName);
    }

    public void setAdapterRegistryDelegate(TelemetryServiceRegistry<AdapterDefinition, Adapter> adapterRegistryDelegate) {
        this.adapterRegistryDelegate = adapterRegistryDelegate;
    }

    public void setListenerRegistryDelegate(TelemetryServiceRegistry<ListenerDefinition, Listener> listenerRegistryDelegate) {
        this.listenerRegistryDelegate = listenerRegistryDelegate;
    }

    public void setParserRegistryDelegate(TelemetryServiceRegistry<ParserDefinition, Parser> parserRegistryDelegate) {
        this.parserRegistryDelegate = parserRegistryDelegate;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    private static class MutableListenerDefinition
    implements ListenerDefinition {
        private final ListenerDefinition definition;
        private final Map<String, String> parameters;
        private final List<MutableParserDefinition> parsers;

        private MutableListenerDefinition(ListenerDefinition definition) {
            this.definition = Objects.requireNonNull(definition);
            this.parameters = new HashMap<String, String>(definition.getParameterMap());
            this.parsers = definition.getParsers().stream().map(x$0 -> new MutableParserDefinition((ParserDefinition)x$0)).collect(Collectors.toList());
        }

        public String getName() {
            return this.definition.getName();
        }

        public String getClassName() {
            return this.definition.getClassName();
        }

        public Map<String, String> getParameterMap() {
            return this.parameters;
        }

        public List<? extends ParserDefinition> getParsers() {
            return this.parsers;
        }

        public static MutableListenerDefinition wrap(ListenerDefinition definition) {
            if (definition instanceof MutableListenerDefinition) {
                return (MutableListenerDefinition)definition;
            }
            return new MutableListenerDefinition(definition);
        }
    }

    private static class MutableParserDefinition
    implements ParserDefinition {
        private final ParserDefinition definition;
        private final Map<String, String> parameters;

        private MutableParserDefinition(ParserDefinition definition) {
            this.definition = Objects.requireNonNull(definition);
            this.parameters = new HashMap<String, String>(definition.getParameterMap());
        }

        public String getName() {
            return this.definition.getName();
        }

        public String getClassName() {
            return this.definition.getClassName();
        }

        public Map<String, String> getParameterMap() {
            return this.parameters;
        }

        public String getQueueName() {
            return this.definition.getQueueName();
        }

        public static MutableParserDefinition wrap(ParserDefinition definition) {
            if (definition instanceof MutableParserDefinition) {
                return (MutableParserDefinition)definition;
            }
            return new MutableParserDefinition(definition);
        }
    }

    private static class MutableAdapterDefinition
    implements AdapterDefinition {
        private final AdapterDefinition definition;
        private final Map<String, String> parameters;

        private MutableAdapterDefinition(AdapterDefinition definition) {
            this.definition = Objects.requireNonNull(definition);
            this.parameters = new HashMap<String, String>(definition.getParameterMap());
        }

        public String getName() {
            return this.definition.getName();
        }

        public String getClassName() {
            return this.definition.getClassName();
        }

        public Map<String, String> getParameterMap() {
            return this.parameters;
        }

        public List<? extends PackageDefinition> getPackages() {
            return this.definition.getPackages();
        }

        public static MutableAdapterDefinition wrap(AdapterDefinition definition) {
            if (definition instanceof MutableAdapterDefinition) {
                return (MutableAdapterDefinition)definition;
            }
            return new MutableAdapterDefinition(definition);
        }
    }
}

