/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.core.utils.SocketUtils;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.support.ParameterSubstitutingMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public class SSLCertMonitor
extends ParameterSubstitutingMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(SSLCertMonitor.class);
    private static final int DEFAULT_PORT = -1;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final int DEFAULT_DAYS = 7;
    public static final String PARAMETER_PORT = "port";
    public static final String PARAMETER_DAYS = "days";
    public static final String PARAMETER_SERVER_NAME = "server-name";
    public static final String PARAMETER_STLS_INIT = "starttls-preamble";
    public static final String PARAMETER_STLS_INIT_RESP = "starttls-preamble-response";
    public static final String PARAMETER_STLS_START = "starttls-start";
    public static final String PARAMETER_STLS_START_RESP = "starttls-start-response";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)PARAMETER_PORT, (int)-1);
        if (port == -1) {
            throw new RuntimeException("Required parameter 'port' is not present in supplied properties.");
        }
        int validityDays = ParameterMap.getKeyedInteger(parameters, (String)PARAMETER_DAYS, (int)7);
        if (validityDays <= 0) {
            throw new RuntimeException("Required parameter 'days' must be a positive value.");
        }
        String serverName = PropertiesUtils.substitute((String)ParameterMap.getKeyedString(parameters, (String)PARAMETER_SERVER_NAME, (String)""), (Properties[])new Properties[]{SSLCertMonitor.getServiceProperties((MonitoredService)svc)});
        String stlsInitiate = PropertiesUtils.substitute((String)SSLCertMonitor.resolveKeyedString(parameters, PARAMETER_STLS_INIT, ""), (Properties[])new Properties[]{SSLCertMonitor.getServiceProperties((MonitoredService)svc)});
        String stlsInitExpectedResp = PropertiesUtils.substitute((String)SSLCertMonitor.resolveKeyedString(parameters, PARAMETER_STLS_INIT_RESP, ""), (Properties[])new Properties[]{SSLCertMonitor.getServiceProperties((MonitoredService)svc)});
        String tlsStart = PropertiesUtils.substitute((String)SSLCertMonitor.resolveKeyedString(parameters, PARAMETER_STLS_START, ""), (Properties[])new Properties[]{SSLCertMonitor.getServiceProperties((MonitoredService)svc)});
        String tlsStartResp = PropertiesUtils.substitute((String)SSLCertMonitor.resolveKeyedString(parameters, PARAMETER_STLS_START_RESP, ""), (Properties[])new Properties[]{SSLCertMonitor.getServiceProperties((MonitoredService)svc)});
        Calendar calValid = this.getCalendarInstance();
        Calendar calCurrent = this.getCalendarInstance();
        calValid.setTimeInMillis(calCurrent.getTimeInMillis());
        calValid.add(5, validityDays);
        Calendar calBefore = this.getCalendarInstance();
        Calendar calAfter = this.getCalendarInstance();
        InetAddress ipAddr = svc.getAddress();
        String hostAddress = InetAddressUtils.str((InetAddress)ipAddr);
        LOG.debug("poll: address={}, port={}, serverName={}, {}", new Object[]{hostAddress, port, serverName, tracker});
        PollStatus serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            block45: {
                String reason;
                Socket socket = null;
                BufferedReader r = null;
                BufferedWriter wr = null;
                try {
                    boolean stlsSupported;
                    tracker.startAttempt();
                    socket = new Socket();
                    socket.connect(new InetSocketAddress(ipAddr, port), tracker.getConnectionTimeout());
                    socket.setSoTimeout(tracker.getSoTimeout());
                    r = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    wr = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                    LOG.debug("Connected to host: {} on port: {}", (Object)ipAddr, (Object)port);
                    serviceStatus = PollStatus.unresponsive();
                    boolean bl = stlsSupported = SocketUtils.validResponse((String)stlsInitiate, (String)stlsInitExpectedResp, (BufferedReader)r, (Writer)wr) && SocketUtils.validResponse((String)tlsStart, (String)tlsStartResp, (BufferedReader)r, (Writer)wr);
                    if (!stlsSupported) {
                        PollStatus pollStatus = serviceStatus = PollStatus.unavailable((String)"STARTTLS requested, but server does not support STARTTLS.");
                        return pollStatus;
                    }
                    SSLSocket sslSocket = SocketUtils.wrapSocketInSslContext((Socket)socket, null, null);
                    if (!Strings.isNullOrEmpty((String)serverName)) {
                        SSLParameters sslParameters = sslSocket.getSSLParameters();
                        sslParameters.setServerNames((List<SNIServerName>)ImmutableList.of((Object)new SNIHostName(serverName)));
                        sslSocket.setSSLParameters(sslParameters);
                        if (!new StrictHostnameVerifier().verify(serverName, sslSocket.getSession())) {
                            serviceStatus = PollStatus.unavailable((String)"Host name verification failed - certificate common name is invalid");
                            break block45;
                        }
                    }
                    Certificate[] certs = sslSocket.getSession().getPeerCertificates();
                    for (int i = 0; i < certs.length && !serviceStatus.isAvailable(); ++i) {
                        if (!(certs[i] instanceof X509Certificate)) continue;
                        X509Certificate certx = (X509Certificate)certs[i];
                        LOG.debug("Checking validity against dates: [current: {}, valid: {}], NotBefore: {}, NotAfter: {}", new Object[]{calCurrent.getTime(), calValid.getTime(), certx.getNotBefore(), certx.getNotAfter()});
                        calBefore.setTime(certx.getNotBefore());
                        calAfter.setTime(certx.getNotAfter());
                        if (calCurrent.before(calBefore)) {
                            LOG.debug("Certificate is invalid, current time is before start time");
                            serviceStatus = PollStatus.unavailable((String)"Certificate is invalid, current time is before start time");
                        } else if (calCurrent.before(calAfter)) {
                            if (calValid.before(calAfter)) {
                                LOG.debug("Certificate is valid, and does not expire before validity check date");
                                serviceStatus = PollStatus.available((Double)tracker.elapsedTimeInMillis());
                            } else {
                                String reason2 = "Certificate is valid, but will expire within " + validityDays + " days (" + certx.getNotAfter() + ").";
                                LOG.debug(reason2);
                                serviceStatus = PollStatus.unavailable((String)reason2);
                            }
                        } else {
                            LOG.debug("Certificate has expired.");
                            serviceStatus = PollStatus.unavailable((String)"Certificate has expired.");
                        }
                        break;
                    }
                }
                catch (NoRouteToHostException e) {
                    reason = "No route to host exception for address " + hostAddress;
                    LOG.debug(reason, (Throwable)e);
                    serviceStatus = PollStatus.unavailable((String)reason);
                    break;
                }
                catch (InterruptedIOException e) {
                    reason = "did not connect to host with " + tracker;
                    LOG.debug(reason);
                    serviceStatus = PollStatus.unavailable((String)reason);
                }
                catch (ConnectException e) {
                    reason = "Connection exception for address: " + ipAddr;
                    LOG.debug(reason, (Throwable)e);
                    serviceStatus = PollStatus.unavailable((String)reason);
                }
                catch (IOException e) {
                    reason = "IOException while polling address: " + ipAddr;
                    LOG.debug(reason, (Throwable)e);
                    serviceStatus = PollStatus.unavailable((String)reason);
                }
                finally {
                    try {
                        if (r != null) {
                            r.close();
                        }
                        if (wr != null) {
                            wr.close();
                        }
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        e.fillInStackTrace();
                        LOG.debug("poll: Error closing socket.", (Throwable)e);
                    }
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }

    protected Calendar getCalendarInstance() {
        return GregorianCalendar.getInstance();
    }
}

