/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.offheap;

import com.google.common.annotations.VisibleForTesting;
import com.squareup.tape2.QueueFile;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.core.ipc.sink.api.DispatchQueue;
import org.opennms.core.ipc.sink.api.WriteFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueFileOffHeapDispatchQueue<T>
implements DispatchQueue<T> {
    private static final Logger LOG = LoggerFactory.getLogger(QueueFileOffHeapDispatchQueue.class);
    private final RateLimitedLog RATE_LIMITED_LOGGER = RateLimitedLog.withRateLimit((Logger)LOG).maxRate(5).every(Duration.ofSeconds(30L)).build();
    private static final int SERIALIZED_OBJECT_HEADER_SIZE_IN_BYTES = 4;
    private static final String FILE_EXTENSION = ".fifo";
    private final Function<T, byte[]> serializer;
    private final Function<byte[], T> deserializer;
    private final String moduleName;
    private final BlockingQueue<Map.Entry<String, T>> inMemoryQueue;
    private final QueueFile offHeapQueue;
    private final long maxFileSizeInBytes;
    private final int batchSize;
    private final Batch batch;
    private final ForkJoinPool serdesPool = new ForkJoinPool(Math.max(Runtime.getRuntime().availableProcessors() - 1, 1));
    private final Lock offHeapLock = new ReentrantLock(true);
    private final Lock enqueueLock = new ReentrantLock(true);
    private final FileCapacityLatch fileCapacityLatch = new FileCapacityLatch();
    private final Method usedBytesMethod;

    public QueueFileOffHeapDispatchQueue(Function<T, byte[]> serializer, Function<byte[], T> deserializer, String moduleName, Path filePath, int inMemoryQueueSize, int batchSize, long maxFileSizeInBytes) throws IOException {
        Objects.requireNonNull(serializer);
        Objects.requireNonNull(deserializer);
        Objects.requireNonNull(moduleName);
        if (inMemoryQueueSize < 1) {
            throw new IllegalArgumentException("In memory queue size must be greater than 0");
        }
        if (inMemoryQueueSize % batchSize != 0) {
            throw new IllegalArgumentException("In memory queue size must be a multiple of batch size");
        }
        if (maxFileSizeInBytes < 0L) {
            throw new IllegalArgumentException("Max file size must be either 0 or a positive integer");
        }
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.moduleName = moduleName;
        this.batchSize = batchSize;
        this.maxFileSizeInBytes = maxFileSizeInBytes;
        this.batch = new Batch(batchSize);
        this.inMemoryQueue = new ArrayBlockingQueue<Map.Entry<String, T>>(inMemoryQueueSize, true);
        if (maxFileSizeInBytes > 0L) {
            QueueFile qf;
            Objects.requireNonNull(filePath);
            File file = Paths.get(filePath.toString(), moduleName + FILE_EXTENSION).toFile();
            try {
                qf = new QueueFile.Builder(file).build();
            }
            catch (Exception e) {
                LOG.warn("Exception while loading queue file", (Throwable)e);
                if (file.delete()) {
                    qf = new QueueFile.Builder(file).build();
                }
                throw new IOException("Could not delete corrupted queue file " + file.getAbsolutePath());
            }
            this.offHeapQueue = qf;
            try {
                this.usedBytesMethod = this.offHeapQueue.getClass().getDeclaredMethod("usedBytes", new Class[0]);
                this.usedBytesMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                LOG.warn("Could not instantiate queue", (Throwable)e);
                throw new RuntimeException(e);
            }
            this.checkFileSize();
        } else {
            this.offHeapQueue = null;
            this.usedBytesMethod = null;
        }
    }

    @VisibleForTesting
    public long checkFileSize() {
        try {
            long fileSize = (Long)this.usedBytesMethod.invoke((Object)this.offHeapQueue, new Object[0]);
            this.fileCapacityLatch.setCurrentCapacityBytes(this.maxFileSizeInBytes - fileSize);
            LOG.trace("Checked file size for module {} and got result {} bytes", (Object)this.moduleName, (Object)fileSize);
            return fileSize;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.RATE_LIMITED_LOGGER.warn("Failed to check file size for module {}", (Object)this.moduleName, (Object)e);
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DispatchQueue.EnqueueResult enqueue(T message, String key) throws WriteFailedException {
        this.enqueueLock.lock();
        try {
            byte[] serializedBatch;
            int size;
            block27: {
                AbstractMap.SimpleImmutableEntry<String, T> msgEntry = new AbstractMap.SimpleImmutableEntry<String, T>(key, message);
                LOG.trace("Attempting to enqueue {} with key {} into queue with current size {}", new Object[]{message, key, this.getSize()});
                if (this.offHeapQueue == null) {
                    LOG.trace("Enqueueing {} with key {} in-memory since there is no off-heap queue configured", message, (Object)key);
                    try {
                        this.inMemoryQueue.put(msgEntry);
                    }
                    catch (InterruptedException e) {
                        throw new WriteFailedException((Throwable)e);
                    }
                    DispatchQueue.EnqueueResult e = DispatchQueue.EnqueueResult.IMMEDIATE;
                    return e;
                }
                size = 0;
                serializedBatch = null;
                this.offHeapLock.lock();
                try {
                    boolean inMemoryQueueHadSpace;
                    if (this.offHeapQueue.size() <= 0 && this.batch.isEmpty() && (inMemoryQueueHadSpace = this.inMemoryQueue.offer(msgEntry))) {
                        LOG.trace("Enqueueing {} with key {} in-memory", message, (Object)key);
                        DispatchQueue.EnqueueResult enqueueResult = DispatchQueue.EnqueueResult.IMMEDIATE;
                        return enqueueResult;
                    }
                    LOG.trace("Batching message {} with key {} for off-heap queue", message, (Object)key);
                    this.batch.add(message);
                    if (!this.batch.isFull()) break block27;
                    LOG.trace("Flushing batch off-heap");
                    try {
                        serializedBatch = this.batch.toSerializedBatchAndClear();
                    }
                    catch (Exception e) {
                        this.RATE_LIMITED_LOGGER.warn("Failed to flush to off-heap", (Throwable)e);
                        throw new WriteFailedException((Throwable)e);
                    }
                    size = serializedBatch.length + 4;
                    this.fileCapacityLatch.markFlushNeeded();
                }
                finally {
                    this.offHeapLock.unlock();
                }
            }
            if (serializedBatch != null) {
                try {
                    this.fileCapacityLatch.waitForCapacity(size);
                    this.offHeapLock.lock();
                    if (!this.fileCapacityLatch.isFlushNeeded()) {
                        DispatchQueue.EnqueueResult e = DispatchQueue.EnqueueResult.DEFERRED;
                        this.offHeapLock.unlock();
                        return e;
                    }
                    try {
                        this.offHeapQueue.add(serializedBatch);
                        this.checkFileSize();
                    }
                    catch (IOException e) {
                        throw new WriteFailedException((Throwable)e);
                    }
                }
                catch (InterruptedException e) {
                    throw new WriteFailedException((Throwable)e);
                }
            }
            DispatchQueue.EnqueueResult enqueueResult = DispatchQueue.EnqueueResult.DEFERRED;
            return enqueueResult;
        }
        finally {
            this.enqueueLock.unlock();
        }
    }

    public Map.Entry<String, T> dequeue() throws InterruptedException {
        block10: {
            LOG.debug("Dequeueing an entry from queue with current size {}", (Object)this.getSize());
            if (this.offHeapQueue != null) {
                this.offHeapLock.lock();
                try {
                    if (this.offHeapQueue.size() > 0 && this.inMemoryQueue.remainingCapacity() >= this.batchSize) {
                        LOG.trace("Found an entry off-heap and there was room in-memory, moving it");
                        try {
                            byte[] entry = this.offHeapQueue.peek();
                            if (entry == null) break block10;
                            this.offHeapQueue.remove();
                            try {
                                this.inMemoryQueue.addAll(this.unbatchSerializedBatch(new SerializedBatch(entry)));
                            }
                            catch (ExecutionException e) {
                                this.RATE_LIMITED_LOGGER.warn("Exception while deserializing", (Throwable)e);
                                throw new RuntimeException(e);
                            }
                            this.checkFileSize();
                            break block10;
                        }
                        catch (IOException e) {
                            this.RATE_LIMITED_LOGGER.warn("Exception while dequeueing", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                    }
                    if (!this.batch.isEmpty() && this.offHeapQueue.isEmpty() && this.inMemoryQueue.remainingCapacity() >= this.batch.size()) {
                        LOG.trace("Found an entry in batch and there was room in-memory, moving it");
                        this.inMemoryQueue.addAll(this.batch.unbatch());
                        this.fileCapacityLatch.cancelFlush();
                    }
                }
                finally {
                    this.offHeapLock.unlock();
                }
            }
        }
        LOG.trace("Waiting for an entry from in-memory queue...");
        return this.inMemoryQueue.take();
    }

    public boolean isFull() {
        if (this.offHeapQueue == null) {
            int remaining = this.inMemoryQueue.remainingCapacity();
            LOG.trace("Checked if full and remaining capacity is {}", (Object)remaining);
            return remaining <= 0;
        }
        return this.fileCapacityLatch.isFull();
    }

    public int getSize() {
        if (this.offHeapQueue == null) {
            return this.inMemoryQueue.size();
        }
        this.offHeapLock.lock();
        try {
            int n = this.inMemoryQueue.size() + this.offHeapQueue.size() * this.batchSize + this.batch.size();
            return n;
        }
        finally {
            this.offHeapLock.unlock();
        }
    }

    private List<Map.Entry<String, T>> unbatchSerializedBatch(SerializedBatch serializedBatch) throws ExecutionException, InterruptedException {
        Batch deserializedBatch = new Batch(this.batchSize);
        ((List)((ForkJoinTask)this.serdesPool.submit(() -> serializedBatch.batchedMessages.parallelStream().map(this.deserializer).collect(Collectors.toList()))).get()).forEach(deserializedBatch::add);
        return deserializedBatch.unbatch();
    }

    private final class Batch {
        private final List<T> batchedMessages;
        private final int batchSize;

        Batch(int batchSize) {
            this.batchSize = batchSize;
            this.batchedMessages = new ArrayList(batchSize);
        }

        void add(T message) {
            if (this.batchedMessages.size() >= this.batchSize) {
                throw new IllegalStateException("Attempted to add a message while the batch was full");
            }
            this.batchedMessages.add(message);
        }

        List<Map.Entry<String, T>> unbatch() {
            ArrayList messages = new ArrayList(this.batchSize);
            this.batchedMessages.forEach(msg -> messages.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(null, msg)));
            this.batchedMessages.clear();
            return messages;
        }

        boolean isEmpty() {
            return this.batchedMessages.isEmpty();
        }

        boolean isFull() {
            return this.batchedMessages.size() == this.batchSize;
        }

        int size() {
            return this.batchedMessages.size();
        }

        byte[] toSerializedBatchAndClear() throws IOException, ExecutionException, InterruptedException {
            List serializedMessages = (List)((ForkJoinTask)QueueFileOffHeapDispatchQueue.this.serdesPool.submit(() -> this.batchedMessages.parallelStream().map(QueueFileOffHeapDispatchQueue.this.serializer).collect(Collectors.toList()))).get();
            byte[] serializedBatch = new SerializedBatch(serializedMessages).toBytes();
            this.batchedMessages.clear();
            return serializedBatch;
        }
    }

    private static final class SerializedBatch
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<byte[]> batchedMessages = new ArrayList<byte[]>();

        SerializedBatch(List<byte[]> messages) {
            this.batchedMessages.addAll(messages);
        }

        SerializedBatch(byte[] bytes) throws IOException {
            try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                 ObjectInputStream in = new ObjectInputStream(bis);){
                try {
                    this.batchedMessages.addAll(((SerializedBatch)in.readObject()).batchedMessages);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        /*
         * Exception decompiling
         */
        byte[] toBytes() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private final class FileCapacityLatch {
        private boolean isFull = false;
        private long currentCapacityBytes = Long.MAX_VALUE;
        private boolean flushNeeded = false;

        private FileCapacityLatch() {
        }

        public synchronized void waitForCapacity(long capacityNeededBytes) throws InterruptedException {
            while (this.currentCapacityBytes < capacityNeededBytes && this.flushNeeded) {
                this.markFull();
                LOG.trace("Waiting for capacity... Need {} bytes but current capacity is {} bytes", (Object)capacityNeededBytes, (Object)this.currentCapacityBytes);
                this.wait();
            }
            this.markNotFull();
        }

        public synchronized void setCurrentCapacityBytes(long currentCapacityBytes) {
            this.currentCapacityBytes = currentCapacityBytes;
            this.notifyAll();
        }

        private void markFull() {
            if (!this.isFull) {
                QueueFileOffHeapDispatchQueue.this.RATE_LIMITED_LOGGER.info("Off heap file for module {} is now full", (Object)QueueFileOffHeapDispatchQueue.this.moduleName);
                this.isFull = true;
            }
        }

        private void markNotFull() {
            if (this.isFull) {
                QueueFileOffHeapDispatchQueue.this.RATE_LIMITED_LOGGER.info("Off heap file for module {} is no longer full", (Object)QueueFileOffHeapDispatchQueue.this.moduleName);
                this.isFull = false;
            }
        }

        public synchronized boolean isFull() {
            return this.isFull;
        }

        public synchronized void markFlushNeeded() {
            this.flushNeeded = true;
        }

        public synchronized void cancelFlush() {
            this.flushNeeded = false;
            this.notifyAll();
        }

        public synchronized boolean isFlushNeeded() {
            return this.flushNeeded;
        }
    }
}

