/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.common.kafka;

import java.util.Properties;
import org.opennms.core.sysprops.SystemProperties;

public interface KafkaRpcConstants {
    public static final String KAFKA_RPC_CONFIG_PID = "org.opennms.core.ipc.rpc.kafka";
    public static final String KAFKA_RPC_CONFIG_SYS_PROP_PREFIX = "org.opennms.core.ipc.rpc.kafka.";
    public static final String RPC_TOPIC_PREFIX = "rpc";
    public static final String RPC_REQUEST_TOPIC_NAME = "rpc-request";
    public static final String RPC_RESPONSE_TOPIC_NAME = "rpc-response";
    public static final String SINGLE_TOPIC_FOR_ALL_MODULES = "single-topic";
    public static final int MAX_BUFFER_SIZE_CONFIGURED = 921600;
    public static final String MAX_BUFFER_SIZE_PROPERTY = "max.buffer.size";
    public static final Integer MAX_BUFFER_SIZE = Math.min(921600, SystemProperties.getInteger((String)String.format("%s%s", "org.opennms.core.ipc.rpc.kafka.", "max.buffer.size"), (int)921600));
    public static final long DEFAULT_TTL_CONFIGURED = 20000L;
    public static final String DEFAULT_TTL_PROPERTY = "ttl";
    public static final long DEFAULT_TTL = SystemProperties.getLong((String)String.format("%s%s", "org.opennms.core.ipc.rpc.kafka.", "ttl"), (Long)20000L);

    public static int getBufferSize(int messageSize, int maxBufferSize, int chunk) {
        int bufferSize = messageSize;
        if (messageSize > maxBufferSize) {
            int remaining = messageSize - chunk * maxBufferSize;
            bufferSize = remaining > maxBufferSize ? maxBufferSize : remaining;
        }
        return bufferSize;
    }

    public static int getMaxBufferSize(Properties properties) {
        int maxBufferSize = 921600;
        try {
            maxBufferSize = Math.min(921600, Integer.parseInt(properties.getProperty(MAX_BUFFER_SIZE_PROPERTY)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return maxBufferSize;
    }
}

