/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.LargeFloatingSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.SmallFloatingSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;

public class MapType
extends AbstractPrimitiveType<Map> {
    private final MapEncoding _mapEncoding;
    private final MapEncoding _shortMapEncoding;
    private EncoderImpl _encoder;

    MapType(EncoderImpl encoder, DecoderImpl decoder) {
        this._encoder = encoder;
        this._mapEncoding = new AllMapEncoding(encoder, decoder);
        this._shortMapEncoding = new ShortMapEncoding(encoder, decoder);
        encoder.register(Map.class, this);
        decoder.register(this);
    }

    @Override
    public Class<Map> getTypeClass() {
        return Map.class;
    }

    public MapEncoding getEncoding(Map val) {
        int calculatedSize = MapType.calculateSize(val, this._encoder);
        MapEncoding encoding = val.size() > 127 || calculatedSize >= 254 ? this._mapEncoding : this._shortMapEncoding;
        encoding.setValue(val, calculatedSize);
        return encoding;
    }

    private static int calculateSize(Map val, EncoderImpl encoder) {
        int len = 0;
        for (Map.Entry element : val.entrySet()) {
            TypeEncoding<Object> elementEncoding = encoder.getType(element.getKey()).getEncoding(element.getKey());
            len += elementEncoding.getConstructorSize() + elementEncoding.getValueSize(element.getKey());
            elementEncoding = encoder.getType(element.getValue()).getEncoding(element.getValue());
            len += elementEncoding.getConstructorSize() + elementEncoding.getValueSize(element.getValue());
        }
        return len;
    }

    public MapEncoding getCanonicalEncoding() {
        return this._mapEncoding;
    }

    @Override
    public Collection<MapEncoding> getAllEncodings() {
        return Arrays.asList(this._shortMapEncoding, this._mapEncoding);
    }

    private class ShortMapEncoding
    extends SmallFloatingSizePrimitiveTypeEncoding<Map>
    implements MapEncoding {
        private Map _value;
        private int _length;

        public ShortMapEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected void writeEncodedValue(Map val) {
            this.getEncoder().writeRaw((byte)(2 * val.size()));
            for (Map.Entry element : val.entrySet()) {
                TypeEncoding<Object> elementEncoding = this.getEncoder().getType(element.getKey()).getEncoding(element.getKey());
                elementEncoding.writeConstructor();
                elementEncoding.writeValue(element.getKey());
                elementEncoding = this.getEncoder().getType(element.getValue()).getEncoding(element.getValue());
                elementEncoding.writeConstructor();
                elementEncoding.writeValue(element.getValue());
            }
        }

        @Override
        protected int getEncodedValueSize(Map val) {
            return 1 + (val == this._value ? this._length : MapType.calculateSize(val, this.getEncoder()));
        }

        @Override
        public byte getEncodingCode() {
            return -63;
        }

        public MapType getType() {
            return MapType.this;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Map> encoder) {
            return encoder == this;
        }

        @Override
        public Map readValue() {
            DecoderImpl decoder = this.getDecoder();
            int size2 = decoder.readRawByte() & 0xFF;
            int count = decoder.readRawByte() & 0xFF;
            LinkedHashMap<Object, Object> map2 = new LinkedHashMap<Object, Object>(count);
            for (int i = 0; i < count; ++i) {
                Object key = decoder.readObject();
                ++i;
                Object value = decoder.readObject();
                map2.put(key, value);
            }
            return map2;
        }

        @Override
        public void setValue(Map value, int length) {
            this._value = value;
            this._length = length;
        }
    }

    private class AllMapEncoding
    extends LargeFloatingSizePrimitiveTypeEncoding<Map>
    implements MapEncoding {
        private Map _value;
        private int _length;

        public AllMapEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected void writeEncodedValue(Map val) {
            this.getEncoder().writeRaw(2 * val.size());
            for (Map.Entry element : val.entrySet()) {
                TypeEncoding<Object> elementEncoding = this.getEncoder().getType(element.getKey()).getEncoding(element.getKey());
                elementEncoding.writeConstructor();
                elementEncoding.writeValue(element.getKey());
                elementEncoding = this.getEncoder().getType(element.getValue()).getEncoding(element.getValue());
                elementEncoding.writeConstructor();
                elementEncoding.writeValue(element.getValue());
            }
        }

        @Override
        protected int getEncodedValueSize(Map val) {
            return 4 + (val == this._value ? this._length : MapType.calculateSize(val, this.getEncoder()));
        }

        @Override
        public byte getEncodingCode() {
            return -47;
        }

        public MapType getType() {
            return MapType.this;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Map> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Map readValue() {
            DecoderImpl decoder = this.getDecoder();
            int size2 = decoder.readRawInt();
            int count = decoder.readRawInt();
            if (count > decoder.getByteBufferRemaining()) {
                throw new IllegalArgumentException("Map element count " + count + " is specified to be greater than the amount of data available (" + decoder.getByteBufferRemaining() + ")");
            }
            LinkedHashMap<Object, Object> map2 = new LinkedHashMap<Object, Object>(count);
            for (int i = 0; i < count; ++i) {
                Object key = decoder.readObject();
                ++i;
                Object value = decoder.readObject();
                map2.put(key, value);
            }
            return map2;
        }

        @Override
        public void setValue(Map value, int length) {
            this._value = value;
            this._length = length;
        }
    }

    private static interface MapEncoding
    extends PrimitiveTypeEncoding<Map> {
        public void setValue(Map var1, int var2);
    }
}

