/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.common.kafka;

import java.util.Properties;
import org.opennms.core.health.api.Context;
import org.opennms.core.health.api.HealthCheck;
import org.opennms.core.health.api.Response;
import org.opennms.core.health.api.Status;
import org.opennms.core.ipc.common.kafka.KafkaConfigProvider;
import org.opennms.core.ipc.common.kafka.Utils;

public class KafkaHealthCheck
implements HealthCheck {
    private KafkaConfigProvider kafkaConfigProvider;
    private final String type;

    public KafkaHealthCheck(KafkaConfigProvider kafkaConfigProvider, String type) {
        this.kafkaConfigProvider = kafkaConfigProvider;
        this.type = type;
    }

    public String getDescription() {
        return "Connecting to Kafka from " + this.type;
    }

    public Response perform(Context context) throws Exception {
        Properties kafkaConfig = this.kafkaConfigProvider.getProperties();
        int timeout = Math.toIntExact(context.getTimeout());
        kafkaConfig.put("request.timeout.ms", (Object)timeout);
        try {
            Utils.getTopics(kafkaConfig);
            return new Response(Status.Success);
        }
        catch (Exception e) {
            return new Response(e);
        }
    }
}

