/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.jms;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.opennms.netmgt.provision.DetectRequest;
import org.opennms.netmgt.provision.support.AgentBasedSyncAbstractDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQDetector
extends AgentBasedSyncAbstractDetector<URI> {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQDetector.class);
    private static final String DEFAULT_SERVICE_NAME = "ActiveMQ";
    private static final String DEFAULT_BROKERURL = "vm://localhost?create=false";
    private String m_brokerURL;
    private String m_user;
    private String m_password;
    private Boolean m_useNodeLabel;
    private final ActiveMQConnectionFactory m_connectionFactory;
    private Connection m_connection;
    private Session m_session;

    public ActiveMQDetector() {
        super(DEFAULT_SERVICE_NAME, 0);
        this.setBrokerURL(DEFAULT_BROKERURL);
        this.m_connectionFactory = new ActiveMQConnectionFactory();
        this.m_connection = null;
        this.m_session = null;
    }

    public ActiveMQDetector(String serviceName, int port) {
        super(serviceName, port);
        this.setBrokerURL(DEFAULT_BROKERURL);
        this.m_connectionFactory = new ActiveMQConnectionFactory();
        this.m_connection = null;
        this.m_session = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URI getAgentConfig(DetectRequest request) {
        LOG.debug("getAgentConfig(request=[{}]", (Object)request);
        URI uri = null;
        try {
            uri = new URI(this.m_brokerURL);
            Map map = request.getRuntimeAttributes();
            LOG.info("runtimeAttributes: {}", (Object)map);
            if (map == null) return uri;
        }
        catch (URISyntaxException e) {
            LOG.error("Invalid BrokerURL: {}", (Object)this.m_brokerURL, (Object)e);
        }
        return uri;
    }

    public boolean isServiceDetected(InetAddress address, URI agentConfig) {
        LOG.debug("isServiceDetected(address=[{}], agentConfig=[{}])", (Object)address, (Object)agentConfig);
        try {
            this.m_connectionFactory.setBrokerURL(agentConfig.toString());
            this.m_connection = this.m_connectionFactory.createConnection(this.m_user, this.m_password);
            LOG.info("connection created");
            this.m_session = this.m_connection.createSession(false, 1);
            LOG.info("session created");
            this.m_connection.start();
            LOG.info("connection started");
            return true;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    protected void onInit() {
    }

    public void dispose() {
        if (this.m_session != null) {
            try {
                this.m_session.close();
            }
            catch (JMSException e) {
                LOG.debug("JMSException while closing the session.", (Throwable)e);
            }
            this.m_session = null;
        }
        if (this.m_connection != null) {
            try {
                this.m_connection.close();
            }
            catch (JMSException e) {
                LOG.debug("JMSException while closing the connection.", (Throwable)e);
            }
            this.m_connection = null;
        }
    }

    public String getBrokerURL() {
        return this.m_brokerURL;
    }

    public final void setBrokerURL(String brokerURL) {
        this.m_brokerURL = brokerURL;
    }

    public String getUser() {
        return this.m_user;
    }

    public final void setUser(String user) {
        this.m_user = user;
    }

    public String getPassword() {
        return this.m_password;
    }

    public final void setPassword(String password) {
        this.m_password = password;
    }

    public Boolean getUseNodeLabel() {
        return this.m_useNodeLabel;
    }

    public final void setUseNodeLabel(Boolean useNodeLabel) {
        this.m_useNodeLabel = useNodeLabel;
    }
}

