/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.InsufficientResourcesFault;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFound;
import com.vmware.vim25.ResourceConfigSpec;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.VRPEditSpec;
import com.vmware.vim25.VirtualResourcePoolSpec;
import com.vmware.vim25.VirtualResourcePoolUsage;
import com.vmware.vim25.mo.ClusterComputeResource;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ResourcePool;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;

public class VRPResourceManager
extends ManagedObject {
    public VRPResourceManager(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public String createVRP(VirtualResourcePoolSpec spec) throws InsufficientResourcesFault, InvalidState, RuntimeFault, RemoteException {
        return this.getVimService().createVRP(this.getMOR(), spec);
    }

    public void deleteVRP(String vrpId) throws InvalidState, NotFound, RuntimeFault, RemoteException {
        this.getVimService().deleteVRP(this.getMOR(), vrpId);
    }

    public void deployVM(String vrpId, VirtualMachine vm, ClusterComputeResource cluster) throws InsufficientResourcesFault, NotFound, InvalidState, RuntimeFault, RemoteException {
        this.getVimService().deployVM(this.getMOR(), vrpId, vm.getMOR(), cluster.getMOR());
    }

    public String[] getAllVRPIds() throws InvalidState, RuntimeFault, RemoteException {
        return this.getVimService().getAllVRPIds(this.getMOR());
    }

    public ResourcePool getChildRPforHub(String vrpId, ManagedEntity hub) throws InvalidState, NotFound, RuntimeFault, RemoteException {
        ManagedObjectReference rpMor = this.getVimService().getChildRPforHub(this.getMOR(), vrpId, hub.getMOR());
        return new ResourcePool(this.getServerConnection(), rpMor);
    }

    public ResourceConfigSpec getRPSettings(ResourcePool resourcePool) throws NotFound, RuntimeFault, RemoteException {
        return this.getVimService().getRPSettings(this.getMOR(), resourcePool.getMOR());
    }

    public String getVRPofVM(VirtualMachine vm) throws InvalidState, NotFound, RuntimeFault, RemoteException {
        return this.getVimService().getVRPofVM(this.getMOR(), vm.getMOR());
    }

    public VirtualResourcePoolSpec getVRPSettings(String vrpId) throws InvalidState, NotFound, RuntimeFault, RemoteException {
        return this.getVimService().getVRPSettings(this.getMOR(), vrpId);
    }

    public VirtualResourcePoolUsage getVRPUsage(String vrpId) throws InvalidState, NotFound, RuntimeFault, RemoteException {
        return this.getVimService().getVRPUsage(this.getMOR(), vrpId);
    }

    public void setManagedByVDC(ClusterComputeResource cluster, boolean status) throws InvalidState, NotFound, RuntimeFault, RemoteException {
        this.getVimService().setManagedByVDC(this.getMOR(), cluster.getMOR(), status);
    }

    public void undeployVM(String vrpId, VirtualMachine vm, ClusterComputeResource cluster) throws InvalidState, NotFound, RuntimeFault, RemoteException {
        this.getVimService().undeployVM(this.getMOR(), vrpId, vm.getMOR(), cluster.getMOR());
    }

    public void updateVRP(VRPEditSpec spec) throws InvalidState, NotFound, RuntimeFault, RemoteException, InsufficientResourcesFault {
        this.getVimService().updateVRP(this.getMOR(), spec);
    }
}

