/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import jcifs.netbios.NbtAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable(value={DistributionContext.DAEMON})
public final class SmbMonitor
extends AbstractServiceMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(SmbMonitor.class);
    private static final String DO_NODE_STATUS = "do-node-status";
    private static final boolean DO_NODE_STATUS_DEFAULT = true;

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        InetAddress ipAddr = svc.getAddress();
        PollStatus serviceStatus = PollStatus.unavailable();
        NbtAddress nbtAddr = null;
        String hostAddress = InetAddressUtils.str((InetAddress)ipAddr);
        boolean doNodeStatus = ParameterMap.getKeyedBoolean(parameters, (String)DO_NODE_STATUS, (boolean)true);
        try {
            nbtAddr = NbtAddress.getByName((String)hostAddress);
            if (doNodeStatus) {
                nbtAddr.getNodeType();
            }
            if (!nbtAddr.getHostName().equals(hostAddress)) {
                serviceStatus = PollStatus.available();
            }
        }
        catch (UnknownHostException uhE) {
            String reason = "Unknown host exception generated for " + hostAddress + ", reason: " + uhE.getLocalizedMessage();
            LOG.debug(reason);
            serviceStatus = PollStatus.unavailable((String)reason);
        }
        catch (RuntimeException rE) {
            LOG.debug("Unexpected runtime exception", (Throwable)rE);
            serviceStatus = PollStatus.unavailable((String)"Unexpected runtime exception");
        }
        catch (Throwable e) {
            LOG.debug("Unexpected exception", e);
            serviceStatus = PollStatus.unavailable((String)"Unexpected exception");
        }
        return serviceStatus;
    }
}

