/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMParameter;
import org.sblim.wbem.cim.CIMQualifiableElement;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.util.Utils;

public class CIMMethod
extends CIMQualifiableElement
implements Cloneable {
    private static final long serialVersionUID = -5943564359433173083L;
    private String iOriginClass = null;
    private String iOverridingMethod = null;
    private Vector iParameters = new Vector(0);
    private CIMDataType iType;
    private boolean iPropagated = false;

    public CIMMethod() {
    }

    public CIMMethod(String name) {
        super(name);
    }

    public Object clone() {
        return this.clone(true, true);
    }

    public Object clone(boolean pIncludeQualifier, boolean pIncludeClassOrigin) {
        Iterator iter;
        CIMMethod that = new CIMMethod(this.iName);
        if (pIncludeQualifier) {
            iter = this.iQualifiers.iterator();
            while (iter.hasNext()) {
                CIMQualifier qual = (CIMQualifier)iter.next();
                that.iQualifiers.add(qual.clone());
            }
        }
        if (pIncludeClassOrigin) {
            that.iOriginClass = this.iOriginClass;
        }
        that.iOverridingMethod = this.iOverridingMethod;
        that.iType = (CIMDataType)this.iType.clone();
        that.iPropagated = this.iPropagated;
        iter = this.iParameters.iterator();
        while (iter.hasNext()) {
            CIMParameter param = (CIMParameter)iter.next();
            that.iParameters.add(param.clone());
        }
        return that;
    }

    public int hashCode() {
        return (this.iOriginClass != null ? this.iOriginClass.hashCode() : 0) * 31 + (this.iOverridingMethod != null ? this.iOverridingMethod.hashCode() : 0) * 37 + (this.iPropagated ? 1 : 0) * 23 + this.iQualifiers.hashCode() + this.iParameters.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMMethod)) {
            return false;
        }
        CIMMethod that = (CIMMethod)o;
        if (!this.iParameters.equals(that.iParameters) || !this.iQualifiers.equals(that.iQualifiers) || this.iPropagated != that.iPropagated) {
            return false;
        }
        if (!(this.iOverridingMethod != null ? this.iOverridingMethod.equalsIgnoreCase(that.iOverridingMethod) : that.iOverridingMethod == null)) {
            return false;
        }
        if (!(this.iOriginClass != null ? this.iOriginClass.equalsIgnoreCase(that.iOriginClass) : that.iOriginClass == null)) {
            return false;
        }
        return this.iName.equalsIgnoreCase(that.iName);
    }

    public String getOriginClass() {
        return this.iOriginClass;
    }

    public String getOverridingMethod() {
        return this.iOverridingMethod;
    }

    public Vector getParameters() {
        return this.iParameters;
    }

    public boolean isPropagated() {
        return this.iPropagated;
    }

    public int getSize() {
        if (this.iType != null) {
            return this.iType.getSize();
        }
        return -1;
    }

    public CIMDataType getType() {
        return this.iType;
    }

    public void setOriginClass(String pOriginClass) {
        this.iOriginClass = pOriginClass;
    }

    public void setOverridingMethod(String pOverridingMethod) {
        this.iOverridingMethod = pOverridingMethod;
    }

    public void addParameter(CIMParameter pParameter) {
        if (pParameter == null) {
            throw new IllegalArgumentException("null parameter argument");
        }
        Utils.addSorted(this.iParameters, pParameter);
    }

    public void setParameters(Vector pParameters) {
        if (pParameters == null) {
            this.iParameters.setSize(0);
        } else {
            Utils.addSorted(this.iParameters, pParameters);
        }
    }

    public void setPropagated(boolean pIsPropagated) {
        this.iPropagated = pIsPropagated;
    }

    public void removeProperty(String pParameterName) {
        if (pParameterName == null) {
            throw new IllegalArgumentException("null parameterName argument");
        }
        Iterator iter = this.iParameters.iterator();
        while (iter.hasNext()) {
            CIMParameter param = (CIMParameter)iter.next();
            if (!param.getName().equals(pParameterName)) continue;
            iter.remove();
            return;
        }
    }

    public void setSize(int pSize) {
    }

    public void setType(CIMDataType pType) {
        this.iType = pType;
    }

    public String toMOF() {
        StringBuffer buf = new StringBuffer();
        if (this.iName != null && this.iName.length() > 0) {
            buf.append(CIMMethod.vectorToMOFString(this.iQualifiers, false, 1));
            buf.append("\n\t");
            if (this.iType != null) {
                buf.append(this.iType);
            } else {
                buf.append("void");
            }
            buf.append(" ");
            buf.append(this.iName);
            buf.append("(\n");
            buf.append(CIMMethod.vectorToMOFString(this.iParameters, true, 1, 0, true));
            buf.append("\t);");
        }
        return buf.toString();
    }

    public String toString() {
        return this.toMOF();
    }

    public static void main(String[] args) {
    }
}

