/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramVisitor;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.AsciiString;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.FlowData;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.UrlDirection;

public class ExtendedUrl
implements FlowData {
    public final UrlDirection direction;
    public final AsciiString url;
    public final AsciiString host;

    public ExtendedUrl(ByteBuffer buffer) throws InvalidPacketException {
        this.direction = UrlDirection.from(buffer);
        this.url = new AsciiString(buffer);
        this.host = new AsciiString(buffer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("direction", (Object)this.direction).add("url", (Object)this.url).add("host", (Object)this.host).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeName("direction");
        this.direction.writeBson(bsonWriter, enr);
        bsonWriter.writeString("url", this.url.value);
        bsonWriter.writeString("host", this.host.value);
        bsonWriter.writeEndDocument();
    }

    @Override
    public void visit(SampleDatagramVisitor visitor) {
        visitor.accept(this);
    }
}

