/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.camel;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.util.concurrent.TimeLimiter;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.direct.DirectConsumerNotAvailableException;
import org.apache.camel.spi.Synchronization;
import org.opennms.core.logging.Logging;
import org.opennms.core.rpc.api.RemoteExecutionException;
import org.opennms.core.rpc.api.RequestRejectedException;
import org.opennms.core.rpc.api.RequestTimedOutException;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.api.RpcResponse;
import org.opennms.core.rpc.camel.CamelRpcRequest;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.core.tracing.api.TracerRegistry;
import org.opennms.core.tracing.util.TracingInfoCarrier;
import org.opennms.core.utils.SystemInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CamelRpcClientFactory
implements RpcClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CamelRpcClientFactory.class);
    private static final long rpcExecTimeoutMs = SystemProperties.getLong((String)"org.opennms.jms.timeout", (Long)20000L);
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("CamelRpcClientFactory-Pool-%d").build();
    private String location;
    private ExecutorService executor;
    private TimeLimiter timeLimiter;
    @EndpointInject(uri="direct:executeRpc", context="rpcClient")
    private ProducerTemplate template;
    @EndpointInject(uri="direct:executeRpc", context="rpcClient")
    private Endpoint endpoint;
    @Autowired
    private TracerRegistry tracerRegistry;
    private Tracer tracer;
    private MetricRegistry metrics;
    private JmxReporter metricsReporter = null;

    public <S extends RpcRequest, T extends RpcResponse> RpcClient<S, T> getClient(final RpcModule<S, T> module) {
        return new RpcClient<S, T>(){

            public CompletableFuture<T> execute(S request) {
                if (request.getLocation() == null || request.getLocation().equals(CamelRpcClientFactory.this.location)) {
                    return module.execute(request);
                }
                final Map clientContextMap = Logging.getCopyOfContextMap();
                final Span span = CamelRpcClientFactory.this.tracer.buildSpan(module.getId()).start();
                span.setTag("location", request.getLocation());
                if (request.getSystemId() != null) {
                    span.setTag("systemId", request.getSystemId());
                }
                request.getTracingInfo().forEach((arg_0, arg_1) -> ((Span)span).setTag(arg_0, arg_1));
                TracingInfoCarrier tracingInfoCarrier = new TracingInfoCarrier();
                CamelRpcClientFactory.this.tracer.inject(span.context(), Format.Builtin.TEXT_MAP, (Object)tracingInfoCarrier);
                request.getTracingInfo().forEach((arg_0, arg_1) -> ((TracingInfoCarrier)tracingInfoCarrier).put(arg_0, arg_1));
                final Histogram rpcDuration = CamelRpcClientFactory.this.getMetrics().histogram(MetricRegistry.name((String)request.getLocation(), (String[])new String[]{module.getId(), "duration"}));
                final Histogram responseSize = CamelRpcClientFactory.this.getMetrics().histogram(MetricRegistry.name((String)request.getLocation(), (String[])new String[]{module.getId(), "responseSize"}));
                final Meter failedMeter = CamelRpcClientFactory.this.getMetrics().meter(MetricRegistry.name((String)request.getLocation(), (String[])new String[]{module.getId(), "requestFailed"}));
                final long requestCreationTime = System.currentTimeMillis();
                final CompletableFuture future = new CompletableFuture();
                try {
                    Long execTimeoutMs = request.getTimeToLiveMs();
                    execTimeoutMs = execTimeoutMs != null ? Long.valueOf(Math.min(execTimeoutMs, rpcExecTimeoutMs)) : Long.valueOf(rpcExecTimeoutMs);
                    CamelRpcClientFactory.this.timeLimiter.callWithTimeout(() -> {
                        CamelRpcClientFactory.this.template.asyncCallbackSendBody(CamelRpcClientFactory.this.endpoint, new CamelRpcRequest(module, (RpcRequest)request, tracingInfoCarrier.getTracingInfoMap()), new Synchronization(){

                            public void onComplete(Exchange exchange) {
                                try (Logging.MDCCloseable mdc = Logging.withContextMapCloseable((Map)clientContextMap);){
                                    String responseAsString = (String)exchange.getOut().getBody(String.class);
                                    responseSize.update(responseAsString.getBytes().length);
                                    RpcResponse response = module.unmarshalResponse(responseAsString);
                                    if (response.getErrorMessage() != null) {
                                        future.completeExceptionally((Throwable)new RemoteExecutionException(response.getErrorMessage()));
                                        span.setTag("failed", "true");
                                        span.log(response.getErrorMessage());
                                    } else {
                                        future.complete(response);
                                    }
                                }
                                catch (Throwable ex) {
                                    LOG.error("Unmarshalling a response in RPC module {} failed.", (Object)module, (Object)ex);
                                    future.completeExceptionally(ex);
                                    span.setTag("failed", "true");
                                    span.log(ex.getMessage());
                                }
                                span.finish();
                                rpcDuration.update(System.currentTimeMillis() - requestCreationTime);
                                Logging.putPrefix((String)"ipc");
                            }

                            public void onFailure(Exchange exchange) {
                                try (Logging.MDCCloseable mdc = Logging.withContextMapCloseable((Map)clientContextMap);){
                                    ExchangeTimedOutException timeoutException = (ExchangeTimedOutException)exchange.getException(ExchangeTimedOutException.class);
                                    DirectConsumerNotAvailableException directConsumerNotAvailableException = (DirectConsumerNotAvailableException)exchange.getException(DirectConsumerNotAvailableException.class);
                                    if (timeoutException != null) {
                                        future.completeExceptionally((Throwable)new RequestTimedOutException((Throwable)exchange.getException()));
                                        span.setTag("timeout", "true");
                                    } else if (directConsumerNotAvailableException != null) {
                                        future.completeExceptionally((Throwable)new RequestRejectedException((Throwable)exchange.getException()));
                                    } else {
                                        future.completeExceptionally(exchange.getException());
                                    }
                                }
                                span.setTag("failed", "true");
                                span.log(exchange.getException().getMessage());
                                span.finish();
                                failedMeter.mark();
                                rpcDuration.update(System.currentTimeMillis() - requestCreationTime);
                                Logging.putPrefix((String)"ipc");
                            }
                        });
                        return null;
                    }, execTimeoutMs.longValue(), TimeUnit.MILLISECONDS, true);
                }
                catch (Exception e) {
                    try (Logging.MDCCloseable mdc = Logging.withContextMapCloseable((Map)clientContextMap);){
                        future.completeExceptionally((Throwable)new RequestRejectedException((Throwable)e));
                        span.setTag("failed", "true");
                        span.log(e.getMessage());
                        rpcDuration.update(System.currentTimeMillis() - requestCreationTime);
                        span.finish();
                    }
                    Logging.putPrefix((String)"ipc");
                }
                Meter requestSentMeter = CamelRpcClientFactory.this.getMetrics().meter(MetricRegistry.name((String)request.getLocation(), (String[])new String[]{module.getId(), "requestSent"}));
                requestSentMeter.mark();
                return future;
            }
        };
    }

    public TracerRegistry getTracerRegistry() {
        return this.tracerRegistry;
    }

    public void setTracerRegistry(TracerRegistry tracerRegistry) {
        this.tracerRegistry = tracerRegistry;
    }

    public MetricRegistry getMetrics() {
        if (this.metrics == null) {
            this.metrics = new MetricRegistry();
        }
        return this.metrics;
    }

    public void setMetrics(MetricRegistry metrics) {
        this.metrics = metrics;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void start() {
        this.executor = Executors.newCachedThreadPool(this.threadFactory);
        this.timeLimiter = new SimpleTimeLimiter(this.executor);
        this.tracerRegistry.init(SystemInfoUtils.getInstanceId());
        this.tracer = this.tracerRegistry.getTracer();
        this.metricsReporter = JmxReporter.forRegistry((MetricRegistry)this.getMetrics()).inDomain("org.opennms.core.ipc.rpc").build();
        this.metricsReporter.start();
    }

    public void stop() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.metricsReporter != null) {
            this.metricsReporter.close();
        }
    }
}

