/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dnsresolver.shell;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.net.InetAddresses;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.dnsresolver.api.DnsResolver;

@Command(scope="opennms-dns", name="stress", description="Stress the DNS lookups")
@Service
public class StressCommand
implements Action {
    @Reference
    public DnsResolver dnsResolver;
    @Option(name="-l", aliases={"--lps"}, description="Lookups per seconds to generate per thread.")
    int lookupsPerSecondPerThread = 300;
    @Option(name="-t", aliases={"--threads"}, description="Number of threads used to generated lookups.")
    int numberOfThreads = 1;
    @Option(name="-s", aliases={"--seconds"}, description="Number of seconds to run")
    int durationInSeconds = 60;
    @Option(name="-r", aliases={"--report"}, description="Number of seconds after which the report should be generated")
    int reportIntervalInSeconds = 5;
    private AtomicInteger nextIpAddress = new AtomicInteger(0x1010101);
    private final MetricRegistry metrics = new MetricRegistry();
    private final Meter lookups = this.metrics.meter("lookups");
    private final Meter responseSuccess = this.metrics.meter("response-success");
    private final Meter responseFailed = this.metrics.meter("response-failed");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() {
        ConsoleReporter reporter;
        block9: {
            this.lookupsPerSecondPerThread = Math.max(1, this.lookupsPerSecondPerThread);
            this.numberOfThreads = Math.max(1, this.numberOfThreads);
            this.durationInSeconds = Math.max(1, this.durationInSeconds);
            this.reportIntervalInSeconds = Math.max(1, this.reportIntervalInSeconds);
            double lookupsPerSecond = (double)this.lookupsPerSecondPerThread * (double)this.numberOfThreads;
            System.out.printf("Generating %d DNS lookups per second accross %d threads for %d seconds\n", this.lookupsPerSecondPerThread, this.numberOfThreads, this.durationInSeconds);
            System.out.printf("Which will yield an effective\n", new Object[0]);
            System.out.printf("\t %.2f lookups per second\n", lookupsPerSecond);
            System.out.printf("\t %.2f total lookups\n", lookupsPerSecond * (double)this.durationInSeconds);
            reporter = ConsoleReporter.forRegistry((MetricRegistry)this.metrics).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("DNS Lookup Generator #%d").build();
            ExecutorService executor = Executors.newFixedThreadPool(this.numberOfThreads, threadFactory);
            System.out.println("Starting.");
            try {
                reporter.start((long)this.reportIntervalInSeconds, TimeUnit.SECONDS);
                for (int i = 0; i < this.numberOfThreads; ++i) {
                    DNSLookupGenerator generator = new DNSLookupGenerator();
                    executor.execute(generator);
                }
                System.out.println("Started.");
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(this.durationInSeconds));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    System.out.println("Stopping.");
                    executor.shutdownNow();
                    if (!executor.awaitTermination(2L, TimeUnit.MINUTES)) {
                        System.err.println("The threads did not stop in time.");
                        break block9;
                    }
                    System.out.println("Stopped.");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                reporter.stop();
            }
        }
        reporter.report();
        return null;
    }

    private class DNSLookupGenerator
    implements Runnable {
        private final Set<CompletableFuture<Optional<String>>> pendingFutures = new HashSet<CompletableFuture<Optional<String>>>();

        private DNSLookupGenerator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList<CompletableFuture<Optional<String>>> futuresToWaitFor;
            Object future;
            RateLimiter rateLimiter = RateLimiter.create((double)StressCommand.this.lookupsPerSecondPerThread);
            do {
                rateLimiter.acquire(1);
                Inet4Address addr = InetAddresses.fromInteger((int)StressCommand.this.nextIpAddress.incrementAndGet());
                future = StressCommand.this.dnsResolver.reverseLookup((InetAddress)addr);
                Set<CompletableFuture<Optional<String>>> set = this.pendingFutures;
                synchronized (set) {
                    this.pendingFutures.add((CompletableFuture<Optional<String>>)future);
                }
                ((CompletableFuture)future).whenComplete((arg_0, arg_1) -> this.lambda$run$0((CompletableFuture)future, arg_0, arg_1));
                StressCommand.this.lookups.mark();
            } while (!Thread.interrupted());
            future = this.pendingFutures;
            synchronized (future) {
                futuresToWaitFor = new LinkedList<CompletableFuture<Optional<String>>>(this.pendingFutures);
            }
            System.out.printf("Waiting for %d pending requests...\n", futuresToWaitFor.size());
            try {
                CompletableFuture.allOf(futuresToWaitFor.toArray(new CompletableFuture[0])).get(1L, TimeUnit.MINUTES);
                System.out.println("Pending requests completed.");
            }
            catch (TimeoutException e) {
                System.out.println("Requests did not complete in time.");
            }
            catch (ExecutionException e) {
                System.out.println("Pending requests completed.");
            }
            catch (InterruptedException e) {
                System.out.println("Interrupted while waiting for pending requests.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private /* synthetic */ void lambda$run$0(CompletableFuture future, Optional hostnameFromDns, Throwable ex) {
            Set<CompletableFuture<Optional<String>>> set = this.pendingFutures;
            synchronized (set) {
                this.pendingFutures.remove(future);
            }
            if (ex == null) {
                StressCommand.this.responseSuccess.mark();
            } else {
                StressCommand.this.responseFailed.mark();
            }
        }
    }
}

