/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.eventdata.DSETimeStamp;
import com.novell.ldap.events.edir.eventdata.ReferralAddress;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class DebugParameter {
    private int type;
    private Object data;

    public DebugParameter(ASN1Tagged aSN1Tagged) throws IOException {
        switch (aSN1Tagged.getIdentifier().getTag()) {
            case 1: {
                int n = this.getTaggedintValue(aSN1Tagged);
                this.data = new Integer(n);
                break;
            }
            case 4: {
                int n = this.getTaggedintValue(aSN1Tagged);
                this.data = new Integer(n);
                break;
            }
            case 3: {
                byte[] byArray = ((ASN1OctetString)aSN1Tagged.taggedValue()).byteValue();
                this.data = byArray;
                break;
            }
            case 2: {
                String string = ((ASN1OctetString)aSN1Tagged.taggedValue()).stringValue();
                this.data = string;
                break;
            }
            case 6: {
                DSETimeStamp dSETimeStamp = new DSETimeStamp(this.getTaggedSequence(aSN1Tagged));
                this.data = dSETimeStamp;
                break;
            }
            case 7: {
                ArrayList<DSETimeStamp> arrayList = Collections.EMPTY_LIST;
                ASN1Sequence aSN1Sequence = this.getTaggedSequence(aSN1Tagged);
                int n = ((ASN1Integer)aSN1Sequence.get(0)).intValue();
                if (n > 0) {
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.get(1);
                    arrayList = new ArrayList<DSETimeStamp>();
                    for (int i = 0; i < n; ++i) {
                        arrayList.add(new DSETimeStamp((ASN1Sequence)aSN1Sequence2.get(i)));
                    }
                }
                this.data = arrayList;
                break;
            }
            case 5: {
                ReferralAddress referralAddress = new ReferralAddress(this.getTaggedSequence(aSN1Tagged));
                this.data = referralAddress;
                break;
            }
            default: {
                throw new IOException("Unknown Tag in DebugParameter..");
            }
        }
        this.type = aSN1Tagged.getIdentifier().getTag();
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[DebugParameter");
        switch (this.getType()) {
            case 1: {
                stringBuffer.append("type=EVENT_TAG_DEBUG_INFO_ENTRYID");
                stringBuffer.append(" value=" + this.getData());
                break;
            }
            case 4: {
                stringBuffer.append("type=EVENT_TAG_DEBUG_INFO_INTEGER");
                stringBuffer.append("value=" + this.getData());
                break;
            }
            case 3: {
                stringBuffer.append("type=DB_PARAM_TYPE_BINARY");
                stringBuffer.append("value=" + this.getData());
                break;
            }
            case 2: {
                stringBuffer.append("type=DB_PARAM_TYPE_STRING");
                stringBuffer.append("value=" + this.getData());
                break;
            }
            case 6: {
                stringBuffer.append("type=DB_PARAM_TYPE_TIMESTAMP");
                stringBuffer.append("value=" + this.getData());
                break;
            }
            case 7: {
                stringBuffer.append("type=DB_PARAM_TYPE_TIMEVECTOR");
                stringBuffer.append("value=" + this.getData());
                break;
            }
            case 5: {
                stringBuffer.append("type=DB_PARAM_TYPE_ADDRESS");
                stringBuffer.append("value=" + this.getData());
                break;
            }
            default: {
                stringBuffer.append("type=Unknown");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private int getTaggedintValue(ASN1Tagged aSN1Tagged) throws IOException {
        ASN1Object aSN1Object = aSN1Tagged.taggedValue();
        byte[] byArray = ((ASN1OctetString)aSN1Object).byteValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LBERDecoder lBERDecoder = new LBERDecoder();
        int n = byArray.length;
        return ((Long)lBERDecoder.decodeNumeric(byteArrayInputStream, n)).intValue();
    }

    private ASN1Sequence getTaggedSequence(ASN1Tagged aSN1Tagged) throws IOException {
        ASN1Object aSN1Object = aSN1Tagged.taggedValue();
        byte[] byArray = ((ASN1OctetString)aSN1Object).byteValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LBERDecoder lBERDecoder = new LBERDecoder();
        return new ASN1Sequence(lBERDecoder, byteArrayInputStream, byArray.length);
    }

    public Object getData() {
        return this.data;
    }
}

