/*
 * Decompiled with CFR 0.152.
 */
package org.dhcp4java;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dhcp4java.DHCPBadPacketException;
import org.dhcp4java.DHCPConstants;
import org.dhcp4java.DHCPPacket;
import org.dhcp4java.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHCPOption
implements Serializable {
    private static final Logger s_aLogger = LoggerFactory.getLogger(DHCPOption.class);
    private final byte m_nCode;
    private final byte[] m_aValue;
    private final boolean m_bMirror;
    private static final Object[] _OPTION_FORMATS = new Object[]{(byte)1, EOptionFormat.INET, (byte)2, EOptionFormat.INT, (byte)3, EOptionFormat.INETS, (byte)4, EOptionFormat.INETS, (byte)5, EOptionFormat.INETS, (byte)6, EOptionFormat.INETS, (byte)7, EOptionFormat.INETS, (byte)8, EOptionFormat.INETS, (byte)9, EOptionFormat.INETS, (byte)10, EOptionFormat.INETS, (byte)11, EOptionFormat.INETS, (byte)12, EOptionFormat.STRING, (byte)13, EOptionFormat.SHORT, (byte)14, EOptionFormat.STRING, (byte)15, EOptionFormat.STRING, (byte)16, EOptionFormat.INET, (byte)17, EOptionFormat.STRING, (byte)18, EOptionFormat.STRING, (byte)19, EOptionFormat.BYTE, (byte)20, EOptionFormat.BYTE, (byte)21, EOptionFormat.INETS, (byte)22, EOptionFormat.SHORT, (byte)23, EOptionFormat.BYTE, (byte)24, EOptionFormat.INT, (byte)25, EOptionFormat.SHORTS, (byte)26, EOptionFormat.SHORT, (byte)27, EOptionFormat.BYTE, (byte)28, EOptionFormat.INET, (byte)29, EOptionFormat.BYTE, (byte)30, EOptionFormat.BYTE, (byte)31, EOptionFormat.BYTE, (byte)32, EOptionFormat.INET, (byte)33, EOptionFormat.INETS, (byte)34, EOptionFormat.BYTE, (byte)35, EOptionFormat.INT, (byte)36, EOptionFormat.BYTE, (byte)37, EOptionFormat.BYTE, (byte)38, EOptionFormat.INT, (byte)39, EOptionFormat.BYTE, (byte)41, EOptionFormat.INETS, (byte)42, EOptionFormat.INETS, (byte)44, EOptionFormat.INETS, (byte)45, EOptionFormat.INETS, (byte)46, EOptionFormat.BYTE, (byte)47, EOptionFormat.STRING, (byte)48, EOptionFormat.INETS, (byte)49, EOptionFormat.INETS, (byte)50, EOptionFormat.INET, (byte)51, EOptionFormat.INT, (byte)52, EOptionFormat.BYTE, (byte)53, EOptionFormat.BYTE, (byte)54, EOptionFormat.INET, (byte)55, EOptionFormat.BYTES, (byte)56, EOptionFormat.STRING, (byte)57, EOptionFormat.SHORT, (byte)58, EOptionFormat.INT, (byte)59, EOptionFormat.INT, (byte)60, EOptionFormat.STRING, (byte)62, EOptionFormat.STRING, (byte)64, EOptionFormat.STRING, (byte)65, EOptionFormat.STRING, (byte)66, EOptionFormat.STRING, (byte)67, EOptionFormat.STRING, (byte)68, EOptionFormat.INETS, (byte)69, EOptionFormat.INETS, (byte)70, EOptionFormat.INETS, (byte)71, EOptionFormat.INETS, (byte)72, EOptionFormat.INETS, (byte)73, EOptionFormat.INETS, (byte)74, EOptionFormat.INETS, (byte)75, EOptionFormat.INETS, (byte)76, EOptionFormat.INETS, (byte)85, EOptionFormat.INETS, (byte)86, EOptionFormat.STRING, (byte)87, EOptionFormat.STRING, (byte)91, EOptionFormat.INT, (byte)92, EOptionFormat.INETS, (byte)98, EOptionFormat.STRING, (byte)116, EOptionFormat.BYTE, (byte)117, EOptionFormat.SHORTS, (byte)118, EOptionFormat.INET, (byte)119, EOptionFormat.STRING};
    private static final Map<Byte, EOptionFormat> _DHO_FORMATS = new LinkedHashMap<Byte, EOptionFormat>();

    public DHCPOption(byte by, byte[] byArray, boolean bl) {
        if (by == 0) {
            throw new IllegalArgumentException("code=0 is not allowed (reserved for padding");
        }
        if (by == -1) {
            throw new IllegalArgumentException("code=-1 is not allowed (reserved for End Of Options)");
        }
        this.m_nCode = by;
        this.m_aValue = byArray != null ? (byte[])byArray.clone() : null;
        this.m_bMirror = bl;
    }

    public DHCPOption(byte by, byte[] byArray) {
        this(by, byArray, false);
    }

    public byte getCode() {
        return this.m_nCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof DHCPOption)) {
            return false;
        }
        DHCPOption dHCPOption = (DHCPOption)object;
        return dHCPOption.m_nCode == this.m_nCode && dHCPOption.m_bMirror == this.m_bMirror && Arrays.equals(dHCPOption.m_aValue, this.m_aValue);
    }

    public int hashCode() {
        return this.m_nCode ^ Arrays.hashCode(this.m_aValue) ^ (this.m_bMirror ? Integer.MIN_VALUE : 0);
    }

    public byte[] getValue() {
        return this.m_aValue == null ? null : (byte[])this.m_aValue.clone();
    }

    public byte[] getValueFast() {
        return this.m_aValue;
    }

    public boolean isMirror() {
        return this.m_bMirror;
    }

    public static final boolean isOptionAsByte(byte by) {
        return EOptionFormat.BYTE.equals((Object)_DHO_FORMATS.get(by));
    }

    public static DHCPOption newOptionAsByte(byte by, byte by2) {
        if (!DHCPOption.isOptionAsByte(by)) {
            throw new IllegalArgumentException("DHCP option type (" + by + ") is not byte");
        }
        return new DHCPOption(by, DHCPOption.byte2Bytes(by2));
    }

    public byte getValueAsByte() throws IllegalArgumentException {
        if (!DHCPOption.isOptionAsByte(this.m_nCode)) {
            throw new IllegalArgumentException("DHCP option type (" + this.m_nCode + ") is not byte");
        }
        if (this.m_aValue == null) {
            throw new IllegalStateException("value is null");
        }
        if (this.m_aValue.length != 1) {
            throw new DHCPBadPacketException("option " + this.m_nCode + " is wrong size:" + this.m_aValue.length + " should be 1");
        }
        return this.m_aValue[0];
    }

    public static final boolean isOptionAsShort(byte by) {
        return EOptionFormat.SHORT.equals((Object)_DHO_FORMATS.get(by));
    }

    public short getValueAsShort() throws IllegalArgumentException {
        if (!DHCPOption.isOptionAsShort(this.m_nCode)) {
            throw new IllegalArgumentException("DHCP option type (" + this.m_nCode + ") is not short");
        }
        if (this.m_aValue == null) {
            throw new IllegalStateException("value is null");
        }
        if (this.m_aValue.length != 2) {
            throw new DHCPBadPacketException("option " + this.m_nCode + " is wrong size:" + this.m_aValue.length + " should be 2");
        }
        return (short)((this.m_aValue[0] & 0xFF) << 8 | this.m_aValue[1] & 0xFF);
    }

    public static final boolean isOptionAsInt(byte by) {
        return EOptionFormat.INT.equals((Object)_DHO_FORMATS.get(by));
    }

    public int getValueAsInt() throws IllegalArgumentException {
        if (!DHCPOption.isOptionAsInt(this.m_nCode)) {
            throw new IllegalArgumentException("DHCP option type (" + this.m_nCode + ") is not int");
        }
        if (this.m_aValue == null) {
            throw new IllegalStateException("value is null");
        }
        if (this.m_aValue.length != 4) {
            throw new DHCPBadPacketException("option " + this.m_nCode + " is wrong size:" + this.m_aValue.length + " should be 4");
        }
        return (this.m_aValue[0] & 0xFF) << 24 | (this.m_aValue[1] & 0xFF) << 16 | (this.m_aValue[2] & 0xFF) << 8 | this.m_aValue[3] & 0xFF;
    }

    public Integer getValueAsNum() {
        if (this.m_aValue == null) {
            return null;
        }
        if (this.m_aValue.length == 1) {
            return this.m_aValue[0] & 0xFF;
        }
        if (this.m_aValue.length == 2) {
            return (this.m_aValue[0] & 0xFF) << 8 | this.m_aValue[1] & 0xFF;
        }
        if (this.m_aValue.length == 4) {
            return (this.m_aValue[0] & 0xFF) << 24 | (this.m_aValue[1] & 0xFF) << 16 | (this.m_aValue[2] & 0xFF) << 8 | this.m_aValue[3] & 0xFF;
        }
        return null;
    }

    public static final boolean isOptionAsInetAddr(byte by) {
        return EOptionFormat.INET.equals((Object)_DHO_FORMATS.get(by));
    }

    public InetAddress getValueAsInetAddr() throws IllegalArgumentException {
        if (!DHCPOption.isOptionAsInetAddr(this.m_nCode)) {
            throw new IllegalArgumentException("DHCP option type (" + this.m_nCode + ") is not InetAddr");
        }
        if (this.m_aValue == null) {
            throw new IllegalStateException("value is null");
        }
        if (this.m_aValue.length != 4) {
            throw new DHCPBadPacketException("option " + this.m_nCode + " is wrong size:" + this.m_aValue.length + " should be 4");
        }
        try {
            return InetAddress.getByAddress(this.m_aValue);
        }
        catch (UnknownHostException unknownHostException) {
            s_aLogger.error("Unexpected UnknownHostException", (Throwable)unknownHostException);
            return null;
        }
    }

    public static final boolean isOptionAsString(byte by) {
        return EOptionFormat.STRING.equals((Object)_DHO_FORMATS.get(by));
    }

    public String getValueAsString() throws IllegalArgumentException {
        if (!DHCPOption.isOptionAsString(this.m_nCode)) {
            throw new IllegalArgumentException("DHCP option type (" + this.m_nCode + ") is not String");
        }
        if (this.m_aValue == null) {
            throw new IllegalStateException("value is null");
        }
        return Util.bytesToString(this.m_aValue);
    }

    public static final boolean isOptionAsShorts(byte by) {
        return EOptionFormat.SHORTS.equals((Object)_DHO_FORMATS.get(by));
    }

    public short[] getValueAsShorts() throws IllegalArgumentException {
        if (!DHCPOption.isOptionAsShorts(this.m_nCode)) {
            throw new IllegalArgumentException("DHCP option type (" + this.m_nCode + ") is not short[]");
        }
        if (this.m_aValue == null) {
            throw new IllegalStateException("value is null");
        }
        if (this.m_aValue.length % 2 != 0) {
            throw new DHCPBadPacketException("option " + this.m_nCode + " is wrong size:" + this.m_aValue.length + " should be 2*X");
        }
        short[] sArray = new short[this.m_aValue.length / 2];
        int n = 0;
        for (int i = 0; i < this.m_aValue.length; i += 2) {
            sArray[n] = (short)((this.m_aValue[i] & 0xFF) << 8 | this.m_aValue[i + 1] & 0xFF);
            ++n;
        }
        return sArray;
    }

    public static final boolean isOptionAsInetAddrs(byte by) {
        return EOptionFormat.INETS.equals((Object)_DHO_FORMATS.get(by));
    }

    public InetAddress[] getValueAsInetAddrs() throws IllegalArgumentException {
        if (!DHCPOption.isOptionAsInetAddrs(this.m_nCode)) {
            throw new IllegalArgumentException("DHCP option type (" + this.m_nCode + ") is not InetAddr[]");
        }
        if (this.m_aValue == null) {
            throw new IllegalStateException("value is null");
        }
        if (this.m_aValue.length % 4 != 0) {
            throw new DHCPBadPacketException("option " + this.m_nCode + " is wrong size:" + this.m_aValue.length + " should be 4*X");
        }
        try {
            byte[] byArray = new byte[4];
            InetAddress[] inetAddressArray = new InetAddress[this.m_aValue.length / 4];
            int n = 0;
            for (int i = 0; i < this.m_aValue.length; i += 4) {
                byArray[0] = this.m_aValue[i];
                byArray[1] = this.m_aValue[i + 1];
                byArray[2] = this.m_aValue[i + 2];
                byArray[3] = this.m_aValue[i + 3];
                inetAddressArray[n] = InetAddress.getByAddress(byArray);
                ++n;
            }
            return inetAddressArray;
        }
        catch (UnknownHostException unknownHostException) {
            s_aLogger.error("Unexpected UnknownHostException", (Throwable)unknownHostException);
            return null;
        }
    }

    public static final boolean isOptionAsBytes(byte by) {
        return EOptionFormat.BYTES.equals((Object)_DHO_FORMATS.get(by));
    }

    public byte[] getValueAsBytes() throws IllegalArgumentException {
        if (!DHCPOption.isOptionAsBytes(this.m_nCode)) {
            throw new IllegalArgumentException("DHCP option type (" + this.m_nCode + ") is not bytes");
        }
        if (this.m_aValue == null) {
            throw new IllegalStateException("value is null");
        }
        return this.getValue();
    }

    public static DHCPOption newOptionAsShort(byte by, short s) {
        if (!DHCPOption.isOptionAsShort(by)) {
            throw new IllegalArgumentException("DHCP option type (" + by + ") is not short");
        }
        return new DHCPOption(by, DHCPOption.short2Bytes(s));
    }

    public static DHCPOption newOptionAsShorts(byte by, short[] sArray) {
        if (!DHCPOption.isOptionAsShorts(by)) {
            throw new IllegalArgumentException("DHCP option type (" + by + ") is not shorts");
        }
        byte[] byArray = null;
        if (sArray != null) {
            byArray = new byte[sArray.length * 2];
            for (int i = 0; i < sArray.length; ++i) {
                short s = sArray[i];
                byArray[i * 2] = (byte)((s & 0xFF00) >>> 8);
                byArray[i * 2 + 1] = (byte)(s & 0xFF);
            }
        }
        return new DHCPOption(by, byArray);
    }

    public static DHCPOption newOptionAsInt(byte by, int n) {
        if (!DHCPOption.isOptionAsInt(by)) {
            throw new IllegalArgumentException("DHCP option type (" + by + ") is not int");
        }
        return new DHCPOption(by, DHCPOption.int2Bytes(n));
    }

    public static DHCPOption newOptionAsInetAddress(byte by, InetAddress inetAddress) {
        if (!DHCPOption.isOptionAsInetAddr(by) && !DHCPOption.isOptionAsInetAddrs(by)) {
            throw new IllegalArgumentException("DHCP option type (" + by + ") is not InetAddress");
        }
        return new DHCPOption(by, DHCPOption.inetAddress2Bytes(inetAddress));
    }

    public static DHCPOption newOptionAsInetAddresses(byte by, InetAddress[] inetAddressArray) {
        if (!DHCPOption.isOptionAsInetAddrs(by)) {
            throw new IllegalArgumentException("DHCP option type (" + by + ") is not InetAddresses");
        }
        return new DHCPOption(by, DHCPOption.inetAddresses2Bytes(inetAddressArray));
    }

    public static DHCPOption newOptionAsString(byte by, String string) {
        if (!DHCPOption.isOptionAsString(by)) {
            throw new IllegalArgumentException("DHCP option type (" + by + ") is not string");
        }
        return new DHCPOption(by, Util.stringToBytes(string));
    }

    public DHCPOption applyOption(DHCPPacket dHCPPacket) {
        if (dHCPPacket == null) {
            throw new NullPointerException("request is null");
        }
        if (this.m_bMirror) {
            DHCPOption dHCPOption = dHCPPacket.getOption(this.getCode());
            return dHCPOption != null ? dHCPOption : this;
        }
        return this;
    }

    public void append(StringBuilder stringBuilder) {
        if (DHCPConstants._DHO_NAMES.containsKey(this.m_nCode)) {
            stringBuilder.append(DHCPConstants._DHO_NAMES.get(this.m_nCode));
        }
        stringBuilder.append('(').append(DHCPOption.unsignedByte(this.m_nCode)).append(")=");
        if (this.m_bMirror) {
            stringBuilder.append("<mirror>");
        }
        if (this.m_aValue == null) {
            stringBuilder.append("<null>");
        } else if (this.m_nCode == 53) {
            Byte by = this.getValueAsByte();
            if (DHCPConstants._DHCP_CODES.containsKey(by)) {
                stringBuilder.append(DHCPConstants._DHCP_CODES.get(by));
            } else {
                stringBuilder.append(by);
            }
        } else if (this.m_nCode == 77) {
            stringBuilder.append(DHCPOption.userClassToString(this.m_aValue));
        } else if (this.m_nCode == 82) {
            stringBuilder.append(DHCPOption.agentOptionsToString(this.m_aValue));
        } else if (_DHO_FORMATS.containsKey(this.m_nCode)) {
            try {
                switch (_DHO_FORMATS.get(this.m_nCode)) {
                    case INET: {
                        Util.appendHostAddress(stringBuilder, this.getValueAsInetAddr());
                        break;
                    }
                    case INETS: {
                        for (InetAddress inetAddress : this.getValueAsInetAddrs()) {
                            Util.appendHostAddress(stringBuilder, inetAddress);
                            stringBuilder.append(' ');
                        }
                        break;
                    }
                    case INT: {
                        stringBuilder.append(this.getValueAsInt());
                        break;
                    }
                    case SHORT: {
                        stringBuilder.append(this.getValueAsShort());
                        break;
                    }
                    case SHORTS: {
                        for (short s : this.getValueAsShorts()) {
                            stringBuilder.append(s).append(' ');
                        }
                        break;
                    }
                    case BYTE: {
                        stringBuilder.append(this.getValueAsByte());
                        break;
                    }
                    case STRING: {
                        stringBuilder.append('\"').append(this.getValueAsString()).append('\"');
                        break;
                    }
                    case BYTES: {
                        if (this.m_aValue != null) {
                            for (byte by : this.m_aValue) {
                                stringBuilder.append(DHCPOption.unsignedByte(by)).append(' ');
                            }
                        }
                        break;
                    }
                    default: {
                        stringBuilder.append("0x");
                        Util.appendHex(stringBuilder, this.m_aValue);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                stringBuilder.append("0x");
                Util.appendHex(stringBuilder, this.m_aValue);
            }
        } else {
            stringBuilder.append("0x");
            Util.appendHex(stringBuilder, this.m_aValue);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.append(stringBuilder);
        return stringBuilder.toString();
    }

    private static int unsignedByte(byte by) {
        return by & 0xFF;
    }

    public static byte[] byte2Bytes(byte by) {
        byte[] byArray = new byte[]{by};
        return byArray;
    }

    public static byte[] short2Bytes(short s) {
        byte[] byArray = new byte[]{(byte)((s & 0xFF00) >>> 8), (byte)(s & 0xFF)};
        return byArray;
    }

    public static byte[] int2Bytes(int n) {
        byte[] byArray = new byte[]{(byte)((n & 0xFF000000) >>> 24), (byte)((n & 0xFF0000) >>> 16), (byte)((n & 0xFF00) >>> 8), (byte)(n & 0xFF)};
        return byArray;
    }

    public static byte[] inetAddress2Bytes(InetAddress inetAddress) {
        if (inetAddress == null) {
            return null;
        }
        if (!(inetAddress instanceof Inet4Address)) {
            throw new IllegalArgumentException("Adress must be of subclass Inet4Address");
        }
        return inetAddress.getAddress();
    }

    public static byte[] inetAddresses2Bytes(InetAddress[] inetAddressArray) {
        if (inetAddressArray == null) {
            return null;
        }
        byte[] byArray = new byte[inetAddressArray.length * 4];
        for (int i = 0; i < inetAddressArray.length; ++i) {
            InetAddress inetAddress = inetAddressArray[i];
            if (!(inetAddress instanceof Inet4Address)) {
                throw new IllegalArgumentException("Adress must be of subclass Inet4Address");
            }
            System.arraycopy(inetAddress.getAddress(), 0, byArray, i * 4, 4);
        }
        return byArray;
    }

    public static List<String> userClassToList(byte[] byArray) {
        int n;
        if (byArray == null) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < byArray.length; i += n) {
            int n2;
            if ((n = DHCPOption.unsignedByte(byArray[i++])) > (n2 = byArray.length - i)) {
                n = n2;
            }
            linkedList.add(Util.bytesToString(byArray, i, n));
        }
        return linkedList;
    }

    public static String userClassToString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        List<String> list = DHCPOption.userClassToList(byArray);
        for (String string : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('\"').append(string).append('\"');
        }
        return stringBuilder.toString();
    }

    public static byte[] stringListToUserClass(List<String> list) {
        if (list == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            for (String string : list) {
                byte[] byArray = Util.stringToBytes(string);
                int n = byArray.length;
                if (n > 255) {
                    n = 255;
                }
                dataOutputStream.writeByte(n);
                dataOutputStream.write(byArray, 0, n);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            s_aLogger.error("Unexpected IOException", (Throwable)iOException);
            return byteArrayOutputStream.toByteArray();
        }
    }

    public static String agentOptionsToString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        Map<Byte, String> map = DHCPOption.agentOptionsToMap(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<Byte, String> entry : map.entrySet()) {
            stringBuffer.append('{').append(DHCPOption.unsignedByte(entry.getKey())).append("}\"");
            stringBuffer.append(entry.getValue()).append('\"');
            stringBuffer.append(',');
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    /*
     * Exception decompiling
     */
    public static byte[] agentOptionToRaw(Map<Byte, String> var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final Map<Byte, String> agentOptionsToMap(byte[] byArray) {
        int n;
        if (byArray == null) {
            return null;
        }
        LinkedHashMap<Byte, String> linkedHashMap = new LinkedHashMap<Byte, String>();
        for (int i = 0; i < byArray.length && byArray.length - i >= 2; i += n) {
            int n2;
            Byte by = byArray[i++];
            if ((n = DHCPOption.unsignedByte(byArray[i++])) > (n2 = byArray.length - i)) {
                n = n2;
            }
            linkedHashMap.put(by, Util.bytesToString(byArray, i, n));
        }
        return linkedHashMap;
    }

    public static Class<?> getOptionFormat(byte by) {
        EOptionFormat eOptionFormat = _DHO_FORMATS.get(by);
        if (eOptionFormat == null) {
            return null;
        }
        switch (eOptionFormat) {
            case INET: {
                return InetAddress.class;
            }
            case INETS: {
                return InetAddress[].class;
            }
            case INT: {
                return Integer.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
            case SHORTS: {
                return short[].class;
            }
            case BYTE: {
                return Byte.TYPE;
            }
            case BYTES: {
                return byte[].class;
            }
            case STRING: {
                return String.class;
            }
        }
        return null;
    }

    public static Class<?> string2Class(String string) {
        if ("InetAddress".equals(string)) {
            return InetAddress.class;
        }
        if ("inet".equals(string)) {
            return InetAddress.class;
        }
        if ("InetAddress[]".equals(string)) {
            return InetAddress[].class;
        }
        if ("inets".equals(string)) {
            return InetAddress[].class;
        }
        if ("int".equals(string)) {
            return Integer.TYPE;
        }
        if ("short".equals(string)) {
            return Short.TYPE;
        }
        if ("short[]".equals(string)) {
            return short[].class;
        }
        if ("shorts".equals(string)) {
            return short[].class;
        }
        if ("byte".equals(string)) {
            return Byte.TYPE;
        }
        if ("byte[]".equals(string)) {
            return byte[].class;
        }
        if ("bytes".equals(string)) {
            return byte[].class;
        }
        if ("String".equals(string)) {
            return String.class;
        }
        if ("string".equals(string)) {
            return String.class;
        }
        return null;
    }

    public static DHCPOption parseNewOption(byte by, Class<?> clazz, String string) {
        if (clazz == null || string == null) {
            throw new NullPointerException();
        }
        String string2 = string;
        if (Short.TYPE.equals(clazz)) {
            return DHCPOption.newOptionAsShort(by, (short)Integer.parseInt(string2));
        }
        if (short[].class.equals(clazz)) {
            String[] stringArray = string2.split(" ");
            short[] sArray = new short[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                sArray[i] = (short)Integer.parseInt(stringArray[i]);
            }
            return DHCPOption.newOptionAsShorts(by, sArray);
        }
        if (Integer.TYPE.equals(clazz)) {
            return DHCPOption.newOptionAsInt(by, Integer.parseInt(string2));
        }
        if (String.class.equals(clazz)) {
            return DHCPOption.newOptionAsString(by, string2);
        }
        if (Byte.TYPE.equals(clazz)) {
            return DHCPOption.newOptionAsByte(by, (byte)Integer.parseInt(string2));
        }
        if (byte[].class.equals(clazz)) {
            string2 = string2.replace(".", " ");
            String[] stringArray = string2.split(" ");
            byte[] byArray = new byte[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                byArray[i] = (byte)Integer.parseInt(stringArray[i]);
            }
            return new DHCPOption(by, byArray);
        }
        if (InetAddress.class.equals(clazz)) {
            try {
                return DHCPOption.newOptionAsInetAddress(by, InetAddress.getByName(string2));
            }
            catch (UnknownHostException unknownHostException) {
                s_aLogger.error("Invalid address:" + string2, (Throwable)unknownHostException);
                return null;
            }
        }
        if (InetAddress[].class.equals(clazz)) {
            String[] stringArray = string2.split(" ");
            InetAddress[] inetAddressArray = new InetAddress[stringArray.length];
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    inetAddressArray[i] = InetAddress.getByName(stringArray[i]);
                }
            }
            catch (UnknownHostException unknownHostException) {
                s_aLogger.error("Invalid address", (Throwable)unknownHostException);
                return null;
            }
            return DHCPOption.newOptionAsInetAddresses(by, inetAddressArray);
        }
        return null;
    }

    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        for (Byte by : DHCPConstants._DHO_NAMES.keySet()) {
            byte by2 = by;
            String string10 = "";
            if (by2 != 0 && by2 != -1) {
                string10 = " * " + DHCPConstants._DHO_NAMES.get(by) + '(' + (by2 & 0xFF) + ")\n";
            }
            string = string + string10;
            if (!_DHO_FORMATS.containsKey(by)) continue;
            switch (_DHO_FORMATS.get(by)) {
                case INET: {
                    string2 = string2 + string10;
                    break;
                }
                case INETS: {
                    string3 = string3 + string10;
                    break;
                }
                case INT: {
                    string4 = string4 + string10;
                    break;
                }
                case SHORT: {
                    string5 = string5 + string10;
                    break;
                }
                case SHORTS: {
                    string6 = string6 + string10;
                    break;
                }
                case BYTE: {
                    string7 = string7 + string10;
                    break;
                }
                case BYTES: {
                    string8 = string8 + string10;
                    break;
                }
                case STRING: {
                    string9 = string9 + string10;
                    break;
                }
            }
        }
        s_aLogger.info("---All codes---");
        s_aLogger.info(string);
        s_aLogger.info("---INET---");
        s_aLogger.info(string2);
        s_aLogger.info("---INETS---");
        s_aLogger.info(string3);
        s_aLogger.info("---INT---");
        s_aLogger.info(string4);
        s_aLogger.info("---SHORT---");
        s_aLogger.info(string5);
        s_aLogger.info("---SHORTS---");
        s_aLogger.info(string6);
        s_aLogger.info("---BYTE---");
        s_aLogger.info(string7);
        s_aLogger.info("---BYTES---");
        s_aLogger.info(string8);
        s_aLogger.info("---STRING---");
        s_aLogger.info(string9);
    }

    static {
        for (int i = 0; i < _OPTION_FORMATS.length / 2; ++i) {
            _DHO_FORMATS.put((Byte)_OPTION_FORMATS[i * 2], (EOptionFormat)((Object)_OPTION_FORMATS[i * 2 + 1]));
        }
    }

    static enum EOptionFormat {
        INET,
        INETS,
        INT,
        SHORT,
        SHORTS,
        BYTE,
        BYTES,
        STRING;

    }
}

