/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dnsresolver.netty;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.dns.DnsPtrRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.resolver.dns.DnsCacheEntry;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.opennms.netmgt.dnsresolver.netty.CaffeineCache;
import org.opennms.netmgt.dnsresolver.netty.ExtendedDnsCache;
import org.opennms.netmgt.dnsresolver.netty.ExtendedDnsCacheEntry;

public class CaffeineDnsCache
implements ExtendedDnsCache {
    protected static final int MAX_SUPPORTED_TTL_SECS = (int)TimeUnit.DAYS.toSeconds(730L);
    protected static final int DEFAULT_NEGATIVE_TTL_SECS = (int)TimeUnit.MINUTES.toSeconds(5L);
    protected static final int DEFAULT_MAX_SIZE = 10000;
    private final CaffeineCache<ExtendedDnsCacheEntry> resolveCache;
    private final int minTtl;
    private final int maxTtl;
    private final int negativeTtl;
    private final long maxSize;
    private final Meter cacheHits = new Meter();
    private final Meter cacheMisses = new Meter();

    public CaffeineDnsCache() {
        this(0, MAX_SUPPORTED_TTL_SECS, DEFAULT_NEGATIVE_TTL_SECS, 10000L);
    }

    public CaffeineDnsCache(int minTtl, int maxTtl, int negativeTtl, long maxSize) {
        this.minTtl = Math.min(MAX_SUPPORTED_TTL_SECS, ObjectUtil.checkPositiveOrZero((int)minTtl, (String)"minTtl"));
        this.maxTtl = Math.min(MAX_SUPPORTED_TTL_SECS, ObjectUtil.checkPositiveOrZero((int)maxTtl, (String)"maxTtl"));
        Preconditions.checkArgument((minTtl <= maxTtl ? 1 : 0) != 0, (Object)("minTtl: " + minTtl + ", maxTtl: " + maxTtl + " (expected: 0 <= minTtl <= maxTtl)"));
        this.negativeTtl = ObjectUtil.checkPositiveOrZero((int)negativeTtl, (String)"negativeTtl");
        this.maxSize = ObjectUtil.checkPositiveOrZero((long)maxSize, (String)"maxSize");
        this.resolveCache = new CaffeineCache<ExtendedDnsCacheEntry>(maxSize){

            @Override
            protected boolean shouldReplaceAll(ExtendedDnsCacheEntry entry) {
                return entry.cause() != null;
            }
        };
    }

    public int minTtl() {
        return this.minTtl;
    }

    public int maxTtl() {
        return this.maxTtl;
    }

    public int negativeTtl() {
        return this.negativeTtl;
    }

    public long maxSize() {
        return this.maxSize;
    }

    public void clear() {
        this.resolveCache.clear();
    }

    public boolean clear(String hostname) {
        ObjectUtil.checkNotNull((Object)hostname, (String)"hostname");
        this.resolveCache.clear(CaffeineDnsCache.ensureTrailingDot(hostname));
        return false;
    }

    public List<? extends DnsCacheEntry> get(String hostname, DnsRecord[] additionals) {
        ObjectUtil.checkNotNull((Object)hostname, (String)"hostname");
        if (!CaffeineDnsCache.emptyAdditionals(additionals)) {
            return Collections.emptyList();
        }
        Collection<ExtendedDnsCacheEntry> cachedEntries = this.resolveCache.get(CaffeineDnsCache.ensureTrailingDot(hostname));
        if (cachedEntries == null) {
            this.cacheMisses.mark();
            return null;
        }
        this.cacheHits.mark();
        return new LinkedList<ExtendedDnsCacheEntry>(cachedEntries);
    }

    public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, InetAddress address, long originalTtl, EventLoop loop) {
        ObjectUtil.checkNotNull((Object)hostname, (String)"hostname");
        ObjectUtil.checkNotNull((Object)address, (String)"address");
        ObjectUtil.checkNotNull((Object)loop, (String)"loop");
        DefaultExtendedDnsCacheEntry e = new DefaultExtendedDnsCacheEntry(hostname, address);
        if (this.maxTtl == 0 || !CaffeineDnsCache.emptyAdditionals(additionals)) {
            return e;
        }
        this.resolveCache.cache(CaffeineDnsCache.ensureTrailingDot(hostname), e, Math.max(this.minTtl, (int)Math.min((long)this.maxTtl, originalTtl)));
        return e;
    }

    @Override
    public ExtendedDnsCacheEntry cache(String hostname, DnsPtrRecord ptrRecord, EventLoop loop) {
        ObjectUtil.checkNotNull((Object)hostname, (String)"hostname");
        ObjectUtil.checkNotNull((Object)ptrRecord, (String)"ptrRecord");
        ObjectUtil.checkNotNull((Object)loop, (String)"loop");
        DefaultExtendedDnsCacheEntry e = new DefaultExtendedDnsCacheEntry(hostname, ptrRecord);
        if (this.maxTtl == 0) {
            return e;
        }
        this.resolveCache.cache(CaffeineDnsCache.ensureTrailingDot(hostname), e, Math.max(this.minTtl, (int)Math.min((long)this.maxTtl, ptrRecord.timeToLive())));
        return e;
    }

    public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, Throwable cause, EventLoop loop) {
        ObjectUtil.checkNotNull((Object)hostname, (String)"hostname");
        ObjectUtil.checkNotNull((Object)cause, (String)"cause");
        ObjectUtil.checkNotNull((Object)loop, (String)"loop");
        DefaultExtendedDnsCacheEntry e = new DefaultExtendedDnsCacheEntry(hostname, cause);
        if (this.negativeTtl == 0 || !CaffeineDnsCache.emptyAdditionals(additionals)) {
            return e;
        }
        this.resolveCache.cache(CaffeineDnsCache.ensureTrailingDot(hostname), e, this.negativeTtl);
        return e;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("minTtl", this.minTtl).add("maxTtl", this.maxTtl).add("negativeTtl", this.negativeTtl).add("cached resolved hostname=", this.resolveCache.size()).toString();
    }

    public long getSize() {
        return this.resolveCache.size();
    }

    public void registerMetrics(MetricRegistry metrics) {
        for (CacheMetric cm : CacheMetric.values()) {
            metrics.register(cm.getName(), cm.getMetric(this));
        }
    }

    public void unregisterMetrics(MetricRegistry metrics) {
        for (CacheMetric cm : CacheMetric.values()) {
            metrics.remove(cm.getName());
        }
    }

    private static boolean emptyAdditionals(DnsRecord[] additionals) {
        return additionals == null || additionals.length == 0;
    }

    private static String ensureTrailingDot(String hostname) {
        return StringUtil.endsWith((CharSequence)hostname, (char)'.') ? hostname : hostname + '.';
    }

    private static final class DefaultExtendedDnsCacheEntry
    implements ExtendedDnsCacheEntry {
        private final String hostname;
        private final String hostnameFromPtrRecord;
        private final InetAddress address;
        private final Throwable cause;

        DefaultExtendedDnsCacheEntry(String hostname, InetAddress address) {
            this.hostname = hostname;
            this.address = address;
            this.cause = null;
            this.hostnameFromPtrRecord = null;
        }

        DefaultExtendedDnsCacheEntry(String hostname, Throwable cause) {
            this.hostname = hostname;
            this.cause = cause;
            this.address = null;
            this.hostnameFromPtrRecord = null;
        }

        public DefaultExtendedDnsCacheEntry(String hostname, DnsPtrRecord ptrRecord) {
            this.hostname = hostname;
            this.hostnameFromPtrRecord = ptrRecord.hostname();
            this.address = null;
            this.cause = null;
        }

        public InetAddress address() {
            return this.address;
        }

        public Throwable cause() {
            return this.cause;
        }

        String hostname() {
            return this.hostname;
        }

        @Override
        public String hostnameFromPtrRecord() {
            return this.hostnameFromPtrRecord;
        }

        public String toString() {
            if (this.cause != null) {
                return this.hostname + '/' + this.cause;
            }
            if (this.hostnameFromPtrRecord != null) {
                return this.hostname + '/' + this.hostnameFromPtrRecord;
            }
            return this.hostname + '/' + this.address;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DefaultExtendedDnsCacheEntry)) {
                return false;
            }
            DefaultExtendedDnsCacheEntry that = (DefaultExtendedDnsCacheEntry)o;
            return Objects.equals(this.hostname, that.hostname) && Objects.equals(this.hostnameFromPtrRecord, that.hostnameFromPtrRecord) && Objects.equals(this.address, that.address) && Objects.equals(this.cause, that.cause);
        }

        public int hashCode() {
            return Objects.hash(this.hostname, this.hostnameFromPtrRecord, this.address, this.cause);
        }
    }

    private static enum CacheMetric {
        SIZE("cacheSize", c -> ((CaffeineDnsCache)c).resolveCache::size),
        MAX_SIZE("cacheMaxSize", c -> c::maxSize),
        EVICTION_COUNT("cacheEvictionCount", c -> () -> ((CacheStats)((CaffeineDnsCache)c).resolveCache.stats()).evictionCount()),
        HITS("cacheHits", c -> CaffeineDnsCache.access$100(c)),
        MISSES("cacheMisses", c -> CaffeineDnsCache.access$000(c));

        String name;
        Function<CaffeineDnsCache, Metric> metricSupplier;

        private CacheMetric(String name, Function<CaffeineDnsCache, Metric> metricSupplier) {
            this.name = Objects.requireNonNull(name);
            this.metricSupplier = Objects.requireNonNull(metricSupplier);
        }

        public String getName() {
            return this.name;
        }

        public Metric getMetric(CaffeineDnsCache cache) {
            return this.metricSupplier.apply(cache);
        }
    }
}

