/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.jexl2.ReadonlyContext;
import org.apache.commons.jexl2.UnifiedJEXL;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.Parameter;
import org.opennms.netmgt.collection.support.IndexStorageStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JexlIndexStorageStrategy
extends IndexStorageStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(JexlIndexStorageStrategy.class);
    private static final int DEFAULT_JEXLENGINE_CACHESIZE = 512;
    private static final String QUOTE = "\"";
    private static final String PARAM_INDEX_FORMAT = "index-format";
    private static final String PARAM_CLEAN_OUTPUT = "clean-output";
    private static final JexlEngine JEXL_ENGINE;
    private static final UnifiedJEXL EL;
    private final Map<String, String> m_parameters = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getResourceNameFromIndex(CollectionResource resource) {
        String resourceName = null;
        try {
            UnifiedJEXL.Expression expr = EL.parse(this.m_parameters.get(PARAM_INDEX_FORMAT));
            MapContext context = new MapContext();
            this.m_parameters.entrySet().forEach(arg_0 -> JexlIndexStorageStrategy.lambda$getResourceNameFromIndex$0((JexlContext)context, arg_0));
            this.updateContext((JexlContext)context, resource);
            resourceName = (String)expr.evaluate((JexlContext)new ReadonlyContext((JexlContext)context));
        }
        catch (JexlException e) {
            LOG.error("getResourceNameFromIndex(): error evaluating index-format [{}] as a Jexl Expression", (Object)this.m_parameters.get(PARAM_INDEX_FORMAT), (Object)e);
        }
        finally {
            if (resourceName == null) {
                resourceName = resource.getInstance();
            }
        }
        if ("true".equals(this.m_parameters.get(PARAM_CLEAN_OUTPUT)) && resourceName != null) {
            resourceName = resourceName.replaceAll("\\s+", "_").replaceAll(":", "_").replaceAll("\\\\", "_").replaceAll("[\\[\\]]", "_").replaceAll("[|/]", "_").replaceAll("=", "").replaceAll("[_]+$", "").replaceAll("___", "_");
        }
        LOG.debug("getResourceNameFromIndex(): {}", (Object)resourceName);
        return resourceName;
    }

    @Override
    public void setParameters(List<Parameter> parameterCollection) throws IllegalArgumentException {
        if (parameterCollection == null) {
            String msg = "Got a null parameter list, but need one containing a 'index-format' parameter.";
            LOG.error("Got a null parameter list, but need one containing a 'index-format' parameter.");
            throw new IllegalArgumentException("Got a null parameter list, but need one containing a 'index-format' parameter.");
        }
        parameterCollection.forEach(param -> {
            if (null == param.getKey()) {
                LOG.warn("Encountered unsupported parameter key=\"{}\". Can accept: {}, {}", new Object[]{param.getKey(), PARAM_INDEX_FORMAT, PARAM_CLEAN_OUTPUT});
            } else {
                this.m_parameters.put(param.getKey(), param.getValue());
            }
        });
        if (!this.m_parameters.containsKey(PARAM_INDEX_FORMAT)) {
            throw new IllegalArgumentException("Missing index-format expression");
        }
    }

    public void updateContext(JexlContext context, CollectionResource resource) throws IllegalArgumentException {
    }

    private static /* synthetic */ void lambda$getResourceNameFromIndex$0(JexlContext context, Map.Entry entry) {
        context.set((String)entry.getKey(), entry.getValue());
    }

    static {
        int cacheSize = SystemProperties.getInteger((String)"org.opennms.netmgt.dao.support.JEXLIndexStorageStrategy.cacheSize", (int)512);
        JEXL_ENGINE = new JexlEngine();
        JEXL_ENGINE.setCache(cacheSize);
        JEXL_ENGINE.setLenient(false);
        JEXL_ENGINE.setStrict(true);
        EL = new UnifiedJEXL(JEXL_ENGINE);
    }
}

