/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.camel.client;

import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.util.GlobalTracer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.ProducerTemplate;
import org.opennms.core.camel.JmsQueueNameFactory;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.common.AbstractMessageDispatcherFactory;
import org.opennms.core.tracing.api.TracerRegistry;
import org.opennms.core.tracing.util.TracingInfoCarrier;
import org.opennms.distributed.core.api.Identity;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.annotation.Autowired;

public class CamelRemoteMessageDispatcherFactory
extends AbstractMessageDispatcherFactory<Map<String, Object>> {
    @EndpointInject(uri="direct:sendMessage", context="sinkClient")
    private ProducerTemplate template;
    @EndpointInject(uri="direct:sendMessage", context="sinkClient")
    private Endpoint endpoint;
    private BundleContext bundleContext;
    @Autowired
    private TracerRegistry tracerRegistry;
    private Identity identity;

    public <S extends Message, T extends Message> Map<String, Object> getModuleMetadata(SinkModule<S, T> module) {
        JmsQueueNameFactory queueNameFactory = new JmsQueueNameFactory("Sink", module.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("JmsQueueName", queueNameFactory.getName());
        return Collections.unmodifiableMap(headers);
    }

    public <S extends Message, T extends Message> void dispatch(SinkModule<S, T> module, Map<String, Object> headers, T message) {
        HashMap<String, Object> messageHeaders = new HashMap<String, Object>(headers);
        module.getRoutingKey(message).ifPresent(id -> messageHeaders.put("JMSXGroupId", id));
        byte[] sinkMessageBytes = module.marshal(message);
        Tracer tracer = this.tracerRegistry.getTracer();
        if (tracer.activeSpan() != null) {
            TracingInfoCarrier tracingInfoCarrier = new TracingInfoCarrier();
            tracer.inject(tracer.activeSpan().context(), Format.Builtin.TEXT_MAP, (Object)tracingInfoCarrier);
            tracer.activeSpan().setTag("location", this.identity.getLocation());
            tracer.activeSpan().setTag("thread", Thread.currentThread().getName());
            if (messageHeaders.get("JmsQueueName") instanceof String) {
                tracer.activeSpan().setTag("topic", (String)messageHeaders.get("JmsQueueName"));
            }
            tracer.activeSpan().setTag("messageSize", (Number)sinkMessageBytes.length);
            String tracingInfo = TracingInfoCarrier.marshalTracingInfo((Map)tracingInfoCarrier.getTracingInfoMap());
            if (tracingInfo != null) {
                messageHeaders.put("SinkTracingInfo", tracingInfo);
            }
        }
        this.template.sendBodyAndHeaders(this.endpoint, (Object)sinkMessageBytes, messageHeaders);
    }

    public String getMetricDomain() {
        return "org.opennms.core.ipc.sink.producer";
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void init() {
        if (this.tracerRegistry != null && this.identity != null) {
            this.tracerRegistry.init(this.identity.getLocation() + "@" + this.identity.getId());
        }
        this.onInit();
    }

    public void destroy() {
        this.onDestroy();
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public TracerRegistry getTracerRegistry() {
        return this.tracerRegistry;
    }

    public Tracer getTracer() {
        if (this.getTracerRegistry() != null) {
            return this.getTracerRegistry().getTracer();
        }
        return GlobalTracer.get();
    }

    public void setTracerRegistry(TracerRegistry tracerRegistry) {
        this.tracerRegistry = tracerRegistry;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public void setIdentity(Identity identity) {
        this.identity = identity;
    }
}

