/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.policies;

import java.util.Map;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.provision.BasePolicy;
import org.opennms.netmgt.provision.IpInterfacePolicy;
import org.opennms.netmgt.provision.annotations.Policy;
import org.opennms.netmgt.provision.annotations.Require;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Policy(value="Match IP Interface")
public class MatchingIpInterfacePolicy
extends BasePolicy<OnmsIpInterface>
implements IpInterfacePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(MatchingIpInterfacePolicy.class);
    private Action m_action = Action.DO_NOT_PERSIST;

    @Require(value={"MANAGE", "UNMANAGE", "DO_NOT_PERSIST", "ENABLE_SNMP_POLL", "DISABLE_SNMP_POLL", "ENABLE_COLLECTION", "DISABLE_COLLECTION"})
    public String getAction() {
        return this.m_action.toString();
    }

    public void setAction(String action) {
        this.m_action = Action.MANAGE.toString().equalsIgnoreCase(action) ? Action.MANAGE : (Action.UNMANAGE.toString().equalsIgnoreCase(action) ? Action.UNMANAGE : (Action.ENABLE_SNMP_POLL.toString().equalsIgnoreCase(action) ? Action.ENABLE_SNMP_POLL : (Action.DISABLE_SNMP_POLL.toString().equalsIgnoreCase(action) ? Action.DISABLE_SNMP_POLL : (action != null && action.equalsIgnoreCase("ENABLE_COLLECTION") ? Action.ENABLE_COLLECTION : (action != null && action.equalsIgnoreCase("DISABLE_COLLECTION") ? Action.DISABLE_COLLECTION : Action.DO_NOT_PERSIST)))));
    }

    public OnmsIpInterface act(OnmsIpInterface iface, Map<String, Object> attributes) {
        OnmsSnmpInterface snmpiface = iface.getSnmpInterface();
        switch (this.m_action) {
            case DO_NOT_PERSIST: {
                LOG.debug("NOT Persisting {} according to policy", (Object)iface);
                return null;
            }
            case MANAGE: {
                LOG.debug("Managing {} according to policy", (Object)iface);
                iface.setIsManaged("M");
                return iface;
            }
            case UNMANAGE: {
                LOG.debug("Unmanaging {} according to policy", (Object)iface);
                iface.setIsManaged("U");
                return iface;
            }
            case ENABLE_SNMP_POLL: {
                LOG.debug("SNMP polling {} according to policy", (Object)iface);
                snmpiface.setPoll("P");
                iface.setSnmpInterface(snmpiface);
                return iface;
            }
            case DISABLE_SNMP_POLL: {
                LOG.debug("Disable SNMP polling {} according to policy", (Object)iface);
                snmpiface.setPoll("N");
                iface.setSnmpInterface(snmpiface);
                return iface;
            }
            case DISABLE_COLLECTION: {
                LOG.debug("Disabled collection for {} according to policy", (Object)iface);
                snmpiface.setCollectionEnabled(false);
                iface.setSnmpInterface(snmpiface);
                return iface;
            }
            case ENABLE_COLLECTION: {
                LOG.debug("Enabled collection for {} according to policy", (Object)iface);
                snmpiface.setCollectionEnabled(true);
                iface.setSnmpInterface(snmpiface);
                return iface;
            }
        }
        return iface;
    }

    public void setIpAddress(String ipAddress) {
        this.putCriteria("ipAddress", ipAddress);
    }

    public String getIpAddress() {
        return this.getCriteria("ipAddress");
    }

    public void setHostName(String hostName) {
        this.putCriteria("ipHostName", hostName);
    }

    public String getHostName() {
        return this.getCriteria("ipHostName");
    }

    public static enum Action {
        MANAGE,
        UNMANAGE,
        DO_NOT_PERSIST,
        ENABLE_SNMP_POLL,
        DISABLE_SNMP_POLL,
        ENABLE_COLLECTION,
        DISABLE_COLLECTION;

    }
}

