/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.client.rpc;

import com.google.common.base.Strings;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.utils.mate.FallbackScope;
import org.opennms.core.rpc.utils.mate.Interpolator;
import org.opennms.core.rpc.utils.mate.Scope;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.provision.DetectRequest;
import org.opennms.netmgt.provision.DetectResults;
import org.opennms.netmgt.provision.DetectorRequestBuilder;
import org.opennms.netmgt.provision.ServiceDetector;
import org.opennms.netmgt.provision.ServiceDetectorFactory;
import org.opennms.netmgt.provision.detector.client.rpc.DetectorRequestDTO;
import org.opennms.netmgt.provision.detector.client.rpc.LocationAwareDetectorClientRpcImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectorRequestBuilderImpl
implements DetectorRequestBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DetectorRequestBuilderImpl.class);
    private static final String PORT = "port";
    private String location;
    private String systemId;
    private String className;
    private InetAddress address;
    private Integer nodeId;
    private Map<String, String> attributes = new HashMap<String, String>();
    private final LocationAwareDetectorClientRpcImpl client;

    public DetectorRequestBuilderImpl(LocationAwareDetectorClientRpcImpl client) {
        this.client = client;
    }

    public DetectorRequestBuilder withLocation(String location) {
        this.location = location;
        return this;
    }

    public DetectorRequestBuilder withSystemId(String systemId) {
        this.systemId = systemId;
        return this;
    }

    public DetectorRequestBuilder withClassName(String className) {
        this.className = className;
        return this;
    }

    public DetectorRequestBuilder withServiceName(String serviceName) {
        ServiceDetector detector = this.client.getRegistry().getDetectorByServiceName(serviceName);
        if (detector == null) {
            throw new IllegalArgumentException("No detector found with service name '" + serviceName + "'.");
        }
        this.className = this.client.getRegistry().getDetectorClassNameFromServiceName(serviceName);
        return this;
    }

    public DetectorRequestBuilder withAddress(InetAddress address) {
        this.address = address;
        return this;
    }

    public DetectorRequestBuilder withAttributes(Map<String, String> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public DetectorRequestBuilder withAttribute(String key, String value) {
        this.attributes.put(key, value);
        return this;
    }

    public DetectorRequestBuilder withNodeId(Integer nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public CompletableFuture<Boolean> execute() {
        if (this.address == null) {
            throw new IllegalArgumentException("Address is required.");
        }
        if (this.className == null) {
            throw new IllegalArgumentException("Detector class name is required.");
        }
        Map interpolatedAttributes = Interpolator.interpolateStrings(this.attributes, (Scope)new FallbackScope(new Scope[]{this.client.getEntityScopeProvider().getScopeForNode(this.nodeId), this.client.getEntityScopeProvider().getScopeForInterface(this.nodeId, InetAddressUtils.toIpAddrString((InetAddress)this.address))}));
        ServiceDetectorFactory factory = this.client.getRegistry().getDetectorFactoryByClassName(this.className);
        if (factory == null) {
            throw new IllegalArgumentException("No factory found for detector with class name '" + this.className + "'.");
        }
        DetectorRequestDTO detectorRequestDTO = new DetectorRequestDTO();
        detectorRequestDTO.setLocation(this.location);
        detectorRequestDTO.setSystemId(this.systemId);
        detectorRequestDTO.setClassName(this.className);
        detectorRequestDTO.setAddress(this.address);
        String timeToLive = (String)interpolatedAttributes.get("ttl");
        if (!Strings.isNullOrEmpty((String)timeToLive)) {
            Long ttlFromMetadata = ParameterMap.getLongValue((String)"ttl", interpolatedAttributes.get("ttl"), null);
            detectorRequestDTO.setTimeToLiveMs(ttlFromMetadata);
            interpolatedAttributes.remove("ttl");
        }
        detectorRequestDTO.addDetectorAttributes(interpolatedAttributes);
        detectorRequestDTO.addTracingInfo("className", this.className);
        detectorRequestDTO.addTracingInfo("ipAddress", InetAddressUtils.toIpAddrString((InetAddress)this.address));
        Integer port = null;
        String portString = (String)interpolatedAttributes.get(PORT);
        if (portString != null) {
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Failed to parse port as integer from: ", (Object)portString);
            }
        }
        DetectRequest request = factory.buildRequest(this.location, this.address, port, interpolatedAttributes);
        detectorRequestDTO.addRuntimeAttributes(request.getRuntimeAttributes());
        return this.client.getDelegate().execute((RpcRequest)detectorRequestDTO).thenApply(response -> {
            try {
                factory.afterDetect(request, (DetectResults)response, this.nodeId);
            }
            catch (Throwable t) {
                LOG.error("Error while processing detect callback.", t);
            }
            return response.isDetected();
        });
    }
}

