/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.groups;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.config.groups.Header;
import org.opennms.netmgt.config.groups.Role;

@XmlRootElement(name="groupinfo")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="groups.xsd")
public class Groupinfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="header")
    private Header m_header;
    @XmlElementWrapper(name="groups")
    @XmlElement(name="group")
    private List<Group> m_groups;
    @XmlElementWrapper(name="roles")
    @XmlElement(name="role")
    private List<Role> m_roles;

    public Header getHeader() {
        return this.m_header;
    }

    public void setHeader(Header header) {
        this.m_header = header;
    }

    public List<Group> getGroups() {
        return this.m_groups == null ? Collections.emptyList() : this.m_groups;
    }

    public void setGroups(List<Group> groups) {
        this.m_groups = groups;
    }

    public void addGroup(Group group) {
        if (this.m_groups == null && group != null) {
            this.m_groups = new ArrayList<Group>();
        }
        this.m_groups.add(group);
    }

    public List<Role> getRoles() {
        return this.m_roles == null ? Collections.emptyList() : this.m_roles;
    }

    public void setRoles(List<Role> roles) {
        this.m_roles = roles;
    }

    public int hashCode() {
        return Objects.hash(this.m_header, this.m_groups, this.m_roles);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Groupinfo) {
            Groupinfo that = (Groupinfo)obj;
            return Objects.equals(this.m_header, that.m_header) && Objects.equals(this.m_groups, that.m_groups) && Objects.equals(this.m_roles, that.m_roles);
        }
        return false;
    }

    public String toString() {
        return "Groupinfo [header=" + this.m_header + ", groups=" + this.m_groups + ", roles=" + this.m_roles + "]";
    }
}

