/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.persistence.api;

import com.google.common.base.Strings;

public interface RuleDefinition {
    public String getName();

    public String getDstAddress();

    public String getDstPort();

    public String getSrcPort();

    public String getSrcAddress();

    public String getProtocol();

    public String getExporterFilter();

    public int getGroupPosition();

    public int getPosition();

    default public boolean hasProtocolDefinition() {
        return RuleDefinition.isDefined(this.getProtocol());
    }

    default public boolean hasDstAddressDefinition() {
        return RuleDefinition.isDefined(this.getDstAddress());
    }

    default public boolean hasDstPortDefinition() {
        return RuleDefinition.isDefined(this.getDstPort());
    }

    default public boolean hasSrcAddressDefinition() {
        return RuleDefinition.isDefined(this.getSrcAddress());
    }

    default public boolean hasSrcPortDefinition() {
        return RuleDefinition.isDefined(this.getSrcPort());
    }

    default public boolean hasExportFilterDefinition() {
        return RuleDefinition.isDefined(this.getExporterFilter());
    }

    default public boolean hasDefinition() {
        return this.hasProtocolDefinition() || this.hasDstAddressDefinition() || this.hasDstPortDefinition() || this.hasSrcAddressDefinition() || this.hasSrcPortDefinition() || this.hasExportFilterDefinition();
    }

    public static boolean isDefined(String value) {
        return !Strings.isNullOrEmpty((String)value);
    }
}

