/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.internal;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public final class InMemoryBulkheadRegistry
extends AbstractRegistry<Bulkhead, BulkheadConfig>
implements BulkheadRegistry {
    public InMemoryBulkheadRegistry() {
        this(BulkheadConfig.ofDefaults());
    }

    public InMemoryBulkheadRegistry(Map<String, BulkheadConfig> configs) {
        this(configs.getOrDefault("default", BulkheadConfig.ofDefaults()));
        this.configurations.putAll(configs);
    }

    public InMemoryBulkheadRegistry(BulkheadConfig defaultConfig) {
        super((Object)defaultConfig);
    }

    @Override
    public Seq<Bulkhead> getAllBulkheads() {
        return Array.ofAll(this.entryMap.values());
    }

    @Override
    public Bulkhead bulkhead(String name) {
        return this.bulkhead(name, (BulkheadConfig)this.getDefaultConfig());
    }

    @Override
    public Bulkhead bulkhead(String name, BulkheadConfig config) {
        return (Bulkhead)this.computeIfAbsent(name, () -> Bulkhead.of(name, Objects.requireNonNull(config, "Config must not be null")));
    }

    @Override
    public Bulkhead bulkhead(String name, Supplier<BulkheadConfig> bulkheadConfigSupplier) {
        return (Bulkhead)this.computeIfAbsent(name, () -> Bulkhead.of(name, (BulkheadConfig)Objects.requireNonNull(Objects.requireNonNull(bulkheadConfigSupplier, "Supplier must not be null").get(), "Config must not be null")));
    }

    @Override
    public Bulkhead bulkhead(String name, String configName) {
        return (Bulkhead)this.computeIfAbsent(name, () -> Bulkhead.of(name, (BulkheadConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName))));
    }
}

