/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.camel;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.camel.component.properties.PropertiesFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexNameFunction
implements PropertiesFunction {
    private static final Logger LOG = LoggerFactory.getLogger(IndexNameFunction.class);
    public static final String DEFAULT_INDEX_DATE_FORMAT = "yyyy.MM";
    private final SimpleDateFormat m_df;

    public IndexNameFunction() {
        this(DEFAULT_INDEX_DATE_FORMAT);
    }

    public IndexNameFunction(String dateFormat) {
        this.m_df = new SimpleDateFormat(dateFormat == null ? DEFAULT_INDEX_DATE_FORMAT : dateFormat);
    }

    public String getName() {
        return "index";
    }

    public String apply(String remainder) {
        return IndexNameFunction.apply(this.m_df, remainder, new Date());
    }

    public String apply(String remainder, Date date) {
        return IndexNameFunction.apply(this.m_df, remainder, date);
    }

    public static String apply(SimpleDateFormat df, String remainder, Date date) {
        String result = remainder.toLowerCase() + "-" + df.format(date);
        if (LOG.isTraceEnabled()) {
            LOG.trace("IndexNameFunction.apply=" + result);
        }
        return result;
    }
}

